/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.ProjectionImpl;

public class Geostationary
extends AbstractCoordTransBuilder {
    @Override
    public String getTransformName() {
        return "Geostationary";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        this.readStandardParams(ds, ctv);
        double height = this.readAttributeDouble(ctv, "perspective_point_height", Double.NaN);
        String sweep_angle = this.readAttribute(ctv, "sweep_angle_axis", null);
        String fixed_angle = this.readAttribute(ctv, "fixed_angle_axis", null);
        if (sweep_angle == null && fixed_angle == null) {
            throw new IllegalArgumentException("Must specify sweep_angle_axis or fixed_angle_axis");
        }
        if (sweep_angle != null) {
            boolean isSweepX = sweep_angle.equals("x");
        } else {
            boolean isSweepX = fixed_angle.equals("y");
        }
        ProjectionImpl proj = null;
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

