/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.conv.CSMConvention;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;

public class GDVConvention
extends CSMConvention {
    protected ProjectionCT projCT = null;

    public GDVConvention() {
        this.conventionName = "GDV";
        this.checkForMeter = false;
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        this.projCT = this.makeProjectionCT(ds);
        if (this.projCT != null) {
            VariableDS v = this.makeCoordinateTransformVariable(ds, this.projCT);
            ds.addVariable(null, v);
            String xname = this.findCoordinateName(ds, AxisType.GeoX);
            String yname = this.findCoordinateName(ds, AxisType.GeoY);
            if (xname != null && yname != null) {
                v.addAttribute(new Attribute("_CoordinateAxes", xname + " " + yname));
            }
        }
        ds.finish();
    }

    @Override
    protected void findCoordinateAxes(NetcdfDataset ds) {
        for (CoordSysBuilder.VarProcess vp : this.varList) {
            Dimension dim;
            String dimName;
            Variable ncvar;
            if (vp.isCoordinateVariable || !((ncvar = vp.v) instanceof VariableDS) || (dimName = this.findAlias(ds, ncvar)).length() == 0 || null == (dim = ds.findDimension(dimName))) continue;
            vp.isCoordinateAxis = true;
            this.parseInfo.format(" Coordinate Axis added (GDV alias) = %s for dimension %s\n", vp.v.getFullName(), dimName);
        }
        super.findCoordinateAxes(ds);
        this.findCoordinateAxesForce(ds);
    }

    private void findCoordinateAxesForce(NetcdfDataset ds) {
        HashMap<AxisType, CoordSysBuilder.VarProcess> map = new HashMap<AxisType, CoordSysBuilder.VarProcess>();
        for (CoordSysBuilder.VarProcess vp : this.varList) {
            AxisType atype;
            if (!vp.isCoordinateAxis || (atype = this.getAxisType(ds, (VariableEnhanced)((Object)vp.v))) == null) continue;
            map.put(atype, vp);
        }
        for (CoordSysBuilder.VarProcess vp : this.varList) {
            AxisType atype;
            Variable ncvar;
            if (vp.isCoordinateVariable || !((ncvar = vp.v) instanceof VariableDS) || (atype = this.getAxisType(ds, (VariableEnhanced)((Object)vp.v))) == null || map.get((Object)atype) != null) continue;
            vp.isCoordinateAxis = true;
            this.parseInfo.format(" Coordinate Axis added (GDV forced) = %s  for axis %s\n", new Object[]{vp.v.getFullName(), atype});
        }
    }

    private String findCoordinateName(NetcdfDataset ds, AxisType axisType) {
        List<Variable> vlist = ds.getVariables();
        for (Variable aVlist : vlist) {
            VariableEnhanced ve = (VariableEnhanced)((Object)aVlist);
            if (axisType != this.getAxisType(ds, ve)) continue;
            return ve.getFullName();
        }
        return null;
    }

    @Override
    protected void makeCoordinateTransforms(NetcdfDataset ds) {
        CoordSysBuilder.VarProcess vp;
        if (this.projCT != null && (vp = this.findVarProcess(this.projCT.getName(), null)) != null) {
            vp.ct = this.projCT;
        }
        super.makeCoordinateTransforms(ds);
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getShortName();
        if (vname.equalsIgnoreCase("x") || this.findAlias(ds, v).equalsIgnoreCase("x")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon") || vname.equalsIgnoreCase("longitude") || this.findAlias(ds, v).equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y") || this.findAlias(ds, v).equalsIgnoreCase("y")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat") || vname.equalsIgnoreCase("latitude") || this.findAlias(ds, v).equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("lev") || this.findAlias(ds, v).equalsIgnoreCase("lev") || vname.equalsIgnoreCase("level") || this.findAlias(ds, v).equalsIgnoreCase("level")) {
            return AxisType.GeoZ;
        }
        if (vname.equalsIgnoreCase("z") || this.findAlias(ds, v).equalsIgnoreCase("z") || vname.equalsIgnoreCase("altitude") || vname.equalsIgnoreCase("depth")) {
            return AxisType.Height;
        }
        if (vname.equalsIgnoreCase("time") || this.findAlias(ds, v).equalsIgnoreCase("time")) {
            return AxisType.Time;
        }
        return super.getAxisType(ds, ve);
    }

    private String findAlias(NetcdfDataset ds, Variable v) {
        String alias = ds.findAttValueIgnoreCase(v, "coord_axis", null);
        if (alias == null) {
            alias = ds.findAttValueIgnoreCase(v, "coord_alias", "");
        }
        return alias;
    }

    private ProjectionCT makeProjectionCT(NetcdfDataset ds) {
        ProjectionImpl proj;
        String projection = ds.findAttValueIgnoreCase(null, "projection", null);
        if (null == projection) {
            this.parseInfo.format("GDV Conventions error: NO projection name found \n", new Object[0]);
            return null;
        }
        String params = ds.findAttValueIgnoreCase(null, "projection_params", null);
        if (null == params) {
            params = ds.findAttValueIgnoreCase(null, "proj_params", null);
        }
        if (null == params) {
            this.parseInfo.format("GDV Conventions error: NO projection parameters found \n", new Object[0]);
            return null;
        }
        int count = 0;
        double[] p = new double[4];
        try {
            StringTokenizer stoke = new StringTokenizer(params, " ,");
            while (stoke.hasMoreTokens() && count < 4) {
                p[count++] = Double.parseDouble(stoke.nextToken());
            }
        }
        catch (NumberFormatException e) {
            StringTokenizer stoke = new StringTokenizer(params, " ,");
            while (stoke.hasMoreTokens() && count < 4) {
                stoke.nextToken();
                p[count++] = Double.parseDouble(stoke.nextToken());
            }
        }
        this.parseInfo.format("GDV Conventions projection %s params = %f %f %f %f\n", projection, p[0], p[1], p[2], p[3]);
        if (projection.equalsIgnoreCase("LambertConformal")) {
            proj = new LambertConformal(p[0], p[1], p[2], p[3]);
        } else if (projection.equalsIgnoreCase("TransverseMercator")) {
            proj = new TransverseMercator(p[0], p[1], p[2]);
        } else if (projection.equalsIgnoreCase("Stereographic") || projection.equalsIgnoreCase("Oblique_Stereographic")) {
            proj = new Stereographic(p[0], p[1], p[2]);
        } else {
            this.parseInfo.format("GDV Conventions error: Unknown projection %s\n", projection);
            return null;
        }
        return new ProjectionCT(proj.getClassName(), "FGDC", proj);
    }
}

