/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.dl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.XMLEntityResolver;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateType;

public class DCWriter {
    private static final Namespace defNS = Namespace.getNamespace((String)"http://purl.org/dc/elements/1.1/");
    private static final String schemaLocation = defNS.getURI() + " http://www.unidata.ucar.edu/schemas/other/dc/dc.xsd";
    private static final String schemaLocationLocal = defNS.getURI() + " file://P:/schemas/other/dc/dc.xsd";
    private static String threddsServerURL = "http://localhost:8080/thredds/subset.html";
    private InvCatalog cat;

    public DCWriter(InvCatalog cat) {
        this.cat = cat;
    }

    public void writeItems(String fileDir) {
        File dir = new File(fileDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        List<InvDataset> datasets = this.cat.getDatasets();
        for (int i = 0; i < datasets.size(); ++i) {
            InvDataset elem = datasets.get(i);
            this.doDataset(elem, fileDir);
        }
    }

    private void doDataset(InvDataset ds, String fileDir) {
        if (ds.isHarvest() && ds.getID() != null) {
            String fileOutName = fileDir + "/" + ds.getID() + ".dc.xml";
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileOutName));
                this.writeOneItem(ds, System.out);
                this.writeOneItem(ds, out);
                ((OutputStream)out).close();
                return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        List<InvDataset> datasets = ds.getDatasets();
        for (int i = 0; i < datasets.size(); ++i) {
            InvDataset nested = datasets.get(i);
            this.doDataset(nested, fileDir);
        }
    }

    private void writeOneItem(InvDataset ds, OutputStream out) throws IOException {
        Element rootElem = new Element("dc", defNS);
        Document doc = new Document(rootElem);
        this.writeDataset(ds, rootElem);
        rootElem.addNamespaceDeclaration(XMLEntityResolver.xsiNS);
        rootElem.setAttribute("schemaLocation", defNS.getURI() + " " + schemaLocation, XMLEntityResolver.xsiNS);
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, out);
    }

    public void writeDataset(InvDataset ds, Element rootElem) {
        rootElem.addContent((Content)new Element("title", defNS).addContent(ds.getName()));
        rootElem.addContent((Content)new Element("Entry_ID", defNS).addContent(ds.getUniqueID()));
        List<Object> list = ds.getKeywords();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ThreddsMetadata.Vocab k = list.get(i);
                rootElem.addContent((Content)new Element("Keyword", defNS).addContent(k.getText()));
            }
        }
        CalendarDateRange tm = ds.getCalendarDateCoverage();
        Element tmElem = new Element("Temporal_Coverage", defNS);
        rootElem.addContent((Content)tmElem);
        tmElem.addContent((Content)new Element("Start_Date", defNS).addContent(tm.getStart().toString()));
        tmElem.addContent((Content)new Element("End_Date", defNS).addContent(tm.getEnd().toString()));
        ThreddsMetadata.GeospatialCoverage geo = ds.getGeospatialCoverage();
        Element geoElem = new Element("Spatial_Coverage", defNS);
        rootElem.addContent((Content)geoElem);
        geoElem.addContent((Content)new Element("Southernmost_Latitude", defNS).addContent(Double.toString(geo.getLatSouth())));
        geoElem.addContent((Content)new Element("Northernmost_Latitude", defNS).addContent(Double.toString(geo.getLatNorth())));
        geoElem.addContent((Content)new Element("Westernmost_Latitude", defNS).addContent(Double.toString(geo.getLonWest())));
        geoElem.addContent((Content)new Element("Easternmost_Latitude", defNS).addContent(Double.toString(geo.getLonEast())));
        rootElem.addContent((Content)new Element("Use_Constraints", defNS).addContent(ds.getDocumentation("rights")));
        list = ds.getPublishers();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ThreddsMetadata.Source p = (ThreddsMetadata.Source)list.get(i);
                Element dataCenter = new Element("Data_Center", defNS);
                rootElem.addContent((Content)dataCenter);
                this.writePublisher(p, dataCenter);
            }
        }
        rootElem.addContent((Content)new Element("Summary", defNS).addContent(ds.getDocumentation("summary")));
        Element primaryURLelem = new Element("Related_URL", defNS);
        rootElem.addContent((Content)primaryURLelem);
        String primaryURL = threddsServerURL + "?catalog=" + ((InvCatalogImpl)ds.getParentCatalog()).getBaseURI().toString() + "&dataset=" + ds.getID();
        primaryURLelem.addContent((Content)new Element("URL_Content_Type", defNS).addContent("THREDDS access page"));
        primaryURLelem.addContent((Content)new Element("URL", defNS).addContent(primaryURL));
        DateType today = new DateType(false, new Date());
        rootElem.addContent((Content)new Element("DIF_Creation_Date", defNS).addContent(today.toDateTimeStringISO()));
    }

    protected void writePublisher(ThreddsMetadata.Source p, Element dataCenter) {
        Element name = new Element("Data_Center_Name", defNS);
        dataCenter.addContent((Content)name);
        name.addContent((Content)new Element("Short_Name", defNS).addContent(p.getName()));
        if (p.getUrl() != null && p.getUrl().length() > 0) {
            dataCenter.addContent((Content)new Element("Data_Center_URL", defNS).addContent(p.getUrl()));
        }
        Element person = new Element("Personnel", defNS);
        dataCenter.addContent((Content)person);
        person.addContent((Content)new Element("Role", defNS).addContent("DATA CENTER CONTACT"));
        person.addContent((Content)new Element("Email", defNS).addContent(p.getEmail()));
    }

    private void writeVariable(Element param, ThreddsMetadata.Variable v) {
        String vname = v.getVocabularyName();
        StringTokenizer stoker = new StringTokenizer(vname, ">");
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Category", defNS).addContent(stoker.nextToken().trim()));
        }
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Topic", defNS).addContent(stoker.nextToken().trim()));
        }
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Term", defNS).addContent(stoker.nextToken().trim()));
        }
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Variable", defNS).addContent(stoker.nextToken().trim()));
        }
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Detailed_Variable", defNS).addContent(stoker.nextToken().trim()));
        }
    }

    private static void doOne(InvCatalogFactory fac, String url) {
        System.out.println("***read " + url);
        try {
            InvCatalogImpl cat = fac.readXML(url);
            StringBuilder buff = new StringBuilder();
            boolean isValid = cat.check(buff, false);
            System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            System.out.println(" validation output=\n" + buff);
            DCWriter w = new DCWriter(cat);
            w.writeItems("C:/temp/dif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        DCWriter.doOne(catFactory, "file:///C:/dev/thredds/catalog/test/data/TestHarvest.xml");
    }
}

