/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import thredds.catalog.CatalogSetCallback;
import thredds.catalog.CollectionType;
import thredds.catalog.DataFormatType;
import thredds.catalog.DatasetFilter;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.MetadataType;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateType;

public class InvCatalogRef
extends InvDatasetImpl {
    private String href;
    private InvDatasetImpl proxy = null;
    private URI uri = null;
    private String errMessage = null;
    private boolean init = false;
    private boolean useProxy = false;
    private boolean debug = false;
    private boolean debugProxy = false;
    private boolean debugAsynch = false;

    public InvCatalogRef(InvDatasetImpl parent, String name, String href) {
        super(parent, name);
        this.href = href.trim();
    }

    public String getXlinkHref() {
        return this.href;
    }

    public void setXlinkHref(String href) {
        this.href = href;
        this.uri = null;
    }

    public URI getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        try {
            return this.getParentCatalog().resolveUri(this.href);
        }
        catch (URISyntaxException e) {
            this.errMessage = "URISyntaxException on url  " + this.href + " = " + e.getMessage();
            return null;
        }
    }

    @Override
    public List<InvDataset> getDatasets() {
        this.read();
        return this.useProxy ? this.proxy.getDatasets() : super.getDatasets();
    }

    public boolean isRead() {
        return this.init;
    }

    public InvDatasetImpl getProxyDataset() {
        this.read();
        return this.proxy;
    }

    public void release() {
        this.datasets = new ArrayList();
        this.proxy = null;
        this.useProxy = false;
        this.init = false;
    }

    @Override
    public boolean finish() {
        return super.finish();
    }

    private synchronized void read() {
        if (this.init) {
            return;
        }
        URI uriResolved = this.getURI();
        if (uriResolved == null) {
            this.proxy = new InvDatasetImpl(null, "HREF ERROR");
            if (this.debug) {
                System.out.println(this.errMessage);
            }
            this.proxy.addProperty(new InvProperty("HREF ERROR", this.errMessage));
            this.datasets.add(this.proxy);
            this.init = true;
            return;
        }
        try {
            if (this.debug) {
                System.out.println(" InvCatalogRef read " + this.getFullName() + "  hrefResolved = " + uriResolved);
            }
            InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory(true);
            InvCatalogImpl cat = factory.readXML(uriResolved.toString());
            this.finishCatalog(cat);
        }
        catch (Exception e) {
            this.proxy = new InvDatasetImpl(null, "HREF ERROR");
            if (this.debug) {
                System.out.println("HREF ERROR =\n  " + this.href + " err= " + e.getMessage());
            }
            this.proxy.addProperty(new InvProperty("HREF ERROR", this.href));
            this.datasets.add(this.proxy);
            this.init = true;
        }
    }

    private void finishCatalog(InvCatalogImpl cat) {
        if (cat.hasFatalError()) {
            this.proxy = new InvDatasetImpl(null, "ERROR OPENING");
            StringBuilder out = new StringBuilder();
            cat.check(out);
            if (this.debug) {
                System.out.println("PARSE ERROR =\n  " + out.toString());
            }
            this.proxy.addProperty(new InvProperty("ERROR OPENING", out.toString()));
            this.proxy.finish();
        } else {
            InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
            DatasetFilter filter = parentCatalog.getDatasetFilter();
            if (filter != null) {
                cat.filter(filter);
            }
            this.proxy = cat.getDataset();
            if (this.proxy.getMark()) {
                this.proxy.setName(this.proxy.getName() + " (EMPTY)");
                this.proxy.addProperty(new InvProperty("isEmpty", "true"));
                this.proxy.finish();
            }
            String name = this.getName().trim();
            String proxyName = this.proxy.getName().trim();
            boolean bl = this.useProxy = proxyName.equals(name) && !(this.proxy instanceof InvCatalogRef);
            if (this.debugProxy) {
                System.out.println("catRefname=" + name + "=topName=" + proxyName + "=" + this.useProxy);
            }
        }
        this.datasets.add(this.proxy);
        this.init = true;
    }

    public synchronized void readAsynch(InvCatalogFactory factory, CatalogSetCallback caller) {
        String hrefResolved;
        if (this.init) {
            caller.setCatalog((InvCatalogImpl)this.getParentCatalog());
            return;
        }
        try {
            URI uri = this.getParentCatalog().resolveUri(this.href);
            hrefResolved = uri.toString();
        }
        catch (URISyntaxException e) {
            this.proxy = new InvDatasetImpl(null, "HREF ERROR");
            if (this.debug) {
                System.out.println("HREF ERROR =\n  " + this.href + " err= " + e.getMessage());
            }
            this.proxy.addProperty(new InvProperty("HREF ERROR", this.href));
            this.datasets.add(this.proxy);
            return;
        }
        try {
            if (this.debug) {
                System.out.println(" InvCatalogRef readXMLasynch " + this.getFullName() + "  hrefResolved = " + hrefResolved);
            }
            factory.readXMLasynch(hrefResolved, new Callback(caller));
        }
        catch (Exception e) {
            this.proxy = new InvDatasetImpl(null, "HREF ERROR");
            if (this.debug) {
                System.out.println("HREF ERROR =\n  " + this.href + " err= " + e.getMessage());
            }
            this.proxy.addProperty(new InvProperty("HREF ERROR", this.href));
            this.datasets.add(this.proxy);
        }
    }

    @Override
    boolean check(StringBuilder out, boolean show) {
        return this.isRead() ? this.proxy.check(out, show) : super.check(out, show);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvCatalogRef)) {
            return false;
        }
        InvCatalogRef invCatalogRef = (InvCatalogRef)o;
        if (this.href != null ? !this.href.equals(invCatalogRef.href) : invCatalogRef.href != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(invCatalogRef.name) : invCatalogRef.name != null);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 29 * result + (this.href != null ? this.href.hashCode() : 0);
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    @Override
    public InvDatasetImpl findDatasetByName(String p0) {
        return !this.useProxy ? super.findDatasetByName(p0) : this.proxy.findDatasetByName(p0);
    }

    @Override
    public String findProperty(String p0) {
        return !this.useProxy ? super.findProperty(p0) : this.proxy.findProperty(p0);
    }

    @Override
    public InvService findService(String p0) {
        return !this.useProxy ? super.findService(p0) : this.proxy.findService(p0);
    }

    @Override
    public InvAccess getAccess(ServiceType p0) {
        return !this.useProxy ? super.getAccess(p0) : this.proxy.getAccess(p0);
    }

    @Override
    public List<InvAccess> getAccess() {
        return !this.useProxy ? super.getAccess() : this.proxy.getAccess();
    }

    @Override
    public String getAlias() {
        return !this.useProxy ? super.getAlias() : this.proxy.getAlias();
    }

    @Override
    public String getAuthority() {
        return this.useProxy ? this.proxy.getAuthority() : super.getAuthority();
    }

    @Override
    public CollectionType getCollectionType() {
        return !this.useProxy ? super.getCollectionType() : this.proxy.getCollectionType();
    }

    @Override
    public List<ThreddsMetadata.Contributor> getContributors() {
        return !this.useProxy ? super.getContributors() : this.proxy.getContributors();
    }

    @Override
    public List<ThreddsMetadata.Source> getCreators() {
        return !this.useProxy ? super.getCreators() : this.proxy.getCreators();
    }

    @Override
    public DataFormatType getDataFormatType() {
        return !this.useProxy ? super.getDataFormatType() : this.proxy.getDataFormatType();
    }

    @Override
    public FeatureType getDataType() {
        return !this.useProxy ? super.getDataType() : this.proxy.getDataType();
    }

    @Override
    public List<DateType> getDates() {
        return !this.useProxy ? super.getDates() : this.proxy.getDates();
    }

    @Override
    public List<InvDocumentation> getDocumentation() {
        return !this.useProxy ? super.getDocumentation() : this.proxy.getDocumentation();
    }

    @Override
    public String getDocumentation(String p0) {
        return !this.useProxy ? super.getDocumentation(p0) : this.proxy.getDocumentation(p0);
    }

    @Override
    public String getFullName() {
        return !this.useProxy ? super.getFullName() : this.proxy.getFullName();
    }

    @Override
    public ThreddsMetadata.GeospatialCoverage getGeospatialCoverage() {
        return !this.useProxy ? super.getGeospatialCoverage() : this.proxy.getGeospatialCoverage();
    }

    @Override
    public String getID() {
        return !this.useProxy ? super.getID() : this.proxy.getID();
    }

    @Override
    public List<ThreddsMetadata.Vocab> getKeywords() {
        return !this.useProxy ? super.getKeywords() : this.proxy.getKeywords();
    }

    @Override
    protected boolean getMark() {
        return !this.useProxy ? super.getMark() : this.proxy.getMark();
    }

    @Override
    public List<InvMetadata> getMetadata(MetadataType p0) {
        return !this.useProxy ? super.getMetadata(p0) : this.proxy.getMetadata(p0);
    }

    @Override
    public List<InvMetadata> getMetadata() {
        return !this.useProxy ? super.getMetadata() : this.proxy.getMetadata();
    }

    @Override
    public String getName() {
        if (!this.useProxy) {
            return super.getName();
        }
        return this.proxy == null ? "N/A" : this.proxy.getName();
    }

    @Override
    public InvDataset getParent() {
        return !this.useProxy ? super.getParent() : this.proxy.getParent();
    }

    @Override
    public List<ThreddsMetadata.Vocab> getProjects() {
        return !this.useProxy ? super.getProjects() : this.proxy.getProjects();
    }

    @Override
    public List<InvProperty> getProperties() {
        return !this.useProxy ? super.getProperties() : this.proxy.getProperties();
    }

    @Override
    public List<ThreddsMetadata.Source> getPublishers() {
        return !this.useProxy ? super.getPublishers() : this.proxy.getPublishers();
    }

    @Override
    public InvService getServiceDefault() {
        return !this.useProxy ? super.getServiceDefault() : this.proxy.getServiceDefault();
    }

    @Override
    public CalendarDateRange getCalendarDateCoverage() {
        return !this.useProxy ? super.getCalendarDateCoverage() : this.proxy.getCalendarDateCoverage();
    }

    @Override
    public String getUniqueID() {
        return !this.useProxy ? super.getUniqueID() : this.proxy.getUniqueID();
    }

    @Override
    public String getUrlPath() {
        return !this.useProxy ? super.getUrlPath() : this.proxy.getUrlPath();
    }

    @Override
    public Object getUserProperty(Object p0) {
        return !this.useProxy ? super.getUserProperty(p0) : this.proxy.getUserProperty(p0);
    }

    @Override
    public List<ThreddsMetadata.Variables> getVariables() {
        return !this.useProxy ? super.getVariables() : this.proxy.getVariables();
    }

    @Override
    public String getVariableMapLink() {
        return !this.useProxy ? super.getVariableMapLink() : this.proxy.getVariableMapLink();
    }

    @Override
    public boolean hasAccess() {
        return !this.useProxy ? super.hasAccess() : this.proxy.hasAccess();
    }

    @Override
    public boolean hasNestedDatasets() {
        return this.useProxy ? this.proxy.hasNestedDatasets() : true;
    }

    @Override
    public boolean isHarvest() {
        return !this.useProxy ? super.isHarvest() : this.proxy.isHarvest();
    }

    private class Callback
    implements CatalogSetCallback {
        CatalogSetCallback caller;

        Callback(CatalogSetCallback caller) {
            this.caller = caller;
        }

        @Override
        public void setCatalog(InvCatalogImpl cat) {
            if (InvCatalogRef.this.debugAsynch) {
                System.out.println(" setCatalog was called");
            }
            InvCatalogRef.this.finishCatalog(cat);
            this.caller.setCatalog(cat);
        }

        @Override
        public void failed() {
            if (InvCatalogRef.this.debugAsynch) {
                System.out.println(" setCatalog failed");
            }
            this.caller.failed();
        }
    }
}

