/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.write.Nc4ChunkingStrategyImpl;

public class Nc4ChunkingStrategyFromAttribute
extends Nc4ChunkingStrategyImpl {
    public Nc4ChunkingStrategyFromAttribute(int deflateLevel, boolean shuffle) {
        super(deflateLevel, shuffle);
    }

    @Override
    public boolean isChunked(Variable v) {
        if (this.getChunkAttribute(v) != null) {
            return true;
        }
        return super.isChunked(v);
    }

    @Override
    public long[] computeChunking(Variable v) {
        Attribute att = v.findAttribute("_ChunkSizes");
        if (att != null && att.getDataType().isIntegral() && att.getLength() == v.getRank()) {
            long[] result = new long[v.getRank()];
            for (int i = 0; i < v.getRank(); ++i) {
                result[i] = att.getNumericValue(i).longValue();
            }
            return result;
        }
        return super.computeChunking(v);
    }
}

