/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import ucar.nc2.util.net.CustomX509TrustManager;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPSSLProvider;

public class CustomSSLProtocolSocketFactory
implements SchemeLayeredSocketFactory {
    private SSLContext sslcontext = null;

    private SSLContext createSSLContext(HttpParams params) throws IOException {
        if (this.sslcontext == null) {
            try {
                this.sslcontext = this.trustedauthentication(params);
                if (this.sslcontext == null) {
                    this.sslcontext = this.stdauthentication();
                }
            }
            catch (KeyManagementException e) {
                throw new HTTPException("Key Management exception: " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new HTTPException("Unsupported algorithm exception: " + e.getMessage());
            }
            catch (KeyStoreException e) {
                throw new HTTPException("Keystore exception: " + e.getMessage());
            }
            catch (GeneralSecurityException e) {
                throw new HTTPException("Key management exception: " + e.getMessage());
            }
            catch (IOException e) {
                throw new HTTPException("I/O error reading keystore/truststore file: " + e.getMessage());
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return this.sslcontext;
    }

    private SSLContext stdauthentication() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new CustomX509TrustManager(null)}, null);
        return context;
    }

    private SSLContext trustedauthentication(HttpParams params) throws Exception {
        KeyStore truststore;
        String keypath = null;
        String keypassword = null;
        String trustpath = null;
        String trustpassword = null;
        HTTPSSLProvider provider = null;
        if (params == null) {
            return null;
        }
        Object o = params.getParameter("HTTP.provider");
        if (o == null) {
            return null;
        }
        if (!(o instanceof HTTPSSLProvider)) {
            throw new HTTPException("CustomSSLProtocolSocketFactory: provide is not SSL provider");
        }
        provider = (HTTPSSLProvider)o;
        keypath = provider.getKeystore();
        keypassword = provider.getKeypassword();
        trustpath = provider.getTruststore();
        trustpassword = provider.getTrustpassword();
        TrustManager[] trustmanagers = null;
        KeyManager[] keymanagers = null;
        KeyStore keystore = CustomSSLProtocolSocketFactory.buildstore(keypath, keypassword, "key");
        if (keystore != null) {
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance("SunX509");
            kmfactory.init(keystore, keypassword.toCharArray());
            keymanagers = kmfactory.getKeyManagers();
        }
        if ((truststore = CustomSSLProtocolSocketFactory.buildstore(trustpath, trustpassword, "trust")) != null) {
            trustmanagers = new TrustManager[]{new CustomX509TrustManager(truststore)};
        }
        if (trustmanagers == null) {
            trustmanagers = new TrustManager[]{new CustomX509TrustManager(null)};
        }
        SSLContext sslcontext = SSLContext.getInstance("TSL");
        sslcontext.init(keymanagers, trustmanagers, null);
        return sslcontext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStore buildstore(String path, String password, String prefix) throws HTTPException {
        KeyStore store;
        block7: {
            store = null;
            try {
                if (path == null || password == null) break block7;
                File storefile = new File(path);
                if (!storefile.canRead()) {
                    throw new HTTPException("Cannot read specified " + prefix + "store:" + storefile.getAbsolutePath());
                }
                store = KeyStore.getInstance("JKS");
                FileInputStream is = null;
                try {
                    is = new FileInputStream(storefile);
                    store.load(is, password.toCharArray());
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Exception e) {
                throw new HTTPException(e);
            }
        }
        return store;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(CustomSSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return CustomSSLProtocolSocketFactory.class.hashCode();
    }

    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        return true;
    }

    public Socket createLayeredSocket(Socket socket, String s, int i, HttpParams httpParams) throws IOException {
        return this.createSSLContext(httpParams).getSocketFactory().createSocket();
    }

    public Socket createSocket(HttpParams httpParams) throws IOException {
        return this.createSSLContext(httpParams).getSocketFactory().createSocket();
    }

    public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException {
        int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
        SSLSocket sslsocket = (SSLSocket)(sock != null ? sock : this.createSocket(params));
        if (localAddress != null) {
            sslsocket.setReuseAddress(HttpConnectionParams.getSoReuseaddr((HttpParams)params));
            sslsocket.bind(localAddress);
        }
        try {
            sslsocket.setSoTimeout(soTimeout);
            sslsocket.connect(remoteAddress, connTimeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out");
        }
        return sslsocket;
    }
}

