/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.EscapeStrings;
import ucar.unidata.util.StringUtil2;

public class DiskCache2 {
    public static int CACHEPATH_POLICY_ONE_DIRECTORY = 0;
    public static int CACHEPATH_POLICY_NESTED_DIRECTORY = 1;
    public static int CACHEPATH_POLICY_NESTED_TRUNCATE = 2;
    private CachePathPolicy cachePathPolicy = CachePathPolicy.OneDirectory;
    private boolean alwaysUseCache = true;
    private boolean neverUseCache = false;
    private String cachePathPolicyParam = null;
    private String root;
    private int persistMinutes;
    private int scourEveryMinutes;
    private Timer timer;
    private Logger cacheLog = LoggerFactory.getLogger((String)"cacheLogger");
    private boolean fail = false;

    public DiskCache2() {
        String root = System.getProperty("nj22.cache");
        if (root == null) {
            String home = System.getProperty("user.home");
            if (home == null) {
                home = System.getProperty("user.dir");
            }
            if (home == null) {
                home = ".";
            }
            root = home + "/.unidata/cache/";
        }
        this.setRootDirectory(root);
        this.alwaysUseCache = false;
    }

    public DiskCache2(String root, boolean reletiveToHome, int persistMinutes, int scourEveryMinutes) {
        this.persistMinutes = persistMinutes;
        this.scourEveryMinutes = scourEveryMinutes;
        if (reletiveToHome) {
            String home = System.getProperty("nj22.cachePersistRoot");
            if (home == null) {
                home = System.getProperty("user.home");
            }
            if (home == null) {
                home = System.getProperty("user.dir");
            }
            if (home == null) {
                home = ".";
            }
            if (!home.endsWith("/")) {
                home = home + "/";
            }
            root = home + root;
        }
        this.setRootDirectory(root);
        if (!this.fail && scourEveryMinutes > 0) {
            this.timer = new Timer("DiskCache-" + root);
            Calendar c = Calendar.getInstance();
            c.add(12, scourEveryMinutes);
            this.timer.scheduleAtFixedRate((TimerTask)new CacheScourTask(), c.getTime(), 60000L * (long)scourEveryMinutes);
        }
    }

    public void exit() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void setLogger(Logger cacheLog) {
        this.cacheLog = cacheLog;
    }

    public void setRootDirectory(String cacheDir) {
        if (!cacheDir.endsWith("/")) {
            cacheDir = cacheDir + "/";
        }
        this.root = StringUtil2.replace(cacheDir, '\\', "/");
        File dir = new File(this.root);
        dir.mkdirs();
        if (!dir.exists()) {
            this.fail = true;
            this.cacheLog.error("DiskCache2 failed to create directory " + this.root);
        } else {
            this.cacheLog.debug("DiskCache2 create directory " + this.root);
        }
    }

    public String getRootDirectory() {
        return this.root;
    }

    public File getCacheFile(String fileLocation) {
        File f;
        if (!this.alwaysUseCache && DiskCache2.canWrite(f = new File(fileLocation))) {
            return f;
        }
        f = new File(this.makeCachePath(fileLocation));
        if (this.cachePathPolicy == CachePathPolicy.NestedDirectory) {
            File dir = f.getParentFile();
            dir.mkdirs();
        }
        return f;
    }

    public File getFile(String fileLocation) {
        File dir;
        File f;
        if (!this.alwaysUseCache) {
            f = new File(fileLocation);
            if (f.exists()) {
                return f;
            }
            if (DiskCache2.canWrite(f)) {
                return f;
            }
        }
        if (this.neverUseCache) {
            throw new IllegalStateException("neverUseCache=true, but directory is not writeable =" + fileLocation);
        }
        f = new File(this.makeCachePath(fileLocation));
        if (this.cachePathPolicy == CachePathPolicy.NestedDirectory && !(dir = f.getParentFile()).exists() && !dir.mkdirs()) {
            this.cacheLog.warn("Cant create directories for file " + dir.getPath());
        }
        return f;
    }

    private static boolean canWrite(File f) {
        try {
            if (f.createNewFile()) {
                f.delete();
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public synchronized File createUniqueFile(String prefix, String suffix) {
        if (suffix == null) {
            suffix = ".tmp";
        }
        Random random = new Random(System.currentTimeMillis());
        File result = new File(this.getRootDirectory(), prefix + Integer.toString(random.nextInt()) + suffix);
        while (result.exists()) {
            result = new File(this.getRootDirectory(), prefix + Integer.toString(random.nextInt()) + suffix);
        }
        return result;
    }

    public void setPolicy(CachePathPolicy cachePathPolicy) {
        this.cachePathPolicy = cachePathPolicy;
    }

    public void setCachePathPolicy(CachePathPolicy cachePathPolicy, String cachePathPolicyParam) {
        this.cachePathPolicy = cachePathPolicy;
        this.cachePathPolicyParam = cachePathPolicyParam;
    }

    public void setCachePathPolicy(int cachePathPolicy, String cachePathPolicyParam) {
        this.setPolicy(cachePathPolicy);
        this.cachePathPolicyParam = cachePathPolicyParam;
    }

    public void setPolicy(int cachePathPolicy) {
        switch (cachePathPolicy) {
            case 0: {
                this.setPolicy(CachePathPolicy.OneDirectory);
                break;
            }
            case 1: {
                this.setPolicy(CachePathPolicy.NestedDirectory);
                break;
            }
            case 2: {
                this.setPolicy(CachePathPolicy.NestedTruncate);
            }
        }
    }

    public void setPolicy(String policy) {
        if (policy == null) {
            return;
        }
        if (policy.equalsIgnoreCase("oneDirectory")) {
            this.setCachePathPolicy(CachePathPolicy.OneDirectory, null);
        } else if (policy.equalsIgnoreCase("nestedDirectory")) {
            this.setCachePathPolicy(CachePathPolicy.NestedDirectory, null);
        }
    }

    public void setAlwaysUseCache(boolean alwaysUseCache) {
        this.alwaysUseCache = alwaysUseCache;
    }

    public void setNeverUseCache(boolean neverUseCache) {
        this.neverUseCache = neverUseCache;
    }

    private String makeCachePath(String fileLocation) {
        File file;
        File parent;
        String cachePath = fileLocation;
        cachePath = StringUtil2.remove(cachePath, 63);
        cachePath = StringUtil2.remove(cachePath, 61);
        if ((cachePath = StringUtil2.replace(cachePath, '\\', "/")).startsWith("/")) {
            cachePath = cachePath.substring(1);
        }
        if (cachePath.endsWith("/")) {
            cachePath = cachePath.substring(0, cachePath.length() - 1);
        }
        cachePath = StringUtil2.remove(cachePath, 58);
        if (this.cachePathPolicy == CachePathPolicy.OneDirectory) {
            cachePath = StringUtil2.replace(cachePath, '/', "-");
        } else if (this.cachePathPolicy == CachePathPolicy.NestedTruncate) {
            int pos = cachePath.indexOf(this.cachePathPolicyParam);
            if (pos >= 0) {
                cachePath = cachePath.substring(pos + this.cachePathPolicyParam.length());
            }
            if (cachePath.startsWith("/")) {
                cachePath = cachePath.substring(1);
            }
        }
        if (this.cachePathPolicy != CachePathPolicy.OneDirectory && !(parent = (file = new File(this.root + cachePath)).getParentFile()).exists()) {
            parent.mkdirs();
        }
        return this.root + cachePath;
    }

    public void showCache(PrintStream pw) {
        File[] files;
        pw.println("Cache files");
        pw.println("Size   LastModified       Filename");
        File dir = new File(this.root);
        for (File file : files = dir.listFiles()) {
            String org = null;
            try {
                org = URLDecoder.decode(file.getName(), "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            pw.println(" " + file.length() + " " + new Date(file.lastModified()) + " " + org);
        }
    }

    public void cleanCache(File dir, StringBuilder sbuff, boolean isRoot) {
        long now = System.currentTimeMillis();
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalStateException("DiskCache2: not a directory or I/O error on dir=" + dir.getAbsolutePath());
        }
        if (!isRoot && files.length == 0) {
            long duration = now - dir.lastModified();
            if ((duration /= 60000L) > (long)this.persistMinutes) {
                dir.delete();
                if (sbuff != null) {
                    sbuff.append(" deleted ").append(dir.getPath()).append(" last= ").append(new Date(dir.lastModified())).append("\n");
                }
            }
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.cleanCache(file, sbuff, false);
                continue;
            }
            long duration = now - file.lastModified();
            if ((duration /= 60000L) <= (long)this.persistMinutes) continue;
            file.delete();
            if (sbuff == null) continue;
            sbuff.append(" deleted ").append(file.getPath()).append(" last= ").append(new Date(file.lastModified())).append("\n");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DiskCache2");
        sb.append("{cachePathPolicy=").append((Object)this.cachePathPolicy);
        sb.append(", alwaysUseCache=").append(this.alwaysUseCache);
        sb.append(", cachePathPolicyParam='").append(this.cachePathPolicyParam).append('\'');
        sb.append(", root='").append(this.root).append('\'');
        sb.append(", scourEveryMinutes=").append(this.scourEveryMinutes);
        sb.append(", persistMinutes=").append(this.persistMinutes);
        sb.append(", fail=").append(this.fail);
        sb.append('}');
        return sb.toString();
    }

    static void make(DiskCache2 dc, String filename) throws IOException {
        File want = dc.getCacheFile(filename);
        System.out.println("make=" + want.getPath() + "; exists = " + want.exists());
        if (!want.exists()) {
            want.createNewFile();
        }
        System.out.println(" canRead= " + want.canRead() + " canWrite = " + DiskCache2.canWrite(want) + " lastMod = " + new Date(want.lastModified()));
        System.out.println(" original=" + EscapeStrings.urlDecode(filename));
    }

    public static void main(String[] args) throws IOException {
        DiskCache2 dc = new DiskCache2("C:/TEMP/test/", false, 0, 0);
        dc.setRootDirectory("C:/temp/chill/");
        DiskCache2.make(dc, "C:/junk.txt");
        DiskCache2.make(dc, "C:/some/enchanted/evening/joots+3478.txt");
        DiskCache2.make(dc, "http://www.unidata.ucar.edu/some/enc hanted/eve'ning/nowrite.gibberish");
        dc.showCache(System.out);
        StringBuilder sbuff = new StringBuilder();
        dc.cleanCache(new File(dc.getRootDirectory()), sbuff, true);
        System.out.println(sbuff);
    }

    private class CacheScourTask
    extends TimerTask {
        CacheScourTask() {
        }

        @Override
        public void run() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("DiskCache2 scour on directory= ").append(DiskCache2.this.root).append("\n");
            DiskCache2.this.cleanCache(new File(DiskCache2.this.root), sbuff, true);
            sbuff.append("----------------------\n");
            if (DiskCache2.this.cacheLog != null) {
                DiskCache2.this.cacheLog.info(sbuff.toString());
            }
        }
    }

    public static enum CachePathPolicy {
        OneDirectory,
        NestedDirectory,
        NestedTruncate;

    }
}

