/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorEmpty;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.remote.QueryMaker;
import ucar.nc2.ft.point.remote.RemotePointFeatureIterator;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

class RemotePointCollection
extends PointCollectionImpl
implements QueryMaker {
    private String uri;
    private QueryMaker queryMaker;

    RemotePointCollection(String uri, QueryMaker queryMaker) {
        super(uri);
        this.uri = uri;
        this.queryMaker = queryMaker == null ? this : queryMaker;
    }

    @Override
    public String makeQuery() {
        return PointDatasetRemote.makeQuery(null, this.boundingBox, this.dateRange);
    }

    @Override
    public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
        InputStream in = null;
        String errMessage = null;
        try {
            in = CdmRemote.sendQuery(this.uri, this.queryMaker.makeQuery());
            PointStream.MessageType mtype = PointStream.readMagic(in);
            if (mtype == PointStream.MessageType.PointFeatureCollection) {
                int len = NcStream.readVInt(in);
                byte[] b = new byte[len];
                NcStream.readFully(in, b);
                PointStreamProto.PointFeatureCollection pfc = PointStreamProto.PointFeatureCollection.parseFrom(b);
                RemotePointFeatureIterator iter = new RemotePointFeatureIterator(in, new PointStream.ProtobufPointFeatureMaker(pfc));
                iter.setCalculateBounds(this);
                return iter;
            }
            if (mtype == PointStream.MessageType.End) {
                return new PointIteratorEmpty();
            }
            if (mtype == PointStream.MessageType.Error) {
                int len = NcStream.readVInt(in);
                byte[] b = new byte[len];
                NcStream.readFully(in, b);
                NcStreamProto.Error proto = NcStreamProto.Error.parseFrom(b);
                errMessage = NcStream.decodeErrorMessage(proto);
            } else {
                errMessage = "Illegal pointstream message type= " + (Object)((Object)mtype);
            }
        }
        catch (Throwable t) {
            if (in != null) {
                in.close();
            }
            throw new RuntimeException(t);
        }
        if (errMessage != null) {
            throw new IOException(errMessage);
        }
        return null;
    }

    @Override
    public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        return new PointFeatureCollectionSubset(this, boundingBox, dateRange);
    }

    private class PointFeatureCollectionSubset
    extends RemotePointCollection {
        PointCollectionImpl from;

        PointFeatureCollectionSubset(RemotePointCollection from, LatLonRect filter_bb, CalendarDateRange filter_date) throws IOException {
            super(from.uri, null);
            this.from = from;
            if (filter_bb == null) {
                this.boundingBox = from.getBoundingBox();
            } else {
                LatLonRect latLonRect = this.boundingBox = from.getBoundingBox() == null ? filter_bb : from.getBoundingBox().intersect(filter_bb);
            }
            this.dateRange = filter_date == null ? from.getCalendarDateRange() : (from.getDateRange() == null ? filter_date : from.getCalendarDateRange().intersect(filter_date));
        }
    }
}

