/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import thredds.inventory.StoreKeyValue;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.ListenerManager;
import ucar.unidata.util.StringUtil2;

public abstract class CollectionManagerAbstract
implements CollectionManager {
    private static Logger defaultLog = LoggerFactory.getLogger((String)"featureCollectionScan");
    protected String collectionName;
    protected final Logger logger;
    protected TimeDuration recheck;
    protected FeatureCollectionConfig.ProtoChoice protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
    protected Map<String, Object> auxInfo;
    private ListenerManager lm;
    private boolean isStatic;
    protected CollectionManager.ChangeChecker changeChecker = null;
    private static StoreKeyValue.Factory storeFactory;
    private StoreKeyValue store;

    public static String cleanName(String name) {
        if (name == null) {
            return null;
        }
        return StringUtil2.replace(name.trim(), ' ', "_");
    }

    protected CollectionManagerAbstract(String collectionName, Logger logger) {
        this.collectionName = CollectionManagerAbstract.cleanName(collectionName);
        this.logger = logger != null ? logger : defaultLog;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public TimeDuration getRecheck() {
        return this.recheck;
    }

    @Override
    public long getOlderThanFilterInMSecs() {
        return -1L;
    }

    @Override
    public void close() {
        if (this.store != null) {
            this.store.close();
        }
    }

    @Override
    public List<String> getFilenames() {
        ArrayList<String> result = new ArrayList<String>();
        for (MFile f : this.getFiles()) {
            result.add(f.getPath());
        }
        return result;
    }

    @Override
    public MFile getLatestFile() {
        MFile result = null;
        Iterator<MFile> i$ = this.getFiles().iterator();
        while (i$.hasNext()) {
            MFile f;
            result = f = i$.next();
        }
        return result;
    }

    @Override
    public void setChangeChecker(CollectionManager.ChangeChecker strat) {
        this.changeChecker = strat;
    }

    @Override
    public Object getAuxInfo(String key) {
        return this.auxInfo == null ? null : this.auxInfo.get(key);
    }

    @Override
    public void putAuxInfo(String key, Object value) {
        if (this.auxInfo == null) {
            this.auxInfo = new HashMap<String, Object>();
        }
        this.auxInfo.put(key, value);
    }

    @Override
    public int getProtoIndex(int n) {
        if (n < 2) {
            return 0;
        }
        int protoIdx = 0;
        switch (this.protoChoice) {
            case First: {
                protoIdx = 0;
                break;
            }
            case Random: {
                Random r = new Random(System.currentTimeMillis());
                protoIdx = r.nextInt(n - 1);
                break;
            }
            case Run: 
            case Penultimate: {
                protoIdx = Math.max(n - 2, 0);
                break;
            }
            case Latest: {
                protoIdx = Math.max(n - 1, 0);
            }
        }
        return protoIdx;
    }

    public static void setMetadataStore(StoreKeyValue.Factory _storeFactory) {
        storeFactory = _storeFactory;
    }

    private void initMM() {
        if (this.getCollectionName() == null) {
            return;
        }
        try {
            if (storeFactory != null) {
                this.store = storeFactory.open(this.getCollectionName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void putMetadata(MFile file, String key, byte[] value) {
        if (this.store == null) {
            this.initMM();
        }
        if (this.store != null) {
            this.store.put(file.getPath() + "#" + key, value);
        }
    }

    public byte[] getMetadata(MFile file, String key) {
        if (this.store == null) {
            this.initMM();
        }
        return this.store == null ? null : this.store.getBytes(file.getPath() + "#" + key);
    }

    @Override
    public void updateNocheck() throws IOException {
        this.sendEvent(new CollectionManager.TriggerEvent(this, CollectionManager.TriggerType.updateNocheck));
    }

    @Override
    public void resetProto() {
        this.sendEvent(new CollectionManager.TriggerEvent(this, CollectionManager.TriggerType.proto));
    }

    void sendEvent(CollectionManager.TriggerEvent event) {
        if (this.lm != null) {
            this.lm.sendEvent(event);
        }
    }

    @Override
    public void addEventListener(CollectionManager.TriggerListener l) {
        if (this.lm == null) {
            this.createListenerManager();
        }
        this.lm.addListener(l);
    }

    @Override
    public void removeEventListener(CollectionManager.TriggerListener l) {
        if (this.lm != null) {
            this.lm.removeListener(l);
        }
    }

    protected void createListenerManager() {
        this.lm = new ListenerManager("thredds.inventory.CollectionManager$TriggerListener", "thredds.inventory.CollectionManager$TriggerEvent", "handleCollectionEvent");
    }
}

