/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.fmrc;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ucar.nc2.dt.fmrc.FmrcDefinition;
import ucar.nc2.dt.fmrc.FmrcInventory;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.Misc;

public class FmrcReport {
    private boolean debug = false;

    public void report(FmrcInventory fmrc, PrintStream out, boolean showMissing) {
        out.println("ForecastModelRunCollection " + fmrc.getDefinitionPath());
        FmrcDefinition def = fmrc.getDefinition();
        if (null == def) {
            out.println(" No Definition");
            return;
        }
        StringBuilder sbuff = new StringBuilder();
        ArrayList<ErrMessage> errs = new ArrayList<ErrMessage>();
        for (FmrcInventory.RunSeq haveSeq : fmrc.getRunSequences()) {
            List<FmrcInventory.UberGrid> vars = haveSeq.getVariables();
            for (FmrcInventory.UberGrid uv : vars) {
                String sname = uv.getName();
                FmrcDefinition.Grid g = def.findGridByName(sname);
                if (g == null) {
                    errs.add(new ErrMessage(new Date(0L), uv.name, "Extra Variable (not in definition)", ""));
                    continue;
                }
                if (this.debug) {
                    System.out.println(uv.name);
                }
                for (FmrcInventory.RunExpected rune : uv.runs) {
                    double[] haveVc;
                    double[] wantVc;
                    boolean haveErrs;
                    ForecastModelRunInventory.TimeCoord haveTc = rune.run.tc;
                    ForecastModelRunInventory.TimeCoord wantTc = rune.expected;
                    if (this.debug) {
                        System.out.println(" " + rune.run.runTime);
                    }
                    if (rune.expected == null) {
                        errs.add(new ErrMessage(rune.run.runTime, uv.name, "Extra Variable (not in definition)", ""));
                        continue;
                    }
                    sbuff.setLength(0);
                    if (showMissing && this.findMissing(haveTc.getOffsetHours(), wantTc.getOffsetHours(), sbuff)) {
                        errs.add(new ErrMessage(rune.run.runTime, uv.name, "Missing All Grids at Offset hour:", sbuff.toString()));
                    }
                    sbuff.setLength(0);
                    if (this.findMissing(wantTc.getOffsetHours(), haveTc.getOffsetHours(), sbuff)) {
                        errs.add(new ErrMessage(rune.run.runTime, uv.name, "Extra Grid at Offset hour:", sbuff.toString()));
                    }
                    if (showMissing) {
                        sbuff.setLength(0);
                        haveErrs = false;
                        for (double offset : haveTc.getOffsetHours()) {
                            wantVc = this.normalize(rune.expectedGrid.getVertCoords(offset));
                            haveVc = this.normalize(rune.grid.getVertCoords(offset));
                            if (!this.findMissing(haveVc, wantVc, sbuff)) continue;
                            haveErrs = true;
                            sbuff.append("(").append(offset).append(") ");
                        }
                        if (haveErrs) {
                            errs.add(new ErrMessage(rune.run.runTime, uv.name, "Missing Some Grids:", sbuff.toString()));
                        }
                    }
                    sbuff.setLength(0);
                    haveErrs = false;
                    for (double offset : haveTc.getOffsetHours()) {
                        if (this.debug) {
                            System.out.println("  " + offset);
                        }
                        if (!this.findMissing(wantVc = this.normalize(rune.expectedGrid.getVertCoords(offset)), haveVc = this.normalize(rune.grid.getVertCoords(offset)), sbuff)) continue;
                        haveErrs = true;
                        sbuff.append("(").append(offset).append(") ");
                    }
                    if (!haveErrs) continue;
                    errs.add(new ErrMessage(rune.run.runTime, uv.name, "Extra Grids:", sbuff.toString()));
                }
            }
        }
        Collections.sort(errs);
        Date currentDate = null;
        String currentType = null;
        DateFormatter formatter = new DateFormatter();
        for (ErrMessage err : errs) {
            if (err.runDate != currentDate) {
                if (currentDate != null) {
                    out.println();
                }
                out.println(" Run " + formatter.toDateTimeString(err.runDate));
                currentDate = err.runDate;
                currentType = null;
            }
            if (!err.type.equals(currentType)) {
                out.println("  " + err.type);
                currentType = err.type;
            }
            out.println("   " + err.varName + ": " + err.message);
        }
        out.println();
    }

    double[] normalize(double[] v) {
        int countNans = 0;
        for (int i = 0; i < v.length; ++i) {
            if (!Double.isNaN(v[i])) continue;
            ++countNans;
        }
        if (countNans > 0) {
            double[] vnew = new double[v.length - countNans];
            int count = 0;
            for (int i = 0; i < v.length; ++i) {
                if (Double.isNaN(v[i])) continue;
                vnew[count++] = v[i];
            }
            v = vnew;
        }
        if (v.length < 2) {
            return v;
        }
        if (v[0] < v[1]) {
            return v;
        }
        double[] v2 = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            v2[v.length - i - 1] = v[i];
        }
        return v2;
    }

    boolean findMissing(double[] test, double[] standard, StringBuilder sbuff) {
        int countTest = 0;
        int countStandard = 0;
        boolean errs = false;
        while (countTest < test.length && countStandard < standard.length) {
            if (Double.isNaN(standard[countStandard])) {
                ++countStandard;
                continue;
            }
            if (Double.isNaN(test[countTest])) {
                ++countTest;
                continue;
            }
            if (Misc.closeEnough(standard[countStandard], test[countTest])) {
                ++countTest;
                ++countStandard;
                continue;
            }
            if (standard[countStandard] < test[countTest]) {
                sbuff.append(" ").append(standard[countStandard]);
                errs = true;
                ++countStandard;
                continue;
            }
            if (!(standard[countStandard] > test[countTest])) continue;
            ++countTest;
        }
        while (countStandard < standard.length) {
            sbuff.append(" ").append(standard[countStandard]);
            errs = true;
            ++countStandard;
        }
        return errs;
    }

    private class ErrMessage
    implements Comparable {
        Date runDate;
        String varName;
        String type;
        String message;

        ErrMessage(Date runDate, String varName, String type, String message) {
            this.runDate = runDate;
            this.varName = varName;
            this.type = type;
            this.message = message;
        }

        public int compareTo(Object o) {
            ErrMessage om = (ErrMessage)o;
            int result = this.runDate.compareTo(om.runDate);
            if (result != 0) {
                return result;
            }
            result = this.type.compareTo(om.type);
            if (result != 0) {
                return result;
            }
            result = this.varName.compareTo(om.varName);
            return result;
        }
    }
}

