/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.ncml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.internal.ncml.AggDataset;
import ucar.nc2.internal.ncml.AggProxyReader;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.cache.FileFactory;

public abstract class Aggregation
implements AggregationIF {
    protected static TypicalDataset typicalDatasetMode = TypicalDataset.FIRST;
    protected static Logger logger = LoggerFactory.getLogger(Aggregation.class);
    protected static DiskCache2 diskCache2;
    protected static Executor executor;
    protected static boolean debug;
    protected static boolean debugOpenFile;
    protected static boolean debugSyncDetail;
    protected static boolean debugProxy;
    protected static boolean debugRead;
    protected static boolean debugDateParse;
    protected static boolean debugConvert;
    protected NetcdfDataset.Builder ncDataset;
    protected Type type;
    protected Object spiObject = null;
    protected List<AggDataset> explicitDatasets = new ArrayList<AggDataset>();
    protected List<AggDataset> datasets = new ArrayList<AggDataset>();
    protected MFileCollectionManager datasetManager;
    protected boolean cacheDirty = true;
    protected String dimName;
    Element ncmlElem;
    protected String dateFormatMark;
    protected String numericTimeSettings;
    protected boolean isDate;
    protected DateFormatter dateFormatter = new DateFormatter();
    private Random r;

    public static void setPersistenceCache(DiskCache2 dc) {
        diskCache2 = dc;
        if (diskCache2 != null) {
            diskCache2.setAlwaysUseCache(true);
        }
    }

    public static void setExecutor(Executor exec) {
        executor = exec;
    }

    public static void setTypicalDatasetMode(String mode) {
        if (mode.equalsIgnoreCase("random")) {
            typicalDatasetMode = TypicalDataset.RANDOM;
        } else if (mode.equalsIgnoreCase("latest")) {
            typicalDatasetMode = TypicalDataset.LATEST;
        } else if (mode.equalsIgnoreCase("penultimate")) {
            typicalDatasetMode = TypicalDataset.PENULTIMATE;
        } else if (mode.equalsIgnoreCase("first")) {
            typicalDatasetMode = TypicalDataset.FIRST;
        } else {
            logger.error("Unknown setTypicalDatasetMode= " + mode);
        }
    }

    protected Aggregation(NetcdfDataset.Builder ncd, String dimName, Type type, String recheckS) {
        this.ncDataset = ncd;
        this.dimName = dimName;
        this.type = type;
        String name = ncd.location;
        if (name == null) {
            name = "Agg-" + ncd.hashCode();
        }
        this.datasetManager = MFileCollectionManager.openWithRecheck(name, recheckS);
    }

    public void addExplicitDataset(String cacheName, String location, String id, String ncoordS, String coordValueS, String sectionSpec, FileFactory reader) {
        AggDataset nested = this.makeDataset(cacheName, location, id, ncoordS, coordValueS, sectionSpec, null, reader);
        this.explicitDatasets.add(nested);
    }

    public void addDataset(AggDataset nested) {
        this.explicitDatasets.add(nested);
    }

    public void addDatasetScan(Element crawlableDatasetElement, String dirName, String suffix, String regexpPatternString, String dateFormatMark, Set<NetcdfDataset.Enhance> enhanceMode, String subdirs, String olderThan, String numericTimeSettings) {
        this.datasetManager.addDirectoryScan(dirName, suffix, regexpPatternString, subdirs, olderThan, enhanceMode);
        this.dateFormatMark = dateFormatMark;
        this.numericTimeSettings = numericTimeSettings;
        if (dateFormatMark != null) {
            this.isDate = true;
            if (this.type == Type.joinExisting) {
                this.type = Type.joinExistingOne;
            }
            DateExtractorFromName dateExtractor = new DateExtractorFromName(dateFormatMark, true);
            this.datasetManager.setDateExtractor(dateExtractor);
        }
    }

    public void addCollection(String spec, String olderThan) {
        this.datasetManager = MFileCollectionManager.open(spec, spec, olderThan, new Formatter());
    }

    public void setModifications(Element ncmlMods) {
        this.ncmlElem = ncmlMods;
    }

    public Type getType() {
        return this.type;
    }

    public String getDimensionName() {
        return this.dimName;
    }

    protected String getLocation() {
        return this.ncDataset.location;
    }

    @Override
    public void close() throws IOException {
        this.persistWrite();
    }

    @Override
    public synchronized boolean syncExtend() throws IOException {
        return false;
    }

    @Override
    public long getLastModified() {
        try {
            this.datasetManager.scanIfNeeded();
        }
        catch (IOException e) {
            logger.error("Aggregation scan failed, e");
        }
        return this.datasetManager.getLastChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFileTypeId() {
        AggDataset ds = null;
        NetcdfFile ncfile = null;
        try {
            ds = this.getTypicalDataset();
            ncfile = ds.acquireFile(null);
            String string = ncfile.getFileTypeId();
            return string;
        }
        catch (Exception e) {
            logger.error("failed to open " + ds);
        }
        finally {
            if (ds != null) {
                try {
                    ds.close(ncfile);
                }
                catch (IOException e) {
                    logger.error("failed to close " + ds);
                }
            }
        }
        return "N/A";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFileTypeDescription() {
        AggDataset ds = null;
        NetcdfFile ncfile = null;
        try {
            ds = this.getTypicalDataset();
            ncfile = ds.acquireFile(null);
            String string = ncfile.getFileTypeDescription();
            return string;
        }
        catch (Exception e) {
            logger.error("failed to open " + ds);
        }
        finally {
            if (ds != null) {
                try {
                    ds.close(ncfile);
                }
                catch (IOException e) {
                    logger.error("failed to close " + ds);
                }
            }
        }
        return "N/A";
    }

    protected abstract void buildNetcdfDataset(CancelTask var1) throws IOException;

    @Override
    public void persistWrite() throws IOException {
    }

    protected void persistRead() {
    }

    @Override
    public void getDetailInfo(Formatter f) {
        f.format("  Type=%s%n", new Object[]{this.type});
        f.format("  dimName=%s%n", this.dimName);
        f.format("  Datasets (%d) %n", this.datasets.size());
        for (AggDataset ds : this.datasets) {
            ds.show(f);
        }
    }

    public void build(CancelTask cancelTask) throws IOException {
        this.datasetManager.scan(true);
        this.cacheDirty = true;
        this.makeDatasets(cancelTask);
        this.buildNetcdfDataset(cancelTask);
    }

    public List<AggDataset> getDatasets() {
        return this.datasets;
    }

    protected void makeDatasets(CancelTask cancelTask) throws IOException {
        this.datasets = new ArrayList<AggDataset>();
        for (MFile cd : this.datasetManager.getFilesSorted()) {
            this.datasets.add(this.makeDataset(cd));
        }
        Collections.sort(this.datasets);
        this.datasets.addAll(this.explicitDatasets);
        Iterator<AggDataset> datasetsIter = this.datasets.iterator();
        while (datasetsIter.hasNext()) {
            AggDataset dataset = datasetsIter.next();
            MFile mFile = dataset.getMFile();
            if (mFile == null || mFile.isReadable()) continue;
            logger.warn("Aggregation member isn't readable (permissions issue?). Skipping: " + mFile.getPath());
            datasetsIter.remove();
        }
        HashSet<String> dset = new HashSet<String>(2 * this.datasets.size());
        for (AggDataset dataset : this.datasets) {
            if (dset.contains(dataset.cacheLocation)) {
                logger.warn("Duplicate dataset in aggregation = " + dataset.cacheLocation);
            }
            dset.add(dataset.cacheLocation);
        }
        if (this.datasets.isEmpty()) {
            throw new IllegalStateException("There are no datasets in the aggregation " + this.datasetManager);
        }
    }

    protected AggDataset getTypicalDataset() throws IOException {
        int select;
        List<AggDataset> nestedDatasets = this.getDatasets();
        int n = nestedDatasets.size();
        if (n == 0) {
            throw new FileNotFoundException("No datasets in this aggregation");
        }
        if (typicalDatasetMode == TypicalDataset.LATEST) {
            select = n - 1;
        } else if (typicalDatasetMode == TypicalDataset.PENULTIMATE) {
            select = n < 2 ? 0 : n - 2;
        } else if (typicalDatasetMode == TypicalDataset.FIRST) {
            select = 0;
        } else {
            if (this.r == null) {
                this.r = new Random();
            }
            select = n < 2 ? 0 : this.r.nextInt(n);
        }
        return nestedDatasets.get(select);
    }

    protected AggDataset makeDataset(String cacheName, String location, String id, String ncoordS, String coordValueS, String sectionSpec, EnumSet<NetcdfDataset.Enhance> enhance, FileFactory reader) {
        return new AggDataset(cacheName, location, id, enhance, reader, this.spiObject, this.ncmlElem);
    }

    protected AggDataset makeDataset(MFile dset) {
        return new AggDataset(dset, this.spiObject, this.ncmlElem);
    }

    void setDatasetAcquireProxy(AggDataset typicalDataset, NetcdfDataset.Builder newds) throws IOException {
        AggProxyReader proxy = new AggProxyReader(typicalDataset);
        this.setDatasetAcquireProxy(proxy, newds.rootGroup);
    }

    private void setDatasetAcquireProxy(AggProxyReader proxy, Group.Builder g) throws IOException {
        for (Variable.Builder<?> v : g.vbuilders) {
            if (v.proxyReader != v && v.proxyReader != null) {
                if (!debugProxy) continue;
                System.out.println(" debugProxy: hasProxyReader " + v.shortName);
                continue;
            }
            v.setProxyReader(proxy);
            if (!debugProxy) continue;
            System.out.println(" debugProxy: set proxy on " + v.shortName);
        }
        for (Group.Builder nested : g.gbuilders) {
            this.setDatasetAcquireProxy(proxy, nested);
        }
    }

    protected static enum TypicalDataset {
        FIRST,
        RANDOM,
        LATEST,
        PENULTIMATE;

    }

    protected static enum Type {
        forecastModelRunCollection,
        forecastModelRunSingleCollection,
        joinExisting,
        joinExistingOne,
        joinNew,
        tiled,
        union;

    }
}

