/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.util.Indent;

public final class StructureMembers {
    private String name;
    private List<Member> members;
    private int structureSize = -1;

    @Deprecated
    public StructureMembers(String name) {
        this.name = name;
        this.members = new ArrayList<Member>();
    }

    @Deprecated
    public StructureMembers(StructureMembers from) {
        this.name = from.name;
        this.members = new ArrayList<Member>(from.getMembers().size());
        for (Member m : from.members) {
            Member nm = new Member(m);
            this.addMember(nm);
            if (m.members == null) continue;
            nm.members = m.members.toBuilder(false).build();
        }
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public void addMember(Member m) {
        this.members.add(m);
    }

    @Deprecated
    public void addMember(int pos, Member m) {
        this.members.add(pos, m);
    }

    @Deprecated
    public Member addMember(String name, String desc, String units, DataType dtype, int[] shape) {
        Member m = new Member(name, desc, units, dtype, shape);
        this.addMember(m);
        return m;
    }

    @Deprecated
    public int hideMember(Member m) {
        if (m == null) {
            return -1;
        }
        int index = this.members.indexOf(m);
        this.members.remove(m);
        return index;
    }

    public int getStructureSize() {
        if (this.structureSize < 0) {
            this.structureSize = this.calcStructureSize();
        }
        return this.structureSize;
    }

    private int calcStructureSize() {
        int sum = 0;
        for (Member member : this.members) {
            sum += member.getSizeBytes();
        }
        return sum;
    }

    @Deprecated
    public void setStructureSize(int structureSize) {
        this.structureSize = structureSize;
    }

    public ImmutableList<Member> getMembers() {
        return ImmutableList.copyOf(this.members);
    }

    public ImmutableList<String> getMemberNames() {
        return (ImmutableList)this.members.stream().map(m -> m.getName()).collect(ImmutableList.toImmutableList());
    }

    public Member getMember(int index) {
        return this.members.get(index);
    }

    @Nullable
    public Member findMember(String memberName) {
        if (memberName == null) {
            return null;
        }
        return this.members.stream().filter(m -> ((Member)m).name.equals(memberName)).findFirst().orElse(null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("members", this.members).add("structureSize", this.structureSize).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructureMembers)) {
            return false;
        }
        StructureMembers other = (StructureMembers)o;
        return this.getName().equals(other.getName()) && this.getStructureSize() == other.getStructureSize() && this.getMembers().size() == other.getMembers().size() && this.getMembers().stream().allMatch(m -> m.equals(other.findMember(m.getName())));
    }

    public static MemberBuilder memberBuilder() {
        return new MemberBuilder();
    }

    private StructureMembers(Builder builder) {
        this.name = builder.name == null ? "" : builder.name;
        this.members = builder.members.stream().map(mb -> mb.build()).collect(Collectors.toList());
        this.structureSize = builder.structureSize < 0 ? this.calcStructureSize() : builder.structureSize;
    }

    public Builder toBuilder(boolean wantsData) {
        Builder b = StructureMembers.builder().setName(this.name).setStructureSize(this.structureSize);
        this.members.forEach(m -> b.addMember(m.toBuilder(wantsData)));
        return b;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private ArrayList<MemberBuilder> members = new ArrayList();
        private int structureSize = -1;
        private boolean built;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addMember(MemberBuilder m) {
            this.members.add(m);
            return this;
        }

        public Builder addMember(int pos, MemberBuilder m) {
            this.members.add(pos, m);
            return this;
        }

        public MemberBuilder addMember(String name, String desc, String units, DataType dtype, int[] shape) {
            MemberBuilder m = new MemberBuilder().setName(name).setDesc(desc).setUnits(units).setDataType(dtype).setShape(shape);
            this.addMember(m);
            return m;
        }

        public MemberBuilder addMemberScalar(String name, String desc, String units, DataType dtype, Number val) {
            MemberBuilder mb = this.addMember(name, desc, units, dtype, new int[0]);
            Array data = null;
            switch (dtype) {
                case UBYTE: 
                case BYTE: 
                case ENUM1: {
                    data = new ArrayByte.D0(dtype.isUnsigned());
                    data.setByte(0, val.byteValue());
                    break;
                }
                case SHORT: 
                case USHORT: 
                case ENUM2: {
                    data = new ArrayShort.D0(dtype.isUnsigned());
                    data.setShort(0, val.shortValue());
                    break;
                }
                case INT: 
                case UINT: 
                case ENUM4: {
                    data = new ArrayInt.D0(dtype.isUnsigned());
                    data.setInt(0, val.intValue());
                    break;
                }
                case LONG: 
                case ULONG: {
                    data = new ArrayLong.D0(dtype.isUnsigned());
                    data.setDouble(0, (double)val.longValue());
                    break;
                }
                case FLOAT: {
                    data = new ArrayFloat.D0();
                    data.setFloat(0, val.floatValue());
                    break;
                }
                case DOUBLE: {
                    data = new ArrayDouble.D0();
                    data.setDouble(0, val.doubleValue());
                }
            }
            mb.setDataArray(data);
            return mb;
        }

        public MemberBuilder addMemberString(String name, String desc, String units, String val, int max_len) {
            MemberBuilder mb = this.addMember(name, desc, units, DataType.CHAR, new int[]{max_len});
            ArrayChar data = ArrayChar.makeFromString(val, max_len);
            mb.setDataArray(data);
            return mb;
        }

        public boolean hasMember(String memberName) {
            return this.members.stream().anyMatch(m -> ((MemberBuilder)m).name.equals(memberName));
        }

        public Builder setStructureSize(int structureSize) {
            this.structureSize = structureSize;
            return this;
        }

        public StructureMembers build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new StructureMembers(this);
        }
    }

    public static class MemberBuilder {
        private String name;
        private String desc;
        private String units;
        private DataType dtype;
        private int[] shape;
        private StructureMembers members;
        private Array dataArray;
        private Object dataObject;
        private int dataParam;
        private boolean built;

        private MemberBuilder() {
        }

        public MemberBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public MemberBuilder setDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public MemberBuilder setUnits(String units) {
            this.units = units;
            return this;
        }

        public MemberBuilder setDataType(DataType dtype) {
            this.dtype = dtype;
            return this;
        }

        public MemberBuilder setDataArray(Array data) {
            this.dataArray = data;
            return this;
        }

        public MemberBuilder setDataObject(Object o) {
            this.dataObject = o;
            return this;
        }

        public MemberBuilder setDataParam(int dataParam) {
            this.dataParam = dataParam;
            return this;
        }

        public MemberBuilder setStructureMembers(StructureMembers members) {
            this.members = members;
            return this;
        }

        public MemberBuilder setShape(int[] shape) {
            this.shape = (int[])Preconditions.checkNotNull((Object)shape);
            return this;
        }

        public Member build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new Member(this);
        }
    }

    public static final class Member {
        private String name;
        private String desc;
        private String units;
        private DataType dtype;
        private int size = 1;
        private int[] shape;
        private StructureMembers members;
        private boolean isVariableLength;
        private Array dataArray;
        private Object dataObject;
        private int dataParam;

        private Member(MemberBuilder builder) {
            this.name = (String)Preconditions.checkNotNull((Object)builder.name);
            this.desc = builder.desc;
            this.units = builder.units;
            this.dtype = (DataType)((Object)Preconditions.checkNotNull((Object)((Object)builder.dtype)));
            this.shape = builder.shape;
            this.members = builder.members;
            this.dataArray = builder.dataArray;
            this.dataObject = builder.dataObject;
            this.dataParam = builder.dataParam;
            this.size = (int)Index.computeSize(this.shape);
            this.isVariableLength = this.shape.length > 0 && this.shape[this.shape.length - 1] < 0;
        }

        public MemberBuilder toBuilder(boolean wantsData) {
            MemberBuilder b = new MemberBuilder().setName(this.name).setDesc(this.desc).setUnits(this.units).setDataType(this.dtype).setShape(this.shape);
            if (wantsData) {
                b.setDataArray(this.dataArray).setDataObject(this.dataObject).setDataParam(this.dataParam).setStructureMembers(this.members);
            } else if (this.members != null) {
                b.setStructureMembers(this.members.toBuilder(wantsData).build());
            }
            return b;
        }

        @Deprecated
        public Member(String name, String desc, String units, DataType dtype, int[] shape) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.desc = desc;
            this.units = units;
            this.dtype = (DataType)((Object)Preconditions.checkNotNull((Object)((Object)dtype)));
            this.setShape(shape);
        }

        @Deprecated
        public Member(Member from) {
            this.name = from.name;
            this.desc = from.desc;
            this.units = from.units;
            this.dtype = from.dtype;
            this.setStructureMembers(from.members);
            this.setShape(from.shape);
        }

        @Deprecated
        public void setStructureMembers(StructureMembers members) {
            this.members = members;
        }

        public StructureMembers getStructureMembers() {
            return this.members;
        }

        @Deprecated
        public void setShape(int[] shape) {
            this.shape = (int[])Preconditions.checkNotNull((Object)shape);
            this.size = (int)Index.computeSize(shape);
            this.isVariableLength = shape.length > 0 && shape[shape.length - 1] < 0;
        }

        public String getName() {
            return this.name;
        }

        public String getFullNameEscaped() {
            return this.name;
        }

        public String getFullName() {
            return this.name;
        }

        public String getUnitsString() {
            return this.units;
        }

        public String getDescription() {
            return this.desc;
        }

        public DataType getDataType() {
            return this.dtype;
        }

        public int[] getShape() {
            return this.shape;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isVariableLength() {
            return this.isVariableLength;
        }

        public int getSizeBytes() {
            if (this.getDataType() == DataType.SEQUENCE) {
                return this.getDataType().getSize();
            }
            if (this.getDataType() == DataType.STRING) {
                return this.getDataType().getSize();
            }
            if (this.getDataType() == DataType.STRUCTURE) {
                return this.size * this.members.getStructureSize();
            }
            return this.size * this.getDataType().getSize();
        }

        public boolean isScalar() {
            return this.size == 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Member)) {
                return false;
            }
            Member other = (Member)o;
            return this.getFullName().equals(other.getName()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getUnitsString(), other.getUnitsString()) && this.getDataType() == other.getDataType() && this.getSize() == other.getSize() && Arrays.equals(this.getShape(), other.getShape()) && Objects.equals(this.getStructureMembers(), other.getStructureMembers());
        }

        public int getDataParam() {
            return this.dataParam;
        }

        @Deprecated
        public void setDataParam(int dataParam) {
            this.dataParam = dataParam;
        }

        public Array getDataArray() {
            return this.dataArray;
        }

        @Deprecated
        public void setDataArray(Array data) {
            this.dataArray = data;
        }

        public Object getDataObject() {
            return this.dataObject;
        }

        @Deprecated
        public void setDataObject(Object o) {
            this.dataObject = o;
        }

        @Deprecated
        public void setVariableInfo(String vname, String desc, String unitString, DataType dtype) {
            this.name = vname;
            if (dtype != null) {
                this.dtype = dtype;
            }
            if (unitString != null) {
                this.units = unitString;
            }
            if (desc != null) {
                this.desc = desc;
            }
        }

        void showInternal(Formatter f, Indent indent) {
            f.format("%sname='%s' desc='%s' units='%s' dtype=%s size=%d dataObject=%s dataParam=%d", new Object[]{indent, this.name, this.desc, this.units, this.dtype, this.size, this.dataObject, this.dataParam});
            if (this.members != null) {
                indent.incr();
                f.format("%n%sNested members %s%n", indent, this.members.getName());
                for (Member m : this.members.getMembers()) {
                    m.showInternal(f, indent);
                }
                indent.decr();
            }
            f.format("%n", new Object[0]);
        }

        public String toString() {
            return this.name;
        }
    }
}

