/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.ft.TrajectoryProfileFeature;
import ucar.nc2.ft.TrajectoryProfileFeatureCollection;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.ft.point.writer2.WriterCFPointCollection;
import ucar.nc2.ft.point.writer2.WriterCFProfileCollection;
import ucar.nc2.ft.point.writer2.WriterCFStationCollection;
import ucar.nc2.ft.point.writer2.WriterCFStationProfileCollection;
import ucar.nc2.ft.point.writer2.WriterCFTrajectoryCollection;
import ucar.nc2.ft.point.writer2.WriterCFTrajectoryProfileCollection;
import ucar.nc2.util.CancelTask;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.nc2.write.NetcdfFileFormat;
import ucar.nc2.write.NetcdfFormatWriter;

public class CFPointWriter {
    private static boolean debug = true;

    public static int writeFeatureCollection(FeatureDatasetPoint fdpoint, String fileOut, NetcdfFileFormat format) throws IOException {
        return CFPointWriter.writeFeatureCollection(fdpoint, fileOut, CFPointWriterConfig.builder().setFormat(format).build());
    }

    public static int writeFeatureCollection(FeatureDatasetPoint fdpoint, String fileOut, CFPointWriterConfig config) throws IOException {
        for (DsgFeatureCollection fc : fdpoint.getPointFeatureCollectionList()) {
            if (fc instanceof PointFeatureCollection) {
                return CFPointWriter.writePointFeatureCollection(fdpoint, (PointFeatureCollection)fc, fileOut, config);
            }
            if (fc instanceof StationTimeSeriesFeatureCollection) {
                return CFPointWriter.writeStationFeatureCollection(fdpoint, (StationTimeSeriesFeatureCollection)fc, fileOut, config);
            }
            if (fc instanceof ProfileFeatureCollection) {
                return CFPointWriter.writeProfileFeatureCollection(fdpoint, (ProfileFeatureCollection)fc, fileOut, config);
            }
            if (fc instanceof TrajectoryFeatureCollection) {
                return CFPointWriter.writeTrajectoryFeatureCollection(fdpoint, (TrajectoryFeatureCollection)fc, fileOut, config);
            }
            if (fc instanceof StationProfileFeatureCollection) {
                return CFPointWriter.writeStationProfileFeatureCollection(fdpoint, (StationProfileFeatureCollection)fc, fileOut, config);
            }
            if (!(fc instanceof TrajectoryProfileFeatureCollection)) continue;
            return CFPointWriter.writeTrajectoryProfileFeatureCollection(fdpoint, (TrajectoryProfileFeatureCollection)fc, fileOut, config);
        }
        return 0;
    }

    private static int writePointFeatureCollection(FeatureDatasetPoint fdpoint, PointFeatureCollection pfc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFPointCollection pointWriter = new WriterCFPointCollection(fileOut, fdpoint.attributes(), fdpoint.getDataVariables(), pfc.getTimeUnit(), pfc.getAltUnits(), config);){
            pointWriter.setExtraVariables(pfc.getExtraVariables());
            int count = 0;
            for (PointFeature pf : pfc) {
                if (count == 0) {
                    pointWriter.writeHeader(pf);
                }
                pointWriter.writeRecord(pf, pf.getFeatureData());
                if (debug && ++count % 100 == 0) {
                    System.out.printf("%d ", count);
                }
                if (!debug || count % 1000 != 0) continue;
                System.out.printf("%n ", new Object[0]);
            }
            pointWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeStationFeatureCollection(FeatureDatasetPoint dataset, StationTimeSeriesFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFStationCollection cfWriter = new WriterCFStationCollection(fileOut, dataset.attributes(), dataset.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            cfWriter.setExtraVariables(fc.getExtraVariables());
            PointFeatureCollection pfc = fc.flatten(null, null, null);
            int count = 0;
            for (PointFeature pf : pfc) {
                StationPointFeature spf = (StationPointFeature)pf;
                if (count == 0) {
                    cfWriter.writeHeader(fc.getStationFeatures(), spf);
                }
                cfWriter.writeRecord(spf.getStation(), pf, pf.getFeatureData());
                if (debug && ++count % 100 == 0) {
                    System.out.printf("%d ", count);
                }
                if (!debug || count % 1000 != 0) continue;
                System.out.printf("%n ", new Object[0]);
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeProfileFeatureCollection(FeatureDatasetPoint fdpoint, ProfileFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFProfileCollection cfWriter = new WriterCFProfileCollection(fileOut, fdpoint.attributes(), fdpoint.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            cfWriter.setExtraVariables(fc.getExtraVariables());
            int count = 0;
            int name_strlen = 0;
            int nprofiles = fc.size();
            if (nprofiles < 0) {
                for (ProfileFeature pf : fc) {
                    name_strlen = Math.max(name_strlen, pf.getName().length());
                    ++count;
                }
                nprofiles = count;
            } else {
                for (ProfileFeature pf : fc) {
                    name_strlen = Math.max(name_strlen, pf.getName().length());
                    if (++count <= 10) continue;
                    break;
                }
            }
            cfWriter.setFeatureAuxInfo(nprofiles, name_strlen);
            count = 0;
            for (ProfileFeature profile : fc) {
                if (debug && (count += cfWriter.writeProfile(profile)) % 10 == 0) {
                    System.out.printf("%d ", count);
                }
                if (!debug || count % 100 != 0) continue;
                System.out.printf("%n ", new Object[0]);
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeTrajectoryFeatureCollection(FeatureDatasetPoint fdpoint, TrajectoryFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFTrajectoryCollection cfWriter = new WriterCFTrajectoryCollection(fileOut, fdpoint.attributes(), fdpoint.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            cfWriter.setExtraVariables(fc.getExtraVariables());
            int count = 0;
            int name_strlen = 0;
            int ntrajs = fc.size();
            if (ntrajs < 0) {
                for (TrajectoryFeature traj : fc) {
                    name_strlen = Math.max(name_strlen, traj.getName().length());
                    ++count;
                }
                ntrajs = count;
            }
            cfWriter.setFeatureAuxInfo(ntrajs, name_strlen);
            count = 0;
            for (TrajectoryFeature traj : fc) {
                if (debug && (count += cfWriter.writeTrajectory(traj)) % 10 == 0) {
                    System.out.printf("%d ", count);
                }
                if (!debug || count % 100 != 0) continue;
                System.out.printf("%n ", new Object[0]);
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeStationProfileFeatureCollection(FeatureDatasetPoint dataset, StationProfileFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFStationProfileCollection cfWriter = new WriterCFStationProfileCollection(fileOut, dataset.attributes(), dataset.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            cfWriter.setExtraVariables(fc.getExtraVariables());
            cfWriter.setStations(fc.getStationFeatures());
            int name_strlen = 0;
            int countProfiles = 0;
            for (StationProfileFeature spf : fc) {
                name_strlen = Math.max(name_strlen, spf.getName().length());
                if (spf.size() >= 0) {
                    countProfiles += spf.size();
                    continue;
                }
                countProfiles += Iterables.size((Iterable)spf);
            }
            cfWriter.setFeatureAuxInfo(countProfiles, name_strlen);
            int count = 0;
            for (StationProfileFeature spf : fc) {
                for (ProfileFeature pf : spf) {
                    if (pf.getTime() == null) continue;
                    if (debug && (count += cfWriter.writeProfile(spf, pf)) % 100 == 0) {
                        System.out.printf("%d ", count);
                    }
                    if (!debug || count % 1000 != 0) continue;
                    System.out.printf("%n ", new Object[0]);
                }
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeTrajectoryProfileFeatureCollection(FeatureDatasetPoint dataset, TrajectoryProfileFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFTrajectoryProfileCollection cfWriter = new WriterCFTrajectoryProfileCollection(fileOut, dataset.attributes(), dataset.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            cfWriter.setExtraVariables(fc.getExtraVariables());
            int traj_strlen = 0;
            int prof_strlen = 0;
            int countTrajectories = 0;
            int countProfiles = 0;
            for (TrajectoryProfileFeature spf : fc) {
                ++countTrajectories;
                traj_strlen = Math.max(traj_strlen, spf.getName().length());
                if (spf.size() >= 0) {
                    countProfiles += spf.size();
                    continue;
                }
                for (ProfileFeature profile : spf) {
                    prof_strlen = Math.max(prof_strlen, profile.getName().length());
                    ++countProfiles;
                }
            }
            cfWriter.setFeatureAuxInfo(countProfiles, prof_strlen);
            cfWriter.setFeatureAuxInfo2(countTrajectories, traj_strlen);
            int count = 0;
            for (TrajectoryProfileFeature spf : fc) {
                for (ProfileFeature profile : spf) {
                    if (profile.getTime() == null) continue;
                    if (debug && (count += cfWriter.writeProfile(spf, profile)) % 100 == 0) {
                        System.out.printf("%d ", count);
                    }
                    if (!debug || count % 1000 != 0) continue;
                    System.out.printf("%n ", new Object[0]);
                }
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    public static void main(String[] args) throws Exception {
        String progName = CFPointWriter.class.getName();
        try {
            CommandLine cmdLine = new CommandLine(progName, args);
            if (cmdLine.help) {
                cmdLine.printUsage();
                return;
            }
            FeatureType wantFeatureType = FeatureType.ANY_POINT;
            String location = cmdLine.inputFile.getAbsolutePath();
            CancelTask cancel = null;
            Formatter errlog = new Formatter();
            try (FeatureDatasetPoint fdPoint = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(wantFeatureType, location, cancel, errlog);){
                if (fdPoint == null) {
                    System.err.println(errlog);
                } else {
                    System.out.printf("CFPointWriter: reading from %s, writing to %s%n", cmdLine.inputFile, cmdLine.outputFile);
                    CFPointWriter.writeFeatureCollection(fdPoint, cmdLine.outputFile.getAbsolutePath(), cmdLine.getCFPointWriterConfig());
                    System.out.println("Done.");
                }
            }
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.err.printf("Try \"%s --help\" for more information.%n", progName);
        }
    }

    private static class CommandLine {
        @Parameter(names={"-i", "--input"}, description="Input file.", required=true)
        File inputFile;
        @Parameter(names={"-o", "--output"}, description="Output file.", required=true)
        File outputFile;
        @Parameter(names={"-f", "--format"}, description="Output file format. Allowed values = [netcdf3, netcdf4, netcdf4_classic, netcdf3c, netcdf3c64, ncstream]")
        public NetcdfFileWriter.Version format = NetcdfFileWriter.Version.netcdf3;
        @Parameter(names={"-st", "--strategy"}, description="Chunking strategy. Only used in NetCDF 4. Allowed values = [standard, grib, none]")
        public Nc4Chunking.Strategy strategy = Nc4Chunking.Strategy.standard;
        @Parameter(names={"-d", "--deflateLevel"}, description="Compression level. Only used in NetCDF 4. Allowed values = 0 (no compression, fast) to 9 (max compression, slow)")
        public int deflateLevel = 5;
        @Parameter(names={"-sh", "--shuffle"}, description="Enable the shuffle filter, which may improve compression. Only used in NetCDF 4. This option is ignored unless a non-zero deflate level is specified.")
        public boolean shuffle = true;
        @Parameter(names={"-h", "--help"}, description="Display this help and exit", help=true)
        public boolean help;
        private final JCommander jc;

        CommandLine(String progName, String[] args) throws ParameterException {
            this.jc = new JCommander((Object)this, args);
            this.jc.setProgramName(progName);
            this.jc.setParameterDescriptionComparator((Comparator)new ParameterDescriptionComparator());
        }

        void printUsage() {
            this.jc.usage();
        }

        Nc4Chunking getNc4Chunking() {
            return Nc4ChunkingStrategy.factory(this.strategy, this.deflateLevel, this.shuffle);
        }

        public CFPointWriterConfig getCFPointWriterConfig() {
            return CFPointWriterConfig.builder().setFormat(NetcdfFormatWriter.convertToNetcdfFileFormat(this.format)).setChunking(this.getNc4Chunking()).build();
        }

        private static class ParameterDescriptionComparator
        implements Comparator<ParameterDescription> {
            private final List<String> orderedParamNames = Arrays.asList("--input", "--output", "--format", "--strategy", "--deflateLevel", "--shuffle", "--help");

            private ParameterDescriptionComparator() {
            }

            @Override
            public int compare(ParameterDescription p0, ParameterDescription p1) {
                int index0 = this.orderedParamNames.indexOf(p0.getLongestName());
                int index1 = this.orderedParamNames.indexOf(p1.getLongestName());
                assert (index0 >= 0) : "Unexpected parameter name: " + p0.getLongestName();
                assert (index1 >= 0) : "Unexpected parameter name: " + p1.getLongestName();
                return Integer.compare(index0, index1);
            }
        }
    }
}

