/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.hdf4;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.iosp.hdf4.HdfHeaderIF;
import ucar.nc2.iosp.hdf4.ODLparser;

public class HdfEos {
    public static final String HDF5_GROUP = "HDFEOS_INFORMATION";
    public static final String HDFEOS_CRS = "_HDFEOS_CRS";
    public static final String HDFEOS_CRS_Projection = "Projection";
    public static final String HDFEOS_CRS_UpperLeft = "UpperLeftPointMtrs";
    public static final String HDFEOS_CRS_LowerRight = "LowerRightMtrs";
    public static final String HDFEOS_CRS_ProjParams = "ProjParams";
    public static final String HDFEOS_CRS_SphereCode = "SphereCode";
    private static Logger log = LoggerFactory.getLogger(HdfEos.class);
    static boolean showWork;
    private static final String GEOLOC_FIELDS = "Geolocation Fields";
    private static final String GEOLOC_FIELDS2 = "Geolocation_Fields";
    private static final String DATA_FIELDS = "Data Fields";
    private static final String DATA_FIELDS2 = "Data_Fields";
    private String location;
    private HdfHeaderIF header;

    public static boolean amendFromODL(HdfHeaderIF header, Group.Builder eosGroup) throws IOException {
        String smeta = HdfEos.getStructMetadata(header, eosGroup);
        if (smeta == null) {
            return false;
        }
        HdfEos fixer = new HdfEos();
        fixer.fixAttributes(eosGroup);
        fixer.amendFromODL(header, header.getRootGroup(), smeta);
        return true;
    }

    public static boolean getEosInfo(HdfHeaderIF header, Group.Builder eosGroup, Formatter f) throws IOException {
        String smeta = HdfEos.getStructMetadata(header, eosGroup);
        if (smeta == null) {
            f.format("No StructMetadata variables in group %s %n", eosGroup.shortName);
            return false;
        }
        f.format("raw = %n%s%n", smeta);
        ODLparser parser = new ODLparser();
        parser.parseFromString(smeta);
        StringWriter sw = new StringWriter(5000);
        parser.showDoc(new PrintWriter(sw));
        f.format("parsed = %n%s%n", sw.toString());
        return true;
    }

    private static String getStructMetadata(HdfHeaderIF header, Group.Builder eosGroup) throws IOException {
        Variable.Builder structMetadataVar;
        StringBuilder sbuff = null;
        String structMetadata = null;
        int n = 0;
        while ((structMetadataVar = (Variable.Builder)eosGroup.findVariable("StructMetadata." + n).orElse(null)) != null) {
            if (structMetadata != null && sbuff == null) {
                sbuff = new StringBuilder(64000);
                sbuff.append(structMetadata);
            }
            structMetadata = header.readStructMetadata(structMetadataVar);
            if (sbuff != null) {
                sbuff.append(structMetadata);
            }
            ++n;
        }
        return sbuff != null ? sbuff.toString() : structMetadata;
    }

    private void amendFromODL(HdfHeaderIF header, Group.Builder rootg, String structMetadata) {
        Element pointStructure;
        Element gridStructure;
        this.header = header;
        ODLparser parser = new ODLparser();
        Element root = parser.parseFromString(structMetadata);
        Enum featureType = null;
        Element swathStructure = root.getChild("SwathStructure");
        if (swathStructure != null) {
            List swaths = swathStructure.getChildren();
            for (Element elemSwath : swaths) {
                Element swathNameElem = elemSwath.getChild("SwathName");
                if (swathNameElem == null) {
                    log.warn("No SwathName element in {} {} ", (Object)elemSwath.getName(), (Object)this.location);
                    continue;
                }
                String swathName = NetcdfFiles.makeValidCdmObjectName(swathNameElem.getText().trim());
                Group.Builder swathGroup = this.findGroupNested(rootg, swathName);
                if (swathGroup != null) {
                    featureType = this.amendSwath(elemSwath, swathGroup);
                    continue;
                }
                log.warn("Cant find swath group {} {}", (Object)swathName, (Object)this.location);
            }
        }
        if ((gridStructure = root.getChild("GridStructure")) != null) {
            List grids = gridStructure.getChildren();
            for (Element elemGrid : grids) {
                Element gridNameElem = elemGrid.getChild("GridName");
                if (gridNameElem == null) {
                    log.warn("No GridName element in {} {} ", (Object)elemGrid.getName(), (Object)this.location);
                    continue;
                }
                String gridName = NetcdfFiles.makeValidCdmObjectName(gridNameElem.getText().trim());
                Group.Builder gridGroup = this.findGroupNested(rootg, gridName);
                if (gridGroup != null) {
                    featureType = this.amendGrid(elemGrid, gridGroup, this.location);
                    continue;
                }
                log.warn("Cant find Grid group {} {}", (Object)gridName, (Object)this.location);
            }
        }
        if ((pointStructure = root.getChild("PointStructure")) != null) {
            List pts = pointStructure.getChildren();
            for (Element elem : pts) {
                Element nameElem = elem.getChild("PointName");
                if (nameElem == null) {
                    log.warn("No PointName element in {} {}", (Object)elem.getName(), (Object)this.location);
                    continue;
                }
                String name = nameElem.getText().trim();
                Group.Builder ptGroup = this.findGroupNested(rootg, name);
                if (ptGroup != null) {
                    featureType = FeatureType.POINT;
                    continue;
                }
                log.warn("Cant find Point group {} {}", (Object)name, (Object)this.location);
            }
        }
        if (featureType != null) {
            if (showWork) {
                log.debug("***EOS featureType= {}", featureType);
            }
            rootg.addAttribute(new Attribute("featureType", featureType.toString()));
        }
    }

    private FeatureType amendSwath(Element swathElem, Group.Builder parent) {
        Group.Builder dataG;
        Object v;
        FeatureType featureType = FeatureType.SWATH;
        ArrayList<Dimension> unknownDims = new ArrayList<Dimension>();
        Element d = swathElem.getChild("Dimension");
        List dims = d.getChildren();
        for (Element elem : dims) {
            Object name = elem.getChild("DimensionName").getText().trim();
            if (((String)(name = NetcdfFiles.makeValidCdmObjectName((String)name))).equalsIgnoreCase("scalar")) continue;
            String sizeS = elem.getChild("Size").getText().trim();
            int length = Integer.parseInt(sizeS);
            if (length > 0) {
                Dimension dim = parent.findDimensionLocal((String)name).orElse(null);
                if (dim != null) {
                    if (dim.getLength() == length) continue;
                    log.error("Conflicting Dimensions = {} != {} in location {}", new Object[]{dim, length, this.location});
                    continue;
                }
                dim = new Dimension((String)name, length);
                if (!parent.addDimensionIfNotExists(dim) || !showWork) continue;
                log.debug(" Add dimension {}", (Object)dim);
                continue;
            }
            log.warn("Dimension {} has size {} {}", new Object[]{name, sizeS, this.location});
            Dimension udim = new Dimension((String)name, 1);
            unknownDims.add(udim);
            if (!showWork) continue;
            log.debug(" Add dimension {}", (Object)udim);
        }
        Element dmap = swathElem.getChild("DimensionMap");
        List dimMaps = dmap.getChildren();
        for (Element elem : dimMaps) {
            String geoDimName = elem.getChild("GeoDimension").getText().trim();
            geoDimName = NetcdfFiles.makeValidCdmObjectName(geoDimName);
            String dataDimName = elem.getChild("DataDimension").getText().trim();
            dataDimName = NetcdfFiles.makeValidCdmObjectName(dataDimName);
            String offsetS = elem.getChild("Offset").getText().trim();
            String incrS = elem.getChild("Increment").getText().trim();
            int offset = Integer.parseInt(offsetS);
            int incr = Integer.parseInt(incrS);
            v = Variable.builder().setName(dataDimName);
            ((Variable.Builder)v).setDimensionsByName(geoDimName);
            ((Variable.Builder)v).setDataType(DataType.INT);
            ((Variable.Builder)v).setAutoGen(offset, incr);
            ((Variable.Builder)v).addAttribute(new Attribute("_DimensionMap", ""));
            parent.addVariable((Variable.Builder<?>)v);
            this.header.makeVinfoForDimensionMapVariable(parent, (Variable.Builder<?>)v);
            if (!showWork) continue;
            log.debug(" Add dimensionMap {}", v);
        }
        Group.Builder geoFieldsG = parent.findGroup(GEOLOC_FIELDS).orElse(parent.findGroup(GEOLOC_FIELDS2).orElse(null));
        if (geoFieldsG != null) {
            Variable.Builder latAxis = null;
            Variable.Builder lonAxis = null;
            Variable.Builder timeAxis = null;
            Element floc = swathElem.getChild("GeoField");
            for (Element elem : floc.getChildren()) {
                String varname = elem.getChild("GeoFieldName").getText().trim();
                Variable.Builder vb = geoFieldsG.findVariable(varname).orElse(null);
                if (vb != null) {
                    AxisType axis = this.addAxisType(vb);
                    if (axis == AxisType.Lat) {
                        latAxis = vb;
                    }
                    if (axis == AxisType.Lon) {
                        lonAxis = vb;
                    }
                    if (axis == AxisType.Time) {
                        timeAxis = vb;
                    }
                    Element dimList = elem.getChild("DimList");
                    List values = dimList.getChildren("value");
                    this.setSharedDimensions(geoFieldsG, vb, values, unknownDims, this.location);
                    if (showWork) {
                        log.debug(" set coordinate {}", (Object)vb);
                    }
                }
                if (latAxis == null || lonAxis == null) continue;
                log.debug("found lonAxis and latAxis -- testing XY domain");
                int xyDomainSize = CoordSystemBuilder.countDomainSize(geoFieldsG, latAxis, lonAxis);
                log.debug("xyDomain size {}", (Object)xyDomainSize);
                if (xyDomainSize >= 2) continue;
                if (timeAxis != null) {
                    log.debug("found timeAxis -- testing if trajectory");
                    String dd1 = timeAxis.getFirstDimensionName();
                    String dd2 = latAxis.getFirstDimensionName();
                    String dd3 = lonAxis.getFirstDimensionName();
                    if (dd1.equals(dd2) && dd1.equals(dd3)) {
                        featureType = FeatureType.TRAJECTORY;
                        continue;
                    }
                    featureType = FeatureType.PROFILE;
                    continue;
                }
                featureType = FeatureType.PROFILE;
            }
        }
        if ((dataG = (Group.Builder)parent.findGroup(DATA_FIELDS).orElse(parent.findGroup(DATA_FIELDS2).orElse(null))) != null) {
            Element f = swathElem.getChild("DataField");
            List vars = f.getChildren();
            for (Element elem : vars) {
                Element dataFieldNameElem = elem.getChild("DataFieldName");
                if (dataFieldNameElem == null) continue;
                String varname = NetcdfFile.makeValidCdmObjectName(dataFieldNameElem.getText().trim());
                v = dataG.findVariable(varname).orElse(null);
                if (v == null) {
                    log.error("Cant find variable {} {}", (Object)varname, (Object)this.location);
                    continue;
                }
                Element dimList = elem.getChild("DimList");
                List values = dimList.getChildren("value");
                this.setSharedDimensions(dataG, (Variable.Builder<?>)v, values, (List<Dimension>)unknownDims, this.location);
            }
        }
        return featureType;
    }

    private AxisType addAxisType(Variable.Builder v) {
        String name = v.shortName;
        if (name.equalsIgnoreCase("Latitude") || name.equalsIgnoreCase("GeodeticLatitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
            v.addAttribute(new Attribute("units", "degrees_north"));
            return AxisType.Lat;
        }
        if (name.equalsIgnoreCase("Longitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
            v.addAttribute(new Attribute("units", "degrees_east"));
            return AxisType.Lon;
        }
        if (name.equalsIgnoreCase("Time")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
            if (v.getAttributeContainer().findAttribute("units") == null) {
                v.addAttribute(new Attribute("units", "seconds since 1993-01-01T00:00:00Z"));
                v.addAttribute(new Attribute("calendar", "TAI"));
            }
            return AxisType.Time;
        }
        if (name.equalsIgnoreCase("Pressure")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            return AxisType.Pressure;
        }
        if (name.equalsIgnoreCase("Altitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
            v.addAttribute(new Attribute("positive", "up"));
            return AxisType.Height;
        }
        return null;
    }

    private FeatureType amendGrid(Element gridElem, Group.Builder parent, String location) {
        Group.Builder dataG;
        ArrayList<Dimension> unknownDims = new ArrayList<Dimension>();
        String xdimSizeS = gridElem.getChild("XDim").getText().trim();
        String ydimSizeS = gridElem.getChild("YDim").getText().trim();
        int xdimSize = Integer.parseInt(xdimSizeS);
        int ydimSize = Integer.parseInt(ydimSizeS);
        parent.addDimensionIfNotExists(new Dimension("XDim", xdimSize));
        parent.addDimensionIfNotExists(new Dimension("YDim", ydimSize));
        Element proj = gridElem.getChild(HDFEOS_CRS_Projection);
        if (proj != null) {
            Object crs = Variable.builder().setName(HDFEOS_CRS);
            ((Variable.Builder)crs).setDataType(DataType.SHORT);
            ((Variable.Builder)crs).setIsScalar();
            ((Variable.Builder)crs).setAutoGen(0.0, 0.0);
            parent.addVariable((Variable.Builder<?>)crs);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_Projection, (Variable.Builder<?>)crs, false);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_UpperLeft, (Variable.Builder<?>)crs, true);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_LowerRight, (Variable.Builder<?>)crs, true);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_ProjParams, (Variable.Builder<?>)crs, true);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_SphereCode, (Variable.Builder<?>)crs, false);
        }
        Element d = gridElem.getChild("Dimension");
        List dims = d.getChildren();
        for (Element elem : dims) {
            String name = elem.getChild("DimensionName").getText().trim();
            if ((name = NetcdfFiles.makeValidCdmObjectName(name)).equalsIgnoreCase("scalar")) continue;
            String sizeS = elem.getChild("Size").getText().trim();
            int length = Integer.parseInt(sizeS);
            Dimension old = parent.findDimension(name).orElse(null);
            if (old != null && old.getLength() == length) continue;
            if (length > 0) {
                Dimension dim = new Dimension(name, length);
                if (!parent.addDimensionIfNotExists(dim) || !showWork) continue;
                log.debug(" Add dimension {}", (Object)dim);
                continue;
            }
            log.warn("Dimension {} has size {} {} ", new Object[]{sizeS, name, location});
            Dimension udim = new Dimension(name, 1);
            unknownDims.add(udim);
            if (!showWork) continue;
            log.debug(" Add dimension {}", (Object)udim);
        }
        Group.Builder geoFieldsG = parent.findGroup(GEOLOC_FIELDS).orElse(parent.findGroup(GEOLOC_FIELDS2).orElse(null));
        if (geoFieldsG != null) {
            Element floc = gridElem.getChild("GeoField");
            List varsLoc = floc.getChildren();
            for (Element elem : varsLoc) {
                String varname = elem.getChild("GeoFieldName").getText().trim();
                geoFieldsG.findVariable(varname).ifPresent(vb -> {
                    Element dimList = elem.getChild("DimList");
                    List values = dimList.getChildren("value");
                    this.setSharedDimensions(geoFieldsG, (Variable.Builder<?>)vb, values, (List<Dimension>)unknownDims, location);
                });
            }
        }
        if ((dataG = (Group.Builder)parent.findGroup(DATA_FIELDS).orElse(parent.findGroup(DATA_FIELDS2).orElse(null))) != null) {
            boolean isLatLon;
            Element f = gridElem.getChild("DataField");
            List vars = f.getChildren();
            for (Element elem : vars) {
                String varname = elem.getChild("DataFieldName").getText().trim();
                varname = NetcdfFiles.makeValidCdmObjectName(varname);
                dataG.findVariable(varname).ifPresent(vb -> {
                    Element dimList = elem.getChild("DimList");
                    List values = dimList.getChildren("value");
                    this.setSharedDimensions(dataG, (Variable.Builder<?>)vb, values, (List<Dimension>)unknownDims, location);
                });
            }
            String projS = null;
            Element projElem = gridElem.getChild(HDFEOS_CRS_Projection);
            if (projElem != null) {
                projS = projElem.getText().trim();
            }
            if (isLatLon = "GCTP_GEO".equals(projS)) {
                for (Variable.Builder<?> v : dataG.vbuilders) {
                    if (!CoordSystemBuilder.isCoordinateVariable(v)) continue;
                    if (v.shortName.equals("YDim")) {
                        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                        v.addAttribute(new Attribute("units", "degrees_north"));
                    }
                    if (!v.shortName.equals("XDim")) continue;
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                    v.addAttribute(new Attribute("units", "degrees_east"));
                }
            }
        }
        return FeatureType.GRID;
    }

    private void addAttributeIfExists(Element elem, String name, Variable.Builder<?> v, boolean isDoubleArray) {
        Element child = elem.getChild(name);
        if (child == null) {
            return;
        }
        if (isDoubleArray) {
            List vElems = child.getChildren();
            ArrayList<Object> values = new ArrayList<Object>();
            for (Element ve : vElems) {
                String valueS = ve.getText().trim();
                try {
                    values.add(Double.parseDouble(valueS));
                }
                catch (NumberFormatException e) {
                    log.warn("Cant parse double value " + valueS);
                }
            }
            Attribute att = Attribute.builder(name).setValues(values, false).build();
            v.addAttribute(att);
        } else {
            String value = child.getText().trim();
            Attribute att = new Attribute(name, value);
            v.addAttribute(att);
        }
    }

    private void setSharedDimensions(Group.Builder group, Variable.Builder<?> v, List<Element> values, List<Dimension> unknownDims, String location) {
        if (values.isEmpty()) {
            return;
        }
        Iterator<Element> iter = values.iterator();
        while (iter.hasNext()) {
            Element value = iter.next();
            String dimName = value.getText().trim();
            if (!dimName.equalsIgnoreCase("scalar")) continue;
            iter.remove();
        }
        ImmutableList<Dimension> oldDims = v.getDimensions(group);
        if (oldDims.size() != values.size()) {
            log.error("Different number of dimensions for {} {}", (Object)v.shortName, (Object)location);
            return;
        }
        ArrayList<Dimension> newDims = new ArrayList<Dimension>();
        for (int i = 0; i < values.size(); ++i) {
            Element value = values.get(i);
            String dimName = value.getText().trim();
            dimName = NetcdfFiles.makeValidCdmObjectName(dimName);
            Dimension dim = group.findDimension(dimName).orElse(null);
            Dimension oldDim = (Dimension)oldDims.get(i);
            if (dim == null) {
                dim = this.checkUnknownDims(dimName, unknownDims, oldDim, location);
            }
            if (dim == null) {
                log.error("Unknown Dimension= {} for variable = {} {} ", new Object[]{dimName, v.shortName, location});
                return;
            }
            if (dim.getLength() != oldDim.getLength()) {
                log.error("Shared dimension ({}) has different length than data dimension ({}) shared={} org={} for {} {}", new Object[]{dim.getShortName(), oldDim.getShortName(), dim.getLength(), oldDim.getLength(), v, location});
                return;
            }
            newDims.add(dim);
        }
        v.setDimensions(newDims);
        if (showWork) {
            log.debug(" set shared dimensions for {}", (Object)v.shortName);
        }
    }

    private Dimension checkUnknownDims(String wantDim, List<Dimension> unknownDims, Dimension oldDim, String location) {
        for (Dimension dim : unknownDims) {
            if (!dim.getShortName().equals(wantDim)) continue;
            int len = oldDim.getLength();
            if (len == 0) {
                dim.setUnlimited(true);
            }
            dim.setLength(len);
            Group parent = dim.getGroup();
            parent.addDimensionIfNotExists(dim);
            unknownDims.remove(dim);
            log.warn("unknownDim {} length set to {}{}", new Object[]{wantDim, oldDim.getLength(), location});
            return dim;
        }
        return null;
    }

    private Group.Builder findGroupNested(Group.Builder parent, String name) {
        for (Group.Builder g : parent.gbuilders) {
            if (!g.shortName.equals(name)) continue;
            return g;
        }
        for (Group.Builder g : parent.gbuilders) {
            Group.Builder result = this.findGroupNested(g, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void fixAttributes(Group.Builder g) {
        for (Variable.Builder<?> v : g.vbuilders) {
            AttributeContainerMutable attHelper = v.getAttributeContainer();
            for (Attribute a : ImmutableList.copyOf(attHelper.getAttributes())) {
                if (a.getShortName().equalsIgnoreCase("UNIT") || a.getShortName().equalsIgnoreCase("UNITS")) {
                    attHelper.replace(a, "units");
                }
                if (a.getShortName().equalsIgnoreCase("SCALE_FACTOR") || a.getShortName().equalsIgnoreCase("FACTOR")) {
                    attHelper.replace(a, "scale_factor");
                }
                if (!a.getShortName().equalsIgnoreCase("OFFSET")) continue;
                attHelper.replace(a, "add_offset");
            }
        }
        for (Group.Builder ng : g.gbuilders) {
            this.fixAttributes(ng);
        }
    }
}

