/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataScalar;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.ft.point.writer.CFPointWriterUtils;
import ucar.nc2.time.CalendarDateUnit;

public class WriterCFStationProfileCollection
extends CFPointWriter {
    private static Logger log = LoggerFactory.getLogger(WriterCFStationProfileCollection.class);
    private List<StationFeature> stnList;
    protected Structure stationStruct;
    private HashMap<String, Integer> stationIndexMap;
    private boolean useDesc;
    private boolean useAlt;
    private boolean useWmoId;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private Map<String, Variable> stationVarMap = new HashMap<String, Variable>();
    protected Structure profileStruct;
    private Map<String, Variable> profileVarMap = new HashMap<String, Variable>();
    private boolean headerDone;
    private int stnRecno;
    private int profileRecno;
    private int obsRecno;

    public WriterCFStationProfileCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.timeSeriesProfile.name()));
        this.writer.addGroupAttribute(null, new Attribute("DSG_representation", "Ragged array representation of time series profiless, H.5.3"));
    }

    public void setStations(List<StationFeature> stns) {
        this.stnList = stns;
        for (StationFeature stn : this.stnList) {
            if (!Double.isNaN(stn.getAltitude())) {
                this.useAlt = true;
            }
            if (stn.getWmoId() != null && !stn.getWmoId().trim().isEmpty()) {
                this.useWmoId = true;
            }
            if (stn.getDescription() != null && !stn.getDescription().trim().isEmpty()) {
                this.useDesc = true;
            }
            this.id_strlen = Math.max(this.id_strlen, stn.getName().length());
            if (stn.getDescription() != null) {
                this.desc_strlen = Math.max(this.desc_strlen, stn.getDescription().length());
            }
            if (stn.getWmoId() == null) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, stn.getWmoId().length());
        }
        this.llbb = CFPointWriterUtils.getBoundingBox(this.stnList);
    }

    public int writeProfile(StationProfileFeature spf, ProfileFeature profile) throws IOException {
        int count = 0;
        for (PointFeature pf : profile) {
            if (!this.headerDone) {
                if (this.id_strlen == 0) {
                    this.id_strlen = profile.getName().length() * 2;
                }
                this.writeHeader(spf, profile, pf);
                this.headerDone = true;
            }
            this.writeObsData(pf);
            ++count;
        }
        Integer stnIndex = this.stationIndexMap.get(spf.getName());
        if (stnIndex == null) {
            log.warn("BAD station {}", (Object)spf.getName());
        } else {
            this.writeProfileData(stnIndex, profile, count);
        }
        return count;
    }

    private void writeHeader(StationProfileFeature stn, ProfileFeature profile, PointFeature obs) throws IOException {
        StructureData stnData = stn.getFeatureData();
        StructureData profileData = profile.getFeatureData();
        StructureData obsData = obs.getFeatureData();
        ArrayList<VariableSimpleIF> obsCoords = new ArrayList<VariableSimpleIF>();
        Formatter coordNames = new Formatter().format("%s %s %s", "profileTime", "latitude", "longitude");
        obsCoords.add(VariableSimpleBuilder.makeScalar(this.altitudeCoordinateName, "obs altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "altitude").addAttribute("positive", CF1Convention.getZisPositive(this.altitudeCoordinateName, this.altUnits)).build());
        coordNames.format(" %s", this.altitudeCoordinateName);
        super.writeHeader2(obsCoords, stnData, profileData, obsData, coordNames.toString());
        int count = 0;
        this.stationIndexMap = new HashMap(2 * this.stnList.size());
        for (StationFeature sf : this.stnList) {
            this.writeStationData(sf);
            this.stationIndexMap.put(sf.getName(), count);
            ++count;
        }
    }

    @Override
    protected void makeFeatureVariables(StructureData stnData, boolean isExtended) {
        Dimension stationDim = this.writer.addDimension(null, "station", this.stnList.size());
        ArrayList<VariableSimpleIF> stnVars = new ArrayList<VariableSimpleIF>();
        stnVars.add(VariableSimpleBuilder.makeScalar("latitude", "station latitude", "degrees_north", DataType.DOUBLE).build());
        stnVars.add(VariableSimpleBuilder.makeScalar("longitude", "station longitude", "degrees_east", DataType.DOUBLE).build());
        if (this.useAlt) {
            stnVars.add(VariableSimpleBuilder.makeScalar("stationAltitude", "station altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "surface_altitude").addAttribute("positive", CF1Convention.getZisPositive("altitude", this.altUnits)).build());
        }
        stnVars.add(VariableSimpleBuilder.makeString("station_id", "station identifier", null, this.id_strlen).addAttribute("cf_role", "timeseries_id").build());
        if (this.useDesc) {
            stnVars.add(VariableSimpleBuilder.makeString("station_description", "station description", null, this.desc_strlen).addAttribute("standard_name", "platform_name").build());
        }
        if (this.useWmoId) {
            stnVars.add(VariableSimpleBuilder.makeString("wmo_id", "station WMO id", null, this.wmo_strlen).addAttribute("standard_name", "platform_id").build());
        }
        for (StructureMembers.Member m : stnData.getMembers()) {
            if (this.getDataVar(m.getName()) == null) continue;
            stnVars.add(VariableSimpleBuilder.fromMember(m).build());
        }
        if (isExtended) {
            this.stationStruct = (Structure)this.writer.addVariable(null, "station", DataType.STRUCTURE, "station");
            this.addCoordinatesExtended(this.stationStruct, stnVars);
        } else {
            this.addCoordinatesClassic(stationDim, stnVars, this.stationVarMap);
        }
    }

    private void writeStationData(StationFeature stn) throws IOException {
        StructureDataScalar stnCoords = new StructureDataScalar("Coords");
        stnCoords.addMember("latitude", null, null, DataType.DOUBLE, stn.getLatLon().getLatitude());
        stnCoords.addMember("longitude", null, null, DataType.DOUBLE, stn.getLatLon().getLongitude());
        if (this.useAlt) {
            stnCoords.addMember("stationAltitude", null, null, DataType.DOUBLE, stn.getAltitude());
        }
        stnCoords.addMemberString("station_id", null, null, stn.getName().trim(), this.id_strlen);
        if (this.useDesc) {
            stnCoords.addMemberString("station_description", null, null, stn.getDescription().trim(), this.desc_strlen);
        }
        if (this.useWmoId) {
            stnCoords.addMemberString("wmo_id", null, null, stn.getWmoId().trim(), this.wmo_strlen);
        }
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(stnCoords);
        sdall.add(stn.getFeatureData());
        this.stnRecno = super.writeStructureData(this.stnRecno, this.stationStruct, sdall, this.stationVarMap);
    }

    @Override
    protected void makeMiddleVariables(StructureData profileData, boolean isExtended) {
        Dimension profileDim = this.writer.addDimension(null, "profile", this.nfeatures);
        ArrayList<VariableSimpleIF> profileVars = new ArrayList<VariableSimpleIF>();
        profileVars.add(VariableSimpleBuilder.makeString("profileId", "profile identifier", null, this.id_strlen).addAttribute("cf_role", "profile_id").addAttribute("missing_value", String.valueOf(-9999)).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).addAttribute("sample_dimension", "obs").build());
        profileVars.add(VariableSimpleBuilder.makeScalar("profileTime", "nominal time of profile", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("stationIndex", "station index for this profile", null, DataType.INT).addAttribute("instance_dimension", "station").build());
        for (StructureMembers.Member m : profileData.getMembers()) {
            VariableSimpleIF dv = this.getDataVar(m.getName());
            if (dv == null) continue;
            profileVars.add(dv);
        }
        if (isExtended) {
            this.profileStruct = (Structure)this.writer.addVariable(null, "profile", DataType.STRUCTURE, "profile");
            this.addCoordinatesExtended(this.profileStruct, profileVars);
        } else {
            this.addCoordinatesClassic(profileDim, profileVars, this.profileVarMap);
        }
    }

    public void writeProfileData(int stnIndex, ProfileFeature profile, int nobs) throws IOException {
        this.trackBB(profile.getLatLon(), profile.getTime());
        StructureDataScalar profileCoords = new StructureDataScalar("Coords");
        profileCoords.addMember("latitude", null, null, DataType.DOUBLE, profile.getLatLon().getLatitude());
        profileCoords.addMember("longitude", null, null, DataType.DOUBLE, profile.getLatLon().getLongitude());
        double timeInMyUnits = this.timeUnit.makeOffsetFromRefDate(profile.getTime());
        profileCoords.addMember("profileTime", null, null, DataType.DOUBLE, timeInMyUnits);
        profileCoords.addMemberString("profileId", null, null, profile.getName().trim(), this.id_strlen);
        profileCoords.addMember("nobs", null, null, DataType.INT, nobs);
        profileCoords.addMember("stationIndex", null, null, DataType.INT, stnIndex);
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(profileCoords);
        sdall.add(profile.getFeatureData());
        this.profileRecno = super.writeStructureData(this.profileRecno, this.profileStruct, sdall, this.profileVarMap);
    }

    public void writeObsData(PointFeature pf) throws IOException {
        StructureDataScalar coords = new StructureDataScalar("Coords");
        coords.addMember(this.altitudeCoordinateName, null, null, DataType.DOUBLE, pf.getLocation().getAltitude());
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(coords);
        sdall.add(pf.getFeatureData());
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

