/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import ucar.nc2.util.UnsynchronizedBufferedWriter;
import ucar.unidata.io.RandomAccessFile;

public class IO {
    public static final int default_file_buffersize = 9200;
    public static final int default_socket_buffersize = 64000;
    private static final boolean showStackTrace = false;
    private static final boolean debug = false;
    private static final boolean showCopy = false;
    private static final boolean showHeaders = false;
    private static Class cl;

    public static InputStream getFileResource(String resourcePath) {
        InputStream is;
        if (cl == null) {
            cl = IO.class;
        }
        if ((is = cl.getResourceAsStream(resourcePath)) != null) {
            return is;
        }
        try {
            is = new FileInputStream(resourcePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return is;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        long totalBytesRead = 0L;
        byte[] buffer = new byte[9200];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            totalBytesRead += (long)bytesRead;
        }
        out.flush();
        return totalBytesRead;
    }

    public static long copy2null(InputStream in, int buffersize) throws IOException {
        int n;
        long totalBytesRead = 0L;
        if (buffersize <= 0) {
            buffersize = 9200;
        }
        byte[] buffer = new byte[buffersize];
        while ((n = in.read(buffer)) != -1) {
            totalBytesRead += (long)n;
        }
        return totalBytesRead;
    }

    public static long touch(InputStream in, int buffersize) throws IOException {
        int n;
        long touch = 0L;
        if (buffersize <= 0) {
            buffersize = 9200;
        }
        byte[] buffer = new byte[buffersize];
        while ((n = in.read(buffer)) != -1) {
            for (int i = 0; i < buffersize; ++i) {
                touch += (long)buffer[i];
            }
        }
        return touch;
    }

    public static long copy2null(FileChannel in, int buffersize) throws IOException {
        int n;
        long totalBytesRead = 0L;
        if (buffersize <= 0) {
            buffersize = 9200;
        }
        ByteBuffer buffer = ByteBuffer.allocate(buffersize);
        while ((n = in.read(buffer)) != -1) {
            totalBytesRead += (long)n;
            buffer.flip();
        }
        return totalBytesRead;
    }

    public static long touch(FileChannel in, int buffersize) throws IOException {
        int n;
        long touch = 0L;
        if (buffersize <= 0) {
            buffersize = 9200;
        }
        ByteBuffer buffer = ByteBuffer.allocate(buffersize);
        while ((n = in.read(buffer)) != -1) {
            byte[] result = buffer.array();
            for (int i = 0; i < buffersize; ++i) {
                touch += (long)result[i];
            }
            buffer.flip();
        }
        return touch;
    }

    public static long copyB(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int n;
        long totalBytesRead = 0L;
        boolean done = false;
        boolean next = true;
        byte[] buffer = new byte[bufferSize];
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
            totalBytesRead += (long)n;
        }
        out.flush();
        return totalBytesRead;
    }

    public static void copy(InputStream in, OutputStream out, int n) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[9200];
        int count = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            if ((count += bytesRead) <= n) continue;
            return;
        }
        out.flush();
    }

    public static String readContents(InputStream is) throws IOException {
        return IO.readContents(is, "UTF-8");
    }

    public static String readContents(InputStream is, String charset) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(92000);
        IO.copy(is, bout);
        return bout.toString(charset);
    }

    public static byte[] readContentsToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(92000);
        IO.copy(is, bout);
        return bout.toByteArray();
    }

    public static void writeContents(String contents, OutputStream os) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
        IO.copy(bin, os);
    }

    public static void copyFile(String fileInName, String fileOutName) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileInName);
             FileOutputStream fout = new FileOutputStream(fileOutName);){
            BufferedInputStream in = new BufferedInputStream(fin);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            IO.copy(in, out);
        }
    }

    public static void copyFile(File fileIn, File fileOut) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileIn);
             FileOutputStream fout = new FileOutputStream(fileOut);){
            BufferedInputStream in = new BufferedInputStream(fin);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            IO.copy(in, out);
        }
    }

    public static void copy2File(byte[] src, String fileOut) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(fileOut);){
            BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src));
            BufferedOutputStream out = new BufferedOutputStream(fout);
            IO.copy(in, out);
        }
    }

    public static void copyFile(String fileInName, OutputStream out) throws IOException {
        IO.copyFileB(new File(fileInName), out, 9200);
    }

    public static void copyFileB(File fileIn, OutputStream out, int bufferSize) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileIn);){
            BufferedInputStream in = new BufferedInputStream(fin);
            IO.copyB(in, out, bufferSize);
        }
    }

    public static void copyFileWithChannels(File fileIn, WritableByteChannel out) throws IOException {
        try (FileChannel in = new FileInputStream(fileIn).getChannel();){
            long did;
            long want = fileIn.length();
            long pos = 0L;
            while ((did = in.transferTo(pos, want, out)) != want) {
                pos += did;
                want -= did;
            }
        }
    }

    public static long copyRafB(RandomAccessFile raf, long offset, long length, OutputStream out, byte[] buffer) throws IOException {
        int len;
        long want;
        int bytesRead;
        int bufferSize = buffer.length;
        raf.seek(offset);
        for (want = length; want > 0L && (bytesRead = raf.read(buffer, 0, len = (int)Math.min(want, (long)bufferSize))) > 0; want -= (long)bytesRead) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
        return length - want;
    }

    public static void copyDirTree(String fromDirName, String toDirName) throws IOException {
        File fromDir = new File(fromDirName);
        File toDir = new File(toDirName);
        if (!fromDir.exists()) {
            return;
        }
        if (!toDir.exists() && !toDir.mkdirs()) {
            throw new IOException("Could not create directory: " + toDir);
        }
        File[] files = fromDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    IO.copyDirTree(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
                    continue;
                }
                IO.copyFile(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
            }
        }
    }

    public static byte[] readFileToByteArray(String filename) throws IOException {
        try (FileInputStream fin = new FileInputStream(filename);){
            BufferedInputStream in = new BufferedInputStream(fin);
            byte[] byArray = IO.readContentsToByteArray(in);
            return byArray;
        }
    }

    public static String readFile(String filename) throws IOException {
        try (FileInputStream fin = new FileInputStream(filename);){
            InputStreamReader reader = new InputStreamReader((InputStream)fin, StandardCharsets.UTF_8);
            StringWriter swriter = new StringWriter(50000);
            UnsynchronizedBufferedWriter writer = new UnsynchronizedBufferedWriter(swriter);
            writer.write(reader);
            String string = swriter.toString();
            return string;
        }
    }

    public static void writeToFile(String contents, File file) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(file);){
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fout, StandardCharsets.UTF_8);
            UnsynchronizedBufferedWriter writer = new UnsynchronizedBufferedWriter(fw);
            writer.write(contents);
            writer.flush();
        }
    }

    public static void writeToFile(byte[] contents, File file) throws IOException {
        try (FileOutputStream fw = new FileOutputStream(file);){
            fw.write(contents);
            fw.flush();
        }
    }

    public static void writeToFile(String contents, String fileOutName) throws IOException {
        IO.writeToFile(contents, new File(fileOutName));
    }

    /*
     * Loose catch block
     */
    public static long writeToFile(InputStream in, String fileOutName) throws IOException {
        try {
            try (FileOutputStream fout = new FileOutputStream(fileOutName);){
                BufferedOutputStream out = new BufferedOutputStream(fout);
                long l = IO.copy(in, out);
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }

    public static long appendToFile(InputStream in, String fileOutName) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(fileOutName);){
            BufferedOutputStream out = new BufferedOutputStream(fout);
            long l = IO.copy(in, out);
            return l;
        }
    }

    public static long copyUrlB(String urlString, OutputStream out, int bufferSize) throws IOException {
        long count;
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            int responseCode;
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConnection = null;
            if (connection instanceof HttpURLConnection) {
                httpConnection = (HttpURLConnection)connection;
                httpConnection.addRequestProperty("Accept-Encoding", "gzip");
            }
            if (httpConnection != null && (responseCode = httpConnection.getResponseCode()) / 100 != 2) {
                throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
            }
            try (InputStream is = connection.getInputStream();){
                BufferedInputStream bis = "gzip".equalsIgnoreCase(connection.getContentEncoding()) ? new BufferedInputStream(new GZIPInputStream(is), 8000) : new BufferedInputStream(is, 8000);
                count = out == null ? IO.copy2null(bis, bufferSize) : IO.copyB(bis, out, bufferSize);
            }
        }
        catch (ConnectException e) {
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (UnknownHostException e) {
            throw new IOException("** UnknownHostException on URL: <" + urlString + ">\n");
        }
        catch (Exception e) {
            throw new IOException("** Exception on URL: <" + urlString + ">\n" + e);
        }
        return count;
    }

    private static void showRequestHeaders(String urlString, URLConnection connection) {
        System.out.println("\nREQUEST Properties for " + urlString + ": ");
        Map<String, List<String>> reqs = connection.getRequestProperties();
        for (Map.Entry<String, List<String>> entry : reqs.entrySet()) {
            System.out.printf(" %s:", entry.getKey());
            for (String v : entry.getValue()) {
                System.out.printf("%s,", v);
            }
            System.out.printf("%n", new Object[0]);
        }
    }

    public static InputStream getInputStreamFromUrl(String urlString) throws IOException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            InputStream is;
            block11: {
                int responseCode;
                URLConnection connection = url.openConnection();
                HttpURLConnection httpConnection = null;
                if (connection instanceof HttpURLConnection) {
                    httpConnection = (HttpURLConnection)connection;
                    httpConnection.addRequestProperty("Accept-Encoding", "gzip");
                }
                if (httpConnection != null && (responseCode = httpConnection.getResponseCode()) / 100 != 2) {
                    throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
                }
                is = null;
                try {
                    is = connection.getInputStream();
                    if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
                        is = new BufferedInputStream(new GZIPInputStream(is), 1000);
                    }
                }
                catch (Throwable t) {
                    if (is == null) break block11;
                    is.close();
                }
            }
            return is;
        }
        catch (ConnectException e) {
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (UnknownHostException e) {
            throw new IOException("** UnknownHostException on URL: <" + urlString + ">\n");
        }
        catch (Exception e) {
            throw new IOException("** Exception on URL: <" + urlString + ">\n" + e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readURLtoFile(String urlString, File file) {
        try (FileOutputStream fout = new FileOutputStream(file);){
            BufferedOutputStream out = new BufferedOutputStream(fout);
            IO.copyUrlB(urlString, out, 20000);
            String string = "ok";
            return string;
        }
        catch (FileNotFoundException e) {
            return "** IOException opening file: <" + file.getPath() + ">\n" + e.getMessage() + "\n";
        }
        catch (IOException e) {
            return "** IOException reading URL: <" + urlString + ">\n" + e.getMessage() + "\n";
        }
    }

    public static byte[] readURLContentsToByteArray(String urlString) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
        IO.copyUrlB(urlString, bout, 200000);
        return bout.toByteArray();
    }

    public static String readURLtoFileWithExceptions(String urlString, File file) throws IOException {
        return IO.readURLtoFileWithExceptions(urlString, file, 64000);
    }

    public static String readURLtoFileWithExceptions(String urlString, File file, int buffer_size) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(file);){
            BufferedOutputStream out = new BufferedOutputStream(fout);
            IO.copyUrlB(urlString, out, buffer_size);
            String string = "ok";
            return string;
        }
    }

    public static String readURLcontentsWithException(String urlString) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(20000);
        IO.copyUrlB(urlString, bout, 20000);
        return bout.toString("UTF-8");
    }

    public static String readURLcontents(String urlString) {
        try {
            return IO.readURLcontentsWithException(urlString);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static HttpResult putToURL(String urlString, String contents) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return new HttpResult(-1, "** MalformedURLException on URL (" + urlString + ")\n" + e.getMessage());
        }
        try {
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setDoOutput(true);
            c.setRequestMethod("PUT");
            try (OutputStream out = c.getOutputStream();){
                BufferedOutputStream bout = new BufferedOutputStream(out);
                IO.copy(new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8)), bout);
            }
            int code = c.getResponseCode();
            String mess = c.getResponseMessage();
            return new HttpResult(code, mess);
        }
        catch (ConnectException e) {
            return new HttpResult(-2, "** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (IOException e) {
            return new HttpResult(-3, "** IOException on URL: (" + urlString + ")\n" + e.getMessage());
        }
    }

    public static class HttpResult {
        public int statusCode;
        public String message;

        HttpResult(int code, String message) {
            this.statusCode = code;
            this.message = message;
        }
    }
}

