/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordinatesHelper;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.Parameter;

public class CoordSystemBuilder {
    protected static Logger log = LoggerFactory.getLogger(CoordSystemBuilder.class);
    private static boolean useMaximalCoordSys = true;
    private static final String CONVENTION_NAME = "_Coordinates";
    protected NetcdfDataset.Builder<?> datasetBuilder;
    protected Group.Builder rootGroup;
    protected CoordinatesHelper.Builder coords;
    protected List<VarProcess> varList = new ArrayList<VarProcess>();
    protected Multimap<String, VarProcess> coordVarsForDimension = ArrayListMultimap.create();
    protected String conventionName = "_Coordinates";
    protected Formatter parseInfo = new Formatter();
    protected Formatter userAdvice = new Formatter();
    protected boolean debug;

    public static boolean isCoordinateVariable(Variable.Builder<?> vb) {
        String firstd;
        if (vb.dataType == DataType.STRUCTURE || vb.parentStruct != null) {
            return false;
        }
        int rank = vb.getRank();
        if (rank == 1 && vb.shortName.equals(firstd = vb.getFirstDimensionName())) {
            return true;
        }
        if (rank == 2) {
            firstd = vb.getFirstDimensionName();
            return vb.shortName.equals(firstd) && vb.dataType == DataType.CHAR;
        }
        return false;
    }

    public static int countDomainSize(Group.Builder gb, Variable.Builder<?> ... axes) {
        HashSet<Dimension> domain = new HashSet<Dimension>();
        for (Variable.Builder<?> axis : axes) {
            domain.addAll((Collection<Dimension>)axis.getDimensions(gb));
        }
        return domain.size();
    }

    protected boolean isCoordinateAxisForVariable(CoordinateAxis.Builder<?> axis, VarProcess vp) {
        ImmutableList<Dimension> varDims = vp.vb.getDimensions(vp.gb);
        ImmutableList<Dimension> axisDims = axis.getDimensions(this.rootGroup);
        int checkDims = axisDims.size();
        if (axis.dataType == DataType.CHAR) {
            --checkDims;
        }
        for (int i = 0; i < checkDims; ++i) {
            Dimension axisDim = (Dimension)axisDims.get(i);
            if (varDims.contains((Object)axisDim)) continue;
            return false;
        }
        return true;
    }

    protected CoordSystemBuilder(NetcdfDataset.Builder<?> datasetBuilder) {
        this.datasetBuilder = datasetBuilder;
        this.rootGroup = datasetBuilder.rootGroup;
        this.coords = datasetBuilder.coords;
    }

    protected void setConventionUsed(String convName) {
        this.conventionName = convName;
    }

    public String getConventionUsed() {
        return this.conventionName;
    }

    protected void addUserAdvice(String advice) {
        this.userAdvice.format("%s", advice);
    }

    public String getParseInfo() {
        return this.parseInfo.toString();
    }

    public String getUserAdvice() {
        return this.userAdvice.toString();
    }

    protected void augmentDataset(CancelTask cancelTask) throws IOException {
    }

    protected void buildCoordinateSystems() {
        this.parseInfo.format("Parsing with Convention = %s%n", this.conventionName);
        this.addVariables(this.datasetBuilder.rootGroup);
        this.identifyCoordinateAxes();
        this.identifyCoordinateSystems();
        this.identifyCoordinateTransforms();
        this.makeCoordinateAxes();
        this.makeCoordinateSystems();
        this.assignCoordinateSystemsExplicit();
        this.makeCoordinateSystemsImplicit();
        if (useMaximalCoordSys) {
            this.makeCoordinateSystemsMaximal();
        }
        this.makeCoordinateTransforms();
        this.assignCoordinateTransforms();
    }

    private void addVariables(Group.Builder group) {
        for (Variable.Builder<?> v : group.vbuilders) {
            if (!(v instanceof VariableDS.Builder)) continue;
            this.varList.add(new VarProcess(group, (VariableDS.Builder)v));
        }
        for (Group.Builder nested : group.gbuilders) {
            this.addVariables(nested);
        }
    }

    protected void identifyCoordinateAxes() {
        for (VarProcess vp : this.varList) {
            if (vp.coordinateAxes != null) {
                this.identifyCoordinateAxes(vp, vp.coordinateAxes);
            }
            if (vp.coordinates == null) continue;
            this.identifyCoordinateAxes(vp, vp.coordinates);
        }
    }

    private void identifyCoordinateAxes(VarProcess vp, String coordinates) {
        StringTokenizer stoker = new StringTokenizer(coordinates);
        while (stoker.hasMoreTokens()) {
            String vname = stoker.nextToken();
            VarProcess ap = this.findVarProcess(vname, vp);
            if (ap == null) {
                Group g = vp.vb.parent;
                Variable v = g.findVariableOrInParent(vname);
                if (v != null) {
                    ap = this.findVarProcess(v.getFullName(), vp);
                } else {
                    this.parseInfo.format("***Cant find coordAxis %s referenced from var= %s%n", vname, vp);
                    this.userAdvice.format("***Cant find coordAxis %s referenced from var= %s%n", vname, vp);
                }
            }
            if (ap != null) {
                if (!ap.isCoordinateAxis) {
                    this.parseInfo.format(" CoordinateAxis = %s added; referenced from var= %s%n", vname, vp);
                }
                ap.isCoordinateAxis = true;
                continue;
            }
            this.parseInfo.format("***Cant find coordAxis %s referenced from var= %s%n", vname, vp);
            this.userAdvice.format("***Cant find coordAxis %s referenced from var= %s%n", vname, vp);
        }
    }

    protected void identifyCoordinateSystems() {
        for (VarProcess vp : this.varList) {
            if (vp.coordinateSystems == null) continue;
            StringTokenizer stoker = new StringTokenizer(vp.coordinateSystems);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname, vp);
                if (ap != null) {
                    if (!ap.isCoordinateSystem) {
                        this.parseInfo.format(" CoordinateSystem = %s added; referenced from var= %s%n", vname, vp);
                    }
                    ap.isCoordinateSystem = true;
                    continue;
                }
                this.parseInfo.format("***Cant find coordSystem %s referenced from var= %s%n", vname, vp);
                this.userAdvice.format("***Cant find coordSystem %s referenced from var= %s%n", vname, vp);
            }
        }
    }

    protected void identifyCoordinateTransforms() {
        for (VarProcess vp : this.varList) {
            if (vp.coordinateTransforms == null) continue;
            StringTokenizer stoker = new StringTokenizer(vp.coordinateTransforms);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname, vp);
                if (ap != null) {
                    if (!ap.isCoordinateTransform) {
                        this.parseInfo.format(" CoordinateTransform = %s added; referenced from var= %s%n", vname, vp);
                    }
                    ap.isCoordinateTransform = true;
                    continue;
                }
                this.parseInfo.format("***Cant find CoordinateTransform %s referenced from var= %s%n", vname, vp);
                this.userAdvice.format("***Cant find CoordinateTransform %s referenced from var= %s%n", vname, vp);
            }
        }
    }

    @Nullable
    protected AxisType getAxisType(VariableDS.Builder vb) {
        return null;
    }

    protected void makeCoordinateAxes() {
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateAxis && !vp.isCoordinateVariable) continue;
            if (vp.axisType == null) {
                vp.axisType = this.getAxisType(vp.vb);
            }
            if (vp.axisType == null) {
                this.userAdvice.format("Coordinate Axis %s does not have an assigned AxisType%n", vp);
            }
            vp.makeIntoCoordinateAxis();
        }
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateSystem) continue;
            vp.makeCoordinatesFromCoordinateSystem();
        }
    }

    protected void makeCoordinateSystems() {
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateSystem) continue;
            vp.makeCoordinateSystem();
        }
    }

    protected void assignCoordinateSystemsExplicit() {
        for (VarProcess vp : this.varList) {
            if (vp.coordinateSystems == null || vp.isCoordinateTransform) continue;
            StringTokenizer stoker = new StringTokenizer(vp.coordinateSystems);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname, vp);
                if (ap == null) {
                    this.parseInfo.format("***Cant find Coordinate System variable %s referenced from var= %s%n", vname, vp);
                    this.userAdvice.format("***Cant find Coordinate System variable %s referenced from var= %s%n", vname, vp);
                    continue;
                }
                if (ap.cs == null) {
                    this.parseInfo.format("***Not a Coordinate System variable %s referenced from var= %s%n", vname, vp);
                    this.userAdvice.format("***Not a Coordinate System variable %s referenced from var= %s%n", vname, vp);
                    continue;
                }
                String sysName = this.coords.makeCanonicalName(ap.cs.coordAxesNames);
                vp.vb.addCoordinateSystem(sysName);
            }
        }
        for (VarProcess csVar : this.varList) {
            if (!csVar.isCoordinateSystem || csVar.coordinateSystemsFor == null) continue;
            HashSet<String> dimList = new HashSet<String>();
            StringTokenizer stoker = new StringTokenizer(csVar.coordinateSystemsFor);
            while (stoker.hasMoreTokens()) {
                String dname = stoker.nextToken();
                Optional<Dimension> dimOpt = this.rootGroup.findDimension(dname);
                if (dimOpt.isPresent()) {
                    dimList.add(dimOpt.get().getShortName());
                    continue;
                }
                this.parseInfo.format("***Cant find Dimension %s referenced from CoordSys var= %s%n", dname, csVar);
                this.userAdvice.format("***Cant find Dimension %s referenced from CoordSys var= %s%n", dname, csVar);
            }
            for (VarProcess vp : this.varList) {
                if (vp.hasCoordinateSystem() || !vp.isData() || csVar.cs == null || !CoordinateSystem.isSubset(dimList, vp.vb.getDimensionsAll()) || !CoordinateSystem.isSubset(vp.vb.getDimensionsAll(), dimList)) continue;
                vp.vb.addCoordinateSystem(csVar.cs.coordAxesNames);
            }
        }
        for (VarProcess vp : this.varList) {
            if (vp.hasCoordinateSystem() || vp.coordinateAxes == null || !vp.isData()) continue;
            String coordSysName = this.coords.makeCanonicalName(vp.coordinateAxes);
            Optional<CoordinateSystem.Builder> cso = this.coords.findCoordinateSystem(coordSysName);
            if (cso.isPresent()) {
                vp.vb.addCoordinateSystem(coordSysName);
                this.parseInfo.format(" assigned explicit CoordSystem '%s' for var= %s%n", coordSysName, vp);
                continue;
            }
            Object csnew = CoordinateSystem.builder().setCoordAxesNames(coordSysName);
            this.coords.addCoordinateSystem((CoordinateSystem.Builder)csnew);
            vp.vb.addCoordinateSystem(coordSysName);
            this.parseInfo.format(" created explicit CoordSystem '%s' for var= %s%n", coordSysName, vp);
        }
    }

    protected void makeCoordinateSystemsImplicit() {
        for (VarProcess vp : this.varList) {
            List<CoordinateAxis.Builder> dataAxesList;
            if (vp.hasCoordinateSystem() || !vp.maybeData() || (dataAxesList = vp.findCoordinateAxes(true)).size() < 2) continue;
            String csName = this.coords.makeCanonicalName(dataAxesList);
            Optional<CoordinateSystem.Builder> csOpt = this.coords.findCoordinateSystem(csName);
            if (csOpt.isPresent() && this.coords.isComplete(csOpt.get(), vp.vb)) {
                vp.vb.addCoordinateSystem(csName);
                this.parseInfo.format(" assigned implicit CoordSystem '%s' for var= %s%n", csName, vp);
                continue;
            }
            Object csnew = ((CoordinateSystem.Builder)CoordinateSystem.builder().setCoordAxesNames(csName)).setImplicit(true);
            if (!this.coords.isComplete((CoordinateSystem.Builder<?>)csnew, vp.vb)) continue;
            vp.vb.addCoordinateSystem(csName);
            this.coords.addCoordinateSystem((CoordinateSystem.Builder)csnew);
            this.parseInfo.format(" created implicit CoordSystem '%s' for var= %s%n", csName, vp);
        }
    }

    private void makeCoordinateSystemsMaximal() {
        boolean requireCompleteCoordSys = !this.datasetBuilder.enhanceMode.contains((Object)NetcdfDataset.Enhance.IncompleteCoordSystems);
        for (VarProcess vp : this.varList) {
            if (vp.hasCoordinateSystem() || !vp.isData()) continue;
            ArrayList<CoordinateAxis.Builder> axisList = new ArrayList<CoordinateAxis.Builder>();
            for (CoordinateAxis.Builder axis : this.coords.coordAxes) {
                if (!this.isCoordinateAxisForVariable(axis, vp)) continue;
                axisList.add(axis);
            }
            if (axisList.size() < 2) continue;
            String csName = this.coords.makeCanonicalName(axisList);
            Optional<CoordinateSystem.Builder> csOpt = this.coords.findCoordinateSystem(csName);
            boolean okToBuild = false;
            if (requireCompleteCoordSys) {
                if (csOpt.isPresent()) {
                    okToBuild = this.coords.isComplete(csOpt.get(), vp.vb);
                }
            } else {
                okToBuild = true;
            }
            if (csOpt.isPresent() && okToBuild) {
                vp.vb.addCoordinateSystem(csName);
                this.parseInfo.format(" assigned maximal CoordSystem '%s' for var= %s%n", csName, vp);
                continue;
            }
            Object csnew = CoordinateSystem.builder().setCoordAxesNames(csName);
            if (requireCompleteCoordSys) {
                okToBuild = this.coords.isComplete((CoordinateSystem.Builder<?>)csnew, vp.vb);
            }
            if (!okToBuild) continue;
            ((CoordinateSystem.Builder)csnew).setImplicit(true);
            vp.vb.addCoordinateSystem(csName);
            this.coords.addCoordinateSystem((CoordinateSystem.Builder)csnew);
            this.parseInfo.format(" created maximal CoordSystem '%s' for var= %s%n", ((CoordinateSystem.Builder)csnew).coordAxesNames, vp);
        }
    }

    protected void makeCoordinateTransforms() {
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateTransform || vp.ct != null) continue;
            vp.ct = this.makeCoordinateTransform(vp.vb);
            if (vp.ct == null) continue;
            this.coords.addCoordinateTransform(vp.ct);
        }
    }

    protected CoordinateTransform.Builder makeCoordinateTransform(VariableDS.Builder<?> vb) {
        return ((CoordinateTransform.Builder)CoordinateTransform.builder().setName(vb.shortName)).setAttributeContainer(vb.getAttributeContainer());
    }

    protected void assignCoordinateTransforms() {
        Object vname;
        StringTokenizer stoker;
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateSystem || vp.coordinateTransforms == null) continue;
            stoker = new StringTokenizer(vp.coordinateTransforms);
            while (stoker.hasMoreTokens()) {
                vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess((String)vname, vp);
                if (ap != null) {
                    if (ap.ct != null) {
                        vp.addCoordinateTransform(ap.ct);
                        this.parseInfo.format(" assign explicit coordTransform %s to CoordSys= %s%n", ap.ct, vp.cs);
                        continue;
                    }
                    this.parseInfo.format("***Cant find coordTransform in %s referenced from var= %s%n", vname, vp.vb.getFullName());
                    this.userAdvice.format("***Cant find coordTransform in %s referenced from var= %s%n", vname, vp.vb.getFullName());
                    continue;
                }
                this.parseInfo.format("***Cant find coordTransform variable= %s referenced from var= %s%n", vname, vp.vb.getFullName());
                this.userAdvice.format("***Cant find coordTransform variable= %s referenced from var= %s%n", vname, vp.vb.getFullName());
            }
        }
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateTransform || vp.ct == null || vp.coordinateSystems == null) continue;
            stoker = new StringTokenizer(vp.coordinateSystems);
            while (stoker.hasMoreTokens()) {
                vname = stoker.nextToken();
                VarProcess vcs = this.findVarProcess((String)vname, vp);
                if (vcs == null) {
                    this.parseInfo.format("***Cant find coordSystem variable= %s referenced from var= %s%n", vname, vp.vb.getFullName());
                    this.userAdvice.format("***Cant find coordSystem variable= %s referenced from var= %s%n", vname, vp.vb.getFullName());
                    continue;
                }
                vcs.addCoordinateTransform(vp.ct);
                this.parseInfo.format("***assign explicit coordTransform %s to CoordSys=  %s%n", vp.ct, vp.cs);
            }
        }
        for (VarProcess vp : this.varList) {
            List<CoordinateAxis.Builder> dataAxesList;
            if (!vp.isCoordinateTransform || vp.ct == null || vp.coordinateAxes == null || (dataAxesList = vp.findCoordinateAxes(false)).isEmpty()) continue;
            for (CoordinateSystem.Builder cs : this.coords.coordSys) {
                if (!this.coords.containsAxes(cs, dataAxesList)) continue;
                this.coords.addCoordinateTransform(vp.ct);
                cs.addCoordinateTransformByName(vp.ct.name);
                this.parseInfo.format("***assign (implicit coordAxes) coordTransform %s to CoordSys=  %s%n", vp.ct, cs);
            }
        }
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateTransform || vp.ct == null || vp.coordAxisTypes == null) continue;
            ArrayList<AxisType> axisTypesList = new ArrayList<AxisType>();
            StringTokenizer stoker2 = new StringTokenizer(vp.coordAxisTypes);
            while (stoker2.hasMoreTokens()) {
                String name = stoker2.nextToken();
                AxisType atype = AxisType.getType(name);
                if (null == atype) continue;
                axisTypesList.add(atype);
            }
            if (axisTypesList.isEmpty()) continue;
            for (CoordinateSystem.Builder cs : this.coords.coordSys) {
                if (!this.coords.containsAxisTypes(cs, axisTypesList)) continue;
                cs.addCoordinateTransformByName(vp.ct.name);
                this.parseInfo.format("***assign (implicit coordAxisType) coordTransform %s to CoordSys=  %s%n", vp.ct, cs);
            }
        }
    }

    protected VarProcess findVarProcess(String name, VarProcess from) {
        if (name == null) {
            return null;
        }
        for (VarProcess vp : this.varList) {
            if (!name.equals(vp.vb.getFullName())) continue;
            return vp;
        }
        if (from != null) {
            for (VarProcess vp : this.varList) {
                if (!name.equals(vp.vb.shortName) || !vp.vb.parent.equals(from.vb.parent)) continue;
                return vp;
            }
        }
        for (VarProcess vp : this.varList) {
            if (!name.equals(vp.vb.shortName)) continue;
            return vp;
        }
        return null;
    }

    protected VarProcess findCoordinateAxis(String name) {
        if (name == null) {
            return null;
        }
        for (VarProcess vp : this.varList) {
            if (!name.equals(vp.vb.getFullName()) || !vp.isCoordinateVariable && !vp.isCoordinateAxis) continue;
            return vp;
        }
        return null;
    }

    protected VariableDS.Builder makeCoordinateTransformVariable(CoordinateTransform ct) {
        VariableDS.Builder v = (VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(ct.getName())).setDataType(DataType.CHAR);
        List<Parameter> params = ct.getParameters();
        for (Parameter p : params) {
            if (p.isString()) {
                v.addAttribute(new Attribute(p.getName(), p.getStringValue()));
                continue;
            }
            double[] data = p.getNumericValues();
            Array dataA = Array.factory(DataType.DOUBLE, new int[]{data.length}, (Object)data);
            v.addAttribute(new Attribute(p.getName(), dataA));
        }
        v.addAttribute(new Attribute("_CoordinateTransformType", ct.getTransformType().toString()));
        Array data = Array.factory(DataType.CHAR, new int[0], (Object)new char[]{' '});
        v.setCachedData(data, true);
        this.parseInfo.format("  made CoordinateTransformVariable: %s%n", ct.getName());
        return v;
    }

    protected class VarProcess {
        public Group.Builder gb;
        public VariableDS.Builder<?> vb;
        public String coordVarAlias;
        public String positive;
        public String coordinateAxes;
        public String coordinateSystems;
        public String coordinateSystemsFor;
        public String coordinateTransforms;
        public String coordAxisTypes;
        public String coordTransformType;
        public String coordinates;
        public boolean isCoordinateVariable;
        public boolean isCoordinateAxis;
        public AxisType axisType;
        public CoordinateAxis.Builder axis;
        public boolean isCoordinateSystem;
        public CoordinateSystem.Builder cs;
        public boolean isCoordinateTransform;
        public CoordinateTransform.Builder ct;

        private VarProcess(Group.Builder gb, VariableDS.Builder<?> v) {
            Attribute att;
            this.gb = gb;
            this.vb = v;
            boolean bl = this.isCoordinateVariable = CoordSystemBuilder.isCoordinateVariable(v) || null != v.getAttributeContainer().findAttribute("_CoordinateAliasForDimension");
            if (this.isCoordinateVariable) {
                CoordSystemBuilder.this.coordVarsForDimension.put((Object)v.getFirstDimensionName(), (Object)this);
            }
            if ((att = v.getAttributeContainer().findAttributeIgnoreCase("_CoordinateAxisType")) != null) {
                String axisName = att.getStringValue();
                this.axisType = AxisType.getType(axisName);
                this.isCoordinateAxis = true;
                CoordSystemBuilder.this.parseInfo.format(" Coordinate Axis added = %s type= %s%n", v.getFullName(), axisName);
            }
            this.coordVarAlias = v.getAttributeContainer().findAttValueIgnoreCase("_CoordinateAliasForDimension", null);
            if (this.coordVarAlias != null) {
                this.coordVarAlias = this.coordVarAlias.trim();
                if (v.getRank() != 1) {
                    CoordSystemBuilder.this.parseInfo.format("**ERROR Coordinate Variable Alias %s has rank %d%n", v.getFullName(), v.getRank());
                    CoordSystemBuilder.this.userAdvice.format("**ERROR Coordinate Variable Alias %s has rank %d%n", v.getFullName(), v.getRank());
                } else {
                    Optional<Dimension> coordDimOpt = gb.findDimension(this.coordVarAlias);
                    coordDimOpt.ifPresent(coordDim -> {
                        String vDim = v.getFirstDimensionName();
                        if (!coordDim.getShortName().equals(vDim)) {
                            CoordSystemBuilder.this.parseInfo.format("**ERROR Coordinate Variable Alias %s names wrong dimension %s%n", v.getFullName(), this.coordVarAlias);
                            CoordSystemBuilder.this.userAdvice.format("**ERROR Coordinate Variable Alias %s names wrong dimension %s%n", v.getFullName(), this.coordVarAlias);
                        } else {
                            this.isCoordinateAxis = true;
                            CoordSystemBuilder.this.coordVarsForDimension.put((Object)coordDim.getShortName(), (Object)this);
                            CoordSystemBuilder.this.parseInfo.format(" Coordinate Variable Alias added = %s for dimension= %s%n", v.getFullName(), this.coordVarAlias);
                        }
                    });
                }
            }
            this.positive = v.getAttributeContainer().findAttValueIgnoreCase("_CoordinateZisPositive", null);
            if (this.positive == null) {
                this.positive = v.getAttributeContainer().findAttValueIgnoreCase("positive", null);
            } else {
                this.isCoordinateAxis = true;
                this.positive = this.positive.trim();
                CoordSystemBuilder.this.parseInfo.format(" Coordinate Axis added(from positive attribute ) = %s for dimension= %s%n", v.getFullName(), this.coordVarAlias);
            }
            this.coordinateAxes = v.getAttributeContainer().findAttValueIgnoreCase("_CoordinateAxes", null);
            this.coordinateSystems = v.getAttributeContainer().findAttValueIgnoreCase("_CoordinateSystems", null);
            this.coordinateSystemsFor = v.getAttributeContainer().findAttValueIgnoreCase("_CoordinateSystemFor", null);
            this.coordinateTransforms = v.getAttributeContainer().findAttValueIgnoreCase("_CoordinateTransforms", null);
            this.isCoordinateSystem = this.coordinateTransforms != null || this.coordinateSystemsFor != null;
            this.coordAxisTypes = v.getAttributeContainer().findAttValueIgnoreCase("_CoordinateAxisTypes", null);
            this.coordTransformType = v.getAttributeContainer().findAttValueIgnoreCase("_CoordinateTransformType", null);
            this.isCoordinateTransform = this.coordTransformType != null || this.coordAxisTypes != null;
        }

        protected boolean isData() {
            return !this.isCoordinateVariable && !this.isCoordinateAxis && !this.isCoordinateSystem && !this.isCoordinateTransform;
        }

        protected boolean maybeData() {
            return !this.isCoordinateVariable && !this.isCoordinateSystem && !this.isCoordinateTransform;
        }

        protected boolean hasCoordinateSystem() {
            return !this.vb.coordSysNames.isEmpty();
        }

        public String toString() {
            return this.vb.shortName;
        }

        protected CoordinateAxis.Builder makeIntoCoordinateAxis() {
            if (this.axis != null) {
                return this.axis;
            }
            if (this.vb instanceof CoordinateAxis.Builder) {
                this.axis = (CoordinateAxis.Builder)this.vb;
            } else {
                this.vb = this.axis = CoordinateAxis.fromVariableDS(this.vb);
            }
            if (this.axisType != null) {
                this.axis.setAxisType(this.axisType);
                this.axis.addAttribute(new Attribute("_CoordinateAxisType", this.axisType.toString()));
                if ((this.axisType == AxisType.Height || this.axisType == AxisType.Pressure || this.axisType == AxisType.GeoZ) && this.positive != null) {
                    this.axis.setPositive(this.positive);
                    this.axis.addAttribute(new Attribute("_CoordinateZisPositive", this.positive));
                }
            }
            CoordSystemBuilder.this.coords.replaceCoordinateAxis(this.axis);
            this.gb.replaceVariable(this.axis);
            return this.axis;
        }

        protected void makeCoordinatesFromCoordinateSystem() {
            if (this.coordinateAxes != null) {
                StringTokenizer stoker = new StringTokenizer(this.coordinateAxes);
                while (stoker.hasMoreTokens()) {
                    String vname = stoker.nextToken();
                    VarProcess ap = CoordSystemBuilder.this.findVarProcess(vname, this);
                    if (ap != null) {
                        ap.makeIntoCoordinateAxis();
                        continue;
                    }
                    CoordSystemBuilder.this.parseInfo.format(" Cant find axes %s for Coordinate System %s%n", vname, this.vb);
                    CoordSystemBuilder.this.userAdvice.format(" Cant find axes %s for Coordinate System %s%n", vname, this.vb);
                }
            }
        }

        protected void makeCoordinateSystem() {
            if (this.coordinateAxes != null) {
                String sysName = CoordSystemBuilder.this.coords.makeCanonicalName(this.coordinateAxes);
                this.cs = CoordinateSystem.builder().setCoordAxesNames(sysName);
                CoordSystemBuilder.this.parseInfo.format(" Made Coordinate System '%s'", sysName);
                CoordSystemBuilder.this.coords.addCoordinateSystem(this.cs);
            }
        }

        protected List<CoordinateAxis.Builder> findCoordinateAxes(boolean addCoordVariables) {
            CoordinateAxis.Builder axis;
            VarProcess ap;
            String vname;
            StringTokenizer stoker;
            ArrayList<CoordinateAxis.Builder> axesList = new ArrayList<CoordinateAxis.Builder>();
            if (this.coordinateAxes != null) {
                stoker = new StringTokenizer(this.coordinateAxes);
                while (stoker.hasMoreTokens()) {
                    vname = stoker.nextToken();
                    ap = CoordSystemBuilder.this.findVarProcess(vname, this);
                    if (ap == null || axesList.contains(axis = ap.makeIntoCoordinateAxis())) continue;
                    axesList.add(axis);
                }
            } else if (this.coordinates != null) {
                stoker = new StringTokenizer(this.coordinates);
                while (stoker.hasMoreTokens()) {
                    vname = stoker.nextToken();
                    ap = CoordSystemBuilder.this.findVarProcess(vname, this);
                    if (ap == null || axesList.contains(axis = ap.makeIntoCoordinateAxis())) continue;
                    axesList.add(axis);
                }
            }
            if (addCoordVariables) {
                for (String d : this.vb.getDimensionNames()) {
                    for (VarProcess vp : CoordSystemBuilder.this.coordVarsForDimension.get((Object)d)) {
                        CoordinateAxis.Builder axis2 = vp.makeIntoCoordinateAxis();
                        if (axesList.contains(axis2)) continue;
                        axesList.add(axis2);
                    }
                }
            }
            return axesList;
        }

        void addCoordinateTransform(CoordinateTransform.Builder ct) {
            if (this.cs == null) {
                CoordSystemBuilder.this.parseInfo.format("  %s: no CoordinateSystem for CoordinateTransformVariable: %s%n", this.vb.getFullName(), ct.name);
                return;
            }
            this.cs.addCoordinateTransformByName(ct.name);
        }
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return CoordSystemBuilder.CONVENTION_NAME;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new CoordSystemBuilder(datasetBuilder);
        }
    }
}

