/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.gis.GridBoundariesExtractor;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.Parameter;

public class GridDatasetInfo {
    private static final Logger logger = LoggerFactory.getLogger(GridDatasetInfo.class);
    private GridDataset gds;
    private String path;

    public GridDatasetInfo(GridDataset gds, String path) {
        this.gds = gds;
        this.path = path;
    }

    public String writeXML(Document doc) {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(doc);
    }

    public void writeXML(Document doc, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, os);
    }

    public Document makeDatasetDescription() {
        Element rootElem = new Element("gridDataset");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", this.gds.getLocation());
        if (null != this.path) {
            rootElem.setAttribute("path", this.path);
        }
        for (CoordinateAxis coordinateAxis : this.getCoordAxes(this.gds)) {
            rootElem.addContent((Content)this.writeAxis(coordinateAxis));
        }
        List<GridDataset.Gridset> gridSets = this.gds.getGridsets();
        gridSets.sort(new GridSetComparator());
        for (GridDataset.Gridset gridset : gridSets) {
            rootElem.addContent((Content)this.writeGridSet(gridset));
        }
        for (CoordinateTransform ct : this.getCoordTransforms(this.gds)) {
            rootElem.addContent((Content)this.writeCoordTransform(ct));
        }
        LatLonRect latLonRect = this.gds.getBoundingBox();
        if (latLonRect != null) {
            rootElem.addContent((Content)this.writeBoundingBox(latLonRect));
        }
        CalendarDate start = this.gds.getCalendarDateStart();
        CalendarDate end = this.gds.getCalendarDateEnd();
        if (start != null && end != null) {
            Element dateRange = new Element("TimeSpan");
            dateRange.addContent((Content)new Element("begin").addContent(start.toString()));
            dateRange.addContent((Content)new Element("end").addContent(end.toString()));
            rootElem.addContent((Content)dateRange);
        }
        this.addAcceptList(rootElem);
        return doc;
    }

    public String getDatasetBoundariesWKT() {
        return GridBoundariesExtractor.valueOf(this.gds).getDatasetBoundariesWKT();
    }

    public Document makeGridForm() {
        Element rootElem = new Element("gridForm");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", this.gds.getLocation());
        if (null != this.path) {
            rootElem.setAttribute("path", this.path);
        }
        List<GridDatatype> grids = this.gds.getGrids();
        grids.sort(new GridComparator());
        CoordinateAxis currentTime = null;
        CoordinateAxis1D currentVert = null;
        Element timeElem = null;
        Element vertElem = null;
        for (int i = 0; i < grids.size(); ++i) {
            boolean newTime;
            CoordinateAxis1D ens;
            GeoGrid grid = (GeoGrid)grids.get(i);
            GridCoordSystem gcs = grid.getCoordinateSystem();
            CoordinateAxis time = gcs.getTimeAxis();
            CoordinateAxis1D vert = gcs.getVerticalAxis();
            if (i == 0 && (ens = gcs.getEnsembleAxis()) != null) {
                Element ensAxisEl = this.writeAxis2(ens, "ensemble");
                rootElem.addContent((Content)ensAxisEl);
            }
            if (i == 0 || !this.compareAxis(time, currentTime)) {
                timeElem = new Element("timeSet");
                rootElem.addContent((Content)timeElem);
                Element timeAxisElement = this.writeAxis2(time, "time");
                if (timeAxisElement != null) {
                    timeElem.addContent((Content)timeAxisElement);
                }
                currentTime = time;
                newTime = true;
            } else {
                newTime = false;
            }
            if (newTime || !this.compareAxis(vert, currentVert)) {
                vertElem = new Element("vertSet");
                timeElem.addContent((Content)vertElem);
                Element vertAxisElement = this.writeAxis2(vert, "vert");
                if (vertAxisElement != null) {
                    vertElem.addContent((Content)vertAxisElement);
                }
                currentVert = vert;
            }
            vertElem.addContent((Content)this.writeGrid(grid));
        }
        LatLonRect bb = this.gds.getBoundingBox();
        if (bb != null) {
            rootElem.addContent((Content)this.writeBoundingBox(bb));
        }
        ProjectionRect rect = grids.get(0).getCoordinateSystem().getBoundingBox();
        Element projBBOX = new Element("projectionBox");
        Element minx = new Element("minx");
        minx.addContent(Double.valueOf(rect.getMinX()).toString());
        projBBOX.addContent((Content)minx);
        Element maxx = new Element("maxx");
        maxx.addContent(Double.valueOf(rect.getMaxX()).toString());
        projBBOX.addContent((Content)maxx);
        Element miny = new Element("miny");
        miny.addContent(Double.valueOf(rect.getMinY()).toString());
        projBBOX.addContent((Content)miny);
        Element maxy = new Element("maxy");
        maxy.addContent(Double.valueOf(rect.getMaxY()).toString());
        projBBOX.addContent((Content)maxy);
        rootElem.addContent((Content)projBBOX);
        CalendarDate start = this.gds.getCalendarDateStart();
        CalendarDate end = this.gds.getCalendarDateEnd();
        if (start != null && end != null) {
            Element dateRange = new Element("TimeSpan");
            dateRange.addContent((Content)new Element("begin").addContent(start.toString()));
            dateRange.addContent((Content)new Element("end").addContent(end.toString()));
            rootElem.addContent((Content)dateRange);
        }
        this.addAcceptList(rootElem);
        return doc;
    }

    private void addAcceptList(Element rootElement) {
        Element elem = new Element("AcceptList");
        Element gridAsPoint = new Element("GridAsPoint");
        gridAsPoint.addContent((Content)new Element("accept").addContent("xml").setAttribute("displayName", "xml"));
        gridAsPoint.addContent((Content)new Element("accept").addContent("xml_file").setAttribute("displayName", "xml (file)"));
        gridAsPoint.addContent((Content)new Element("accept").addContent("csv").setAttribute("displayName", "csv"));
        gridAsPoint.addContent((Content)new Element("accept").addContent("csv_file").setAttribute("displayName", "csv (file)"));
        gridAsPoint.addContent((Content)new Element("accept").addContent("geocsv").setAttribute("displayName", "geocsv"));
        gridAsPoint.addContent((Content)new Element("accept").addContent("geocsv_file").setAttribute("displayName", "geocsv (file)"));
        gridAsPoint.addContent((Content)new Element("accept").addContent("netcdf").setAttribute("displayName", "netcdf"));
        Element grids = new Element("Grid");
        grids.addContent((Content)new Element("accept").addContent("netcdf").setAttribute("displayName", "netcdf"));
        elem.addContent((Content)gridAsPoint);
        elem.addContent((Content)grids);
        rootElement.addContent((Content)elem);
    }

    private Element writeAxis2(CoordinateAxis axis, String name) {
        if (axis == null) {
            return null;
        }
        NcMLWriter ncmlWriter = new NcMLWriter();
        Element varElem = new Element(name);
        varElem.setAttribute("name", axis.getFullName());
        varElem.setAttribute("shape", this.getShapeString(axis.getShape()));
        DataType dt = axis.getDataType();
        varElem.setAttribute("type", dt.toString());
        AxisType axisType = axis.getAxisType();
        if (null != axisType) {
            varElem.setAttribute("axisType", axisType.toString());
        }
        for (Attribute att : axis.attributes()) {
            varElem.addContent((Content)ncmlWriter.makeAttributeElement(att));
        }
        try {
            Element values = ncmlWriter.makeValuesElement(axis, false);
            values.setAttribute("npts", Long.toString(axis.getSize()));
            varElem.addContent((Content)values);
        }
        catch (IOException e) {
            String message = String.format("Couldn't read values for %s. Omitting <values> element.", axis.getFullName());
            logger.warn(message, (Throwable)e);
        }
        return varElem;
    }

    private boolean compareAxis(CoordinateAxis axis1, CoordinateAxis axis2) {
        if (axis1 == axis2) {
            return true;
        }
        if (axis1 == null) {
            return false;
        }
        if (axis2 == null) {
            return false;
        }
        return axis1.equals(axis2);
    }

    private List<CoordinateAxis> getCoordAxes(GridDataset gds) {
        HashSet<CoordinateAxis> axesHash = new HashSet<CoordinateAxis>();
        for (GridDataset.Gridset gridset : gds.getGridsets()) {
            GridCoordSystem gcs = gridset.getGeoCoordSystem();
            axesHash.addAll(gcs.getCoordinateAxes());
        }
        return axesHash.stream().sorted().collect(Collectors.toList());
    }

    private List<CoordinateTransform> getCoordTransforms(GridDataset gds) {
        HashSet<CoordinateTransform> ctHash = new HashSet<CoordinateTransform>();
        for (GridDataset.Gridset gridset : gds.getGridsets()) {
            GridCoordSystem gcs = gridset.getGeoCoordSystem();
            ctHash.addAll(gcs.getCoordinateTransforms());
        }
        return ctHash.stream().sorted().collect(Collectors.toList());
    }

    private Element writeAxis(CoordinateAxis axis) {
        NcMLWriter ncmlWriter = new NcMLWriter();
        Element varElem = new Element("axis");
        varElem.setAttribute("name", axis.getFullName());
        varElem.setAttribute("shape", this.getShapeString(axis.getShape()));
        DataType dt = axis.getDataType();
        varElem.setAttribute("type", dt.toString());
        AxisType axisType = axis.getAxisType();
        if (null != axisType) {
            varElem.setAttribute("axisType", axisType.toString());
        }
        for (Attribute att : axis.attributes()) {
            varElem.addContent((Content)ncmlWriter.makeAttributeElement(att));
        }
        if (axis.getRank() == 1) {
            try {
                Element values = ncmlWriter.makeValuesElement(axis, true);
                varElem.addContent((Content)values);
            }
            catch (IOException e) {
                String message = String.format("Couldn't read values for %s. Omitting <values> element.", axis.getFullName());
                logger.warn(message, (Throwable)e);
            }
        }
        return varElem;
    }

    private String getShapeString(int[] shape) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < shape.length; ++i) {
            if (i != 0) {
                buf.append(" ");
            }
            buf.append(shape[i]);
        }
        return buf.toString();
    }

    private Element writeBoundingBox(LatLonRect bb) {
        Element bbElem = new Element("LatLonBox");
        bbElem.addContent((Content)new Element("west").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMin(), 4)));
        bbElem.addContent((Content)new Element("east").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMax(), 4)));
        bbElem.addContent((Content)new Element("south").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMin(), 4)));
        bbElem.addContent((Content)new Element("north").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMax(), 4)));
        return bbElem;
    }

    private Element writeGridSet(GridDataset.Gridset gridset) {
        Element csElem = new Element("gridSet");
        GridCoordSystem cs = gridset.getGeoCoordSystem();
        csElem.setAttribute("name", cs.getName());
        ProjectionRect rect = cs.getBoundingBox();
        Element projBBOX = new Element("projectionBox");
        Element minx = new Element("minx");
        minx.addContent(Double.valueOf(rect.getMinX()).toString());
        projBBOX.addContent((Content)minx);
        Element maxx = new Element("maxx");
        maxx.addContent(Double.valueOf(rect.getMaxX()).toString());
        projBBOX.addContent((Content)maxx);
        Element miny = new Element("miny");
        miny.addContent(Double.valueOf(rect.getMinY()).toString());
        projBBOX.addContent((Content)miny);
        Element maxy = new Element("maxy");
        maxy.addContent(Double.valueOf(rect.getMaxY()).toString());
        projBBOX.addContent((Content)maxy);
        csElem.addContent((Content)projBBOX);
        for (CoordinateAxis axis : cs.getCoordinateAxes()) {
            Element axisElem = new Element("axisRef");
            axisElem.setAttribute("name", axis.getFullName());
            csElem.addContent((Content)axisElem);
        }
        for (CoordinateTransform ct : cs.getCoordinateTransforms()) {
            Element elem = new Element("coordTransRef");
            elem.setAttribute("name", ct.getName());
            csElem.addContent((Content)elem);
        }
        List<GridDatatype> grids = gridset.getGrids();
        Collections.sort(grids);
        for (GridDatatype grid : grids) {
            csElem.addContent((Content)this.writeGrid(grid));
        }
        return csElem;
    }

    private Element writeCoordTransform(CoordinateTransform ct) {
        Element ctElem = new Element("coordTransform");
        ctElem.setAttribute("name", ct.getName());
        ctElem.setAttribute("transformType", ct.getTransformType().toString());
        for (Parameter param : ct.getParameters()) {
            Element pElem = new Element("parameter");
            pElem.setAttribute("name", param.getName());
            pElem.setAttribute("value", param.getStringValue());
            ctElem.addContent((Content)pElem);
        }
        return ctElem;
    }

    private Element writeGrid(GridDatatype grid) {
        DataType dt;
        NcMLWriter ncmlWriter = new NcMLWriter();
        Element varElem = new Element("grid");
        varElem.setAttribute("name", grid.getFullName());
        String desc = grid.getDescription() != null ? grid.getDescription() : "No description";
        varElem.setAttribute("desc", desc);
        StringBuilder buff = new StringBuilder();
        List<Dimension> dims = grid.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (i > 0) {
                buff.append(" ");
            }
            if (dim.isShared()) {
                buff.append(dim.getShortName());
                continue;
            }
            buff.append(dim.getLength());
        }
        if (buff.length() > 0) {
            varElem.setAttribute("shape", buff.toString());
        }
        if ((dt = grid.getDataType()) != null) {
            varElem.setAttribute("type", dt.toString());
        }
        for (Attribute att : grid.getAttributes()) {
            varElem.addContent((Content)ncmlWriter.makeAttributeElement(att));
        }
        return varElem;
    }

    private static class GridSetComparator
    implements Comparator<GridDataset.Gridset> {
        private GridSetComparator() {
        }

        @Override
        public int compare(GridDataset.Gridset gridset1, GridDataset.Gridset gridset2) {
            GridCoordSystem cs1 = gridset1.getGeoCoordSystem();
            GridCoordSystem cs2 = gridset2.getGeoCoordSystem();
            if (cs1.getDomain().size() != cs2.getDomain().size()) {
                return cs1.getDomain().size() - cs2.getDomain().size();
            }
            return cs1.getName().compareTo(cs2.getName());
        }
    }

    private static class GridComparator
    implements Comparator<GridDatatype> {
        private GridComparator() {
        }

        @Override
        public int compare(GridDatatype grid1, GridDatatype grid2) {
            CoordinateAxis1D vert2;
            CoordinateAxis time2;
            GridCoordSystem gcs1 = grid1.getCoordinateSystem();
            GridCoordSystem gcs2 = grid2.getCoordinateSystem();
            CoordinateAxis time1 = gcs1.getTimeAxis();
            int ret = this.compareAxis(time1, time2 = gcs2.getTimeAxis());
            if (ret != 0) {
                return ret;
            }
            CoordinateAxis1D vert1 = gcs1.getVerticalAxis();
            ret = this.compareAxis(vert1, vert2 = gcs2.getVerticalAxis());
            if (ret != 0) {
                return ret;
            }
            return grid1.getFullName().compareTo(grid2.getFullName());
        }

        private int compareAxis(CoordinateAxis axis1, CoordinateAxis axis2) {
            if (axis1 == axis2) {
                return 0;
            }
            if (axis1 == null) {
                return -1;
            }
            if (axis2 == null) {
                return 1;
            }
            return axis1.getFullName().compareTo(axis2.getFullName());
        }
    }
}

