/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inference.orphan;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.protege.owlapi.inference.orphan.EquivalenceRelation;
import org.protege.owlapi.inference.orphan.Path;
import org.protege.owlapi.inference.orphan.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalElementFinder<X extends Comparable<? super X>> {
    private static Logger log = LoggerFactory.getLogger(TerminalElementFinder.class);
    private Relation<X> r;
    private Set<X> terminalElements = new HashSet<X>();
    private EquivalenceRelation<X> equivalence = new EquivalenceRelation();
    private Set<X> equivalenceAlreadyCalculated = new HashSet<X>();

    public TerminalElementFinder(Relation<X> r) {
        this.r = r;
    }

    public void findTerminalElements(Set<X> candidates) {
        this.clear();
        this.appendTerminalElements(candidates);
        this.finish();
    }

    public void clear() {
        this.terminalElements = new HashSet<X>();
        this.equivalence.clear();
    }

    public void appendTerminalElements(Set<X> candidates) {
        this.equivalenceAlreadyCalculated.clear();
        for (Comparable candidate : candidates) {
            if (log.isDebugEnabled()) {
                log.debug("calling build equivs at " + candidate + " with null path");
            }
            this.buildEquivalenceMapping(candidate, null);
            if (!log.isDebugEnabled()) continue;
            log.debug("Call to build equivs completed at " + candidate);
            this.equivalence.logEquivalences(log);
        }
        this.equivalenceAlreadyCalculated.clear();
    }

    public void finish() {
        this.equivalence.clear();
    }

    public Set<X> getTerminalElements() {
        return Collections.unmodifiableSet(this.terminalElements);
    }

    private void buildEquivalenceMapping(X x, Path<X> p) {
        if (this.equivalenceAlreadyCalculated.contains(x)) {
            return;
        }
        if (p != null && p.contains(x)) {
            this.equivalence.merge(p.getLoop(x));
            if (log.isDebugEnabled()) {
                log.debug("Found loop");
                this.logLoop(p, x);
            }
            return;
        }
        Collection<X> relatedToX = this.r.getR(x);
        if (relatedToX == null || relatedToX.isEmpty()) {
            this.terminalElements.add(x);
            this.equivalenceAlreadyCalculated.add(x);
            return;
        }
        Path<X> newPath = new Path<X>(p, x);
        for (Comparable y : relatedToX) {
            if (log.isDebugEnabled()) {
                log.debug("calling build equivs at " + y + " with path ");
                this.logPath(newPath);
            }
            this.buildEquivalenceMapping(y, newPath);
            if (!log.isDebugEnabled()) continue;
            log.debug("Call to build equivs completed at " + y);
            this.equivalence.logEquivalences(log);
        }
        boolean terminal = true;
        for (Comparable y : relatedToX) {
            if (this.equivalence.equivalent((Comparable)x, y)) continue;
            terminal = false;
            break;
        }
        if (terminal) {
            this.terminalElements.add(x);
        }
        this.equivalenceAlreadyCalculated.add(x);
    }

    public boolean removeTerminalElement(X x) {
        return this.terminalElements.remove(x);
    }

    public void addRelation(X x, X y) {
        if (!this.terminalElements.contains(x)) {
            return;
        }
        HashSet<X> candidates = new HashSet<X>(this.terminalElements);
        candidates.add(y);
        this.findTerminalElements(candidates);
    }

    public void removeRelation(X x, X y) {
        HashSet<X> candidates = new HashSet<X>(this.terminalElements);
        candidates.add(x);
        this.findTerminalElements(candidates);
    }

    private void logPath(Path<X> p) {
        if (log.isDebugEnabled()) {
            log.debug("Path Trace");
            for (Path<X> point = p; point != null; point = point.getNext()) {
                log.debug("Pathelement = " + point.getObject());
            }
        }
    }

    private void logLoop(Path<X> p, X x) {
        if (log.isDebugEnabled()) {
            log.debug("Loop:");
            log.debug("Pathelement = " + x);
            Path<X> point = p;
            while (!((Comparable)point.getObject()).equals(x)) {
                log.debug("Pathelement = " + point.getObject());
                point = point.getNext();
            }
            log.debug("Pathelement = " + x);
        }
    }
}

