/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inference.orphan;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.owlapi.inference.orphan.NamedClassExtractor;
import org.protege.owlapi.inference.orphan.Relation;
import org.protege.owlapi.inference.orphan.TerminalElementFinder;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class ProtegeOrphanFinder {
    private OWLOntologyManager manager;
    private Set<OWLOntology> ontologies;
    private OWLClass root;
    private TerminalElementFinder<OWLClass> rootFinder;
    private ParentClassExtractor parentClassExtractor;

    public ProtegeOrphanFinder(OWLOntologyManager manager, Set<OWLOntology> ontologies) {
        this.manager = manager;
        this.ontologies = ontologies;
        this.root = manager.getOWLDataFactory().getOWLThing();
        this.parentClassExtractor = new ParentClassExtractor();
        this.rootFinder = new TerminalElementFinder<OWLClass>(new Relation<OWLClass>(){

            @Override
            public Collection<OWLClass> getR(OWLClass cls) {
                Set<OWLClass> parents = ProtegeOrphanFinder.this.getParents(cls);
                parents.remove(ProtegeOrphanFinder.this.root);
                return parents;
            }
        });
    }

    public void setOntologies(Set<OWLOntology> ontologies) {
        this.ontologies = ontologies;
    }

    public void initializeListener() {
        this.manager.addOntologyChangeListener(new OWLOntologyChangeListener(){

            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
                for (OWLOntologyChange oWLOntologyChange : changes) {
                    if (oWLOntologyChange.getOntology() == null || !ProtegeOrphanFinder.this.ontologies.contains(oWLOntologyChange.getOntology())) continue;
                    ProtegeOrphanFinder.this.updateImplicitRoots(oWLOntologyChange);
                }
            }
        });
    }

    public Set<OWLClass> getParents(OWLClass object) {
        if (object.equals(this.root)) {
            return Collections.emptySet();
        }
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        if (this.rootFinder.getTerminalElements().contains(object)) {
            result.add(this.root);
        }
        this.parentClassExtractor.reset();
        this.parentClassExtractor.setCurrentClass(object);
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getAxioms(object)) {
                ax.accept((OWLAxiomVisitor)this.parentClassExtractor);
            }
        }
        result.addAll(this.parentClassExtractor.getResult());
        return result;
    }

    public Set<OWLClass> getOrphanedClasses() {
        return this.rootFinder.getTerminalElements();
    }

    public void rebuildImplicitRoots() {
        this.rootFinder.clear();
        for (OWLOntology ont : this.ontologies) {
            Set ref = ont.getClassesInSignature();
            this.rootFinder.appendTerminalElements(ref);
        }
        this.rootFinder.finish();
    }

    public void updateImplicitRoots(OWLOntologyChange change) {
        boolean remove = change instanceof RemoveAxiom;
        OWLAxiom axiom = change.getAxiom();
        HashSet<OWLClass> possibleTerminalElements = new HashSet<OWLClass>();
        HashSet<OWLClass> notInOntologies = new HashSet<OWLClass>();
        for (OWLEntity entity : axiom.getSignature()) {
            if (!(entity instanceof OWLClass) || entity.equals(this.root)) continue;
            OWLClass cls = (OWLClass)entity;
            if (remove && !this.containsReference(cls)) {
                notInOntologies.add(cls);
                continue;
            }
            possibleTerminalElements.add(cls);
        }
        possibleTerminalElements.addAll(this.rootFinder.getTerminalElements());
        possibleTerminalElements.removeAll(notInOntologies);
        this.rootFinder.findTerminalElements(possibleTerminalElements);
    }

    public boolean containsReference(OWLClass object) {
        for (OWLOntology ont : this.ontologies) {
            if (!ont.containsClassInSignature(object.getIRI())) continue;
            return true;
        }
        return false;
    }

    private class ParentClassExtractor
    extends OWLAxiomVisitorAdapter {
        private NamedClassExtractor extractor = new NamedClassExtractor();
        private OWLClass current;

        private ParentClassExtractor() {
        }

        public void setCurrentClass(OWLClass current) {
            this.current = current;
        }

        public void reset() {
            this.extractor.reset();
        }

        public Set<OWLClass> getResult() {
            return this.extractor.getResult();
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            axiom.getSuperClass().accept((OWLClassExpressionVisitor)this.extractor);
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.equals(this.current)) continue;
                desc.accept((OWLClassExpressionVisitor)this.extractor);
            }
        }
    }
}

