/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.fsm.AutomatonMinimizer;
import edu.stanford.nlp.fsm.FastExactAutomatonMinimizer;
import edu.stanford.nlp.fsm.QuasiDeterminizer;
import edu.stanford.nlp.fsm.TransducerGraph;
import edu.stanford.nlp.parser.lexparser.GrammarCompactor;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.List;

public class ExactGrammarCompactor
extends GrammarCompactor {
    private static Redwood.RedwoodChannels log = Redwood.channels(ExactGrammarCompactor.class);
    TransducerGraph.GraphProcessor quasiDeterminizer = new QuasiDeterminizer();
    AutomatonMinimizer minimizer = new FastExactAutomatonMinimizer();
    TransducerGraph.NodeProcessor ntsp = new TransducerGraph.SetToStringNodeProcessor(new PennTreebankLanguagePack());
    TransducerGraph.NodeProcessor otsp = new TransducerGraph.ObjectToSetNodeProcessor();
    TransducerGraph.ArcProcessor isp = new TransducerGraph.InputSplittingProcessor();
    TransducerGraph.ArcProcessor ocp = new TransducerGraph.OutputCombiningProcessor();
    private boolean saveGraphs;

    public ExactGrammarCompactor(Options op, boolean saveGraphs, boolean verbose) {
        super(op);
        this.saveGraphs = saveGraphs;
        this.verbose = verbose;
        this.outputType = NORMALIZED_LOG_PROBABILITIES;
    }

    protected TransducerGraph doCompaction(TransducerGraph graph, List l1, List l3) {
        TransducerGraph result = graph;
        if (this.saveGraphs) {
            ExactGrammarCompactor.writeFile(result, "unminimized", (String)result.getEndNodes().iterator().next());
        }
        result = this.quasiDeterminizer.processGraph(result);
        result = new TransducerGraph(result, this.ocp);
        result = this.minimizer.minimizeFA(result);
        result = new TransducerGraph(result, this.ntsp);
        result = new TransducerGraph(result, this.isp);
        if (this.saveGraphs) {
            ExactGrammarCompactor.writeFile(result, "exactminimized", (String)result.getEndNodes().iterator().next());
        }
        return result;
    }
}

