/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.ArabicUnknownWordSignatures;
import edu.stanford.nlp.parser.lexparser.BaseUnknownWordModel;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.logging.Redwood;

public class ArabicUnknownWordModel
extends BaseUnknownWordModel {
    private static Redwood.RedwoodChannels log = Redwood.channels(ArabicUnknownWordModel.class);
    private static final long serialVersionUID = 4825624957364628771L;
    private static final int MIN_UNKNOWN = 6;
    private static final int MAX_UNKNOWN = 10;
    protected final boolean smartMutation;
    protected final int unknownSuffixSize;
    protected final int unknownPrefixSize;

    public ArabicUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex, ClassicCounter<IntTaggedWord> unSeenCounter) {
        super(op, lex, wordIndex, tagIndex, unSeenCounter, null, null, null);
        if (this.unknownLevel < 6 || this.unknownLevel > 10) {
            throw new IllegalArgumentException("Invalid value for useUnknownWordSignatures: " + this.unknownLevel);
        }
        this.smartMutation = op.lexOptions.smartMutation;
        this.unknownSuffixSize = op.lexOptions.unknownSuffixSize;
        this.unknownPrefixSize = op.lexOptions.unknownPrefixSize;
    }

    public ArabicUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex) {
        this(op, lex, wordIndex, tagIndex, new ClassicCounter<IntTaggedWord>());
    }

    @Override
    public float score(IntTaggedWord iTW, int loc, double c_Tseen, double total, double smooth, String word) {
        int wordSig = this.getSignatureIndex(iTW.word, loc, word);
        IntTaggedWord temp = new IntTaggedWord(wordSig, iTW.tag);
        double c_TS = this.unSeenCounter.getCount(temp);
        temp = new IntTaggedWord(wordSig, -1);
        double c_S = this.unSeenCounter.getCount(temp);
        double c_U = this.unSeenCounter.getCount(NULL_ITW);
        temp = new IntTaggedWord(-1, iTW.tag);
        double c_T = this.unSeenCounter.getCount(temp);
        double p_T_U = c_T / c_U;
        if (this.unknownLevel == 0) {
            c_TS = 0.0;
            c_S = 0.0;
        }
        double pb_T_S = (c_TS + smooth * p_T_U) / (c_S + smooth);
        double p_T = c_Tseen / total;
        double p_W = 1.0 / total;
        double pb_W_T = Math.log(pb_T_S * p_W / p_T);
        return (float)pb_W_T;
    }

    @Override
    public int getSignatureIndex(int index, int sentencePosition, String word) {
        String uwSig = this.getSignature(word, sentencePosition);
        int sig = this.wordIndex.addToIndex(uwSig);
        return sig;
    }

    @Override
    public String getSignature(String word, int loc) {
        StringBuilder sb = new StringBuilder("UNK");
        switch (this.unknownLevel) {
            case 10: {
                boolean allDigitPlus = ArabicUnknownWordSignatures.allDigitPlus(word);
                int leng = word.length();
                if (allDigitPlus) {
                    sb.append("-NUM");
                } else if (word.startsWith("Al") || word.startsWith("\u0627\u0644")) {
                    sb.append("-Al");
                } else if (this.unknownPrefixSize > 0) {
                    int min = leng < this.unknownPrefixSize ? leng : this.unknownPrefixSize;
                    sb.append('-').append(word.substring(0, min));
                }
                if (word.length() == 1) {
                    sb.append(Character.getType(word.charAt(0)));
                }
                sb.append(ArabicUnknownWordSignatures.likelyAdjectivalSuffix(word));
                sb.append(ArabicUnknownWordSignatures.pastTenseVerbNumberSuffix(word));
                sb.append(ArabicUnknownWordSignatures.presentTenseVerbNumberSuffix(word));
                String ans = ArabicUnknownWordSignatures.abstractionNounSuffix(word);
                if (!"".equals(ans)) {
                    sb.append(ans);
                } else {
                    sb.append(ArabicUnknownWordSignatures.taaMarbuuTaSuffix(word));
                }
                if (this.unknownSuffixSize <= 0 || allDigitPlus) break;
                int min = leng < this.unknownSuffixSize ? leng : this.unknownSuffixSize;
                sb.append('-').append(word.substring(word.length() - min));
                break;
            }
            case 9: {
                boolean allDigitPlus = ArabicUnknownWordSignatures.allDigitPlus(word);
                int leng = word.length();
                if (allDigitPlus) {
                    sb.append("-NUM");
                } else if (word.startsWith("Al") || word.startsWith("\u0627\u0644")) {
                    sb.append("-Al");
                } else if (this.unknownPrefixSize > 0) {
                    int min = leng < this.unknownPrefixSize ? leng : this.unknownPrefixSize;
                    sb.append('-').append(word.substring(0, min));
                }
                sb.append(ArabicUnknownWordSignatures.likelyAdjectivalSuffix(word));
                sb.append(ArabicUnknownWordSignatures.pastTenseVerbNumberSuffix(word));
                sb.append(ArabicUnknownWordSignatures.presentTenseVerbNumberSuffix(word));
                String ans = ArabicUnknownWordSignatures.abstractionNounSuffix(word);
                if (!"".equals(ans)) {
                    sb.append(ans);
                } else {
                    sb.append(ArabicUnknownWordSignatures.taaMarbuuTaSuffix(word));
                }
                if (this.unknownSuffixSize <= 0 || allDigitPlus) break;
                int min = leng < this.unknownSuffixSize ? leng : this.unknownSuffixSize;
                sb.append('-').append(word.substring(word.length() - min));
                break;
            }
            case 8: {
                boolean allDigitPlus;
                if (word.startsWith("Al")) {
                    sb.append("-Al");
                }
                if (allDigitPlus = ArabicUnknownWordSignatures.allDigitPlus(word)) {
                    sb.append("-NUM");
                } else {
                    sb.append('-').append(word.charAt(0));
                }
                sb.append(ArabicUnknownWordSignatures.likelyAdjectivalSuffix(word));
                sb.append(ArabicUnknownWordSignatures.pastTenseVerbNumberSuffix(word));
                sb.append(ArabicUnknownWordSignatures.presentTenseVerbNumberSuffix(word));
                sb.append(ArabicUnknownWordSignatures.taaMarbuuTaSuffix(word));
                sb.append(ArabicUnknownWordSignatures.abstractionNounSuffix(word));
                break;
            }
            case 7: {
                boolean allDigitPlus = ArabicUnknownWordSignatures.allDigitPlus(word);
                if (allDigitPlus) {
                    sb.append("-NUM");
                    break;
                }
                sb.append(word.charAt(word.length() - 1));
                break;
            }
            case 6: {
                boolean allDigitPlus;
                if (word.startsWith("Al")) {
                    sb.append("-Al");
                }
                if (allDigitPlus = ArabicUnknownWordSignatures.allDigitPlus(word)) {
                    sb.append("-NUM");
                    break;
                }
                sb.append(word.charAt(word.length() - 1));
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public int getUnknownLevel() {
        return this.unknownLevel;
    }
}

