/*
 * Copyright (c) 2016 Sebastian Boegl
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package edu.sc.seis.launch4j.tasks

import edu.sc.seis.launch4j.CreateXML
import edu.sc.seis.launch4j.Launch4jPluginExtension
import groovy.transform.CompileStatic
import org.gradle.api.DefaultTask
import org.gradle.api.tasks.TaskAction

@CompileStatic
class CreateLaunch4jXMLTask extends DefaultTask {

    @TaskAction
    def void writeXmlConfig() {
        new CreateXML(project).execute(project.getExtensions().getByName('launch4j') as Launch4jPluginExtension)
    }

}
