/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class Picture
implements ActionListener {
    private BufferedImage image;
    private JFrame frame;
    private String filename;
    private boolean isOriginUpperLeft = true;
    private final int width;
    private final int height;

    public Picture(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be nonnegative");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be nonnegative");
        }
        this.width = width;
        this.height = height;
        this.image = new BufferedImage(width, height, 1);
        this.filename = width + "-by-" + height;
    }

    public Picture(Picture picture) {
        if (picture == null) {
            throw new IllegalArgumentException("constructor argument is null");
        }
        this.width = picture.width();
        this.height = picture.height();
        this.image = new BufferedImage(this.width, this.height, 1);
        this.filename = picture.filename;
        for (int col = 0; col < this.width(); ++col) {
            for (int row = 0; row < this.height(); ++row) {
                this.image.setRGB(col, row, picture.get(col, row).getRGB());
            }
        }
    }

    public Picture(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("constructor argument is null");
        }
        this.filename = filename;
        try {
            File file = new File(filename);
            if (file.isFile()) {
                this.image = ImageIO.read(file);
            } else {
                URL url = this.getClass().getResource(filename);
                if (url == null) {
                    url = new URL(filename);
                }
                this.image = ImageIO.read(url);
            }
            if (this.image == null) {
                throw new IllegalArgumentException("could not read image file: " + filename);
            }
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("could not open image file: " + filename, ioe);
        }
    }

    public Picture(File file) {
        if (file == null) {
            throw new IllegalArgumentException("constructor argument is null");
        }
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("could not open file: " + file, ioe);
        }
        if (this.image == null) {
            throw new IllegalArgumentException("could not read file: " + file);
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.filename = file.getName();
    }

    public JLabel getJLabel() {
        if (this.image == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(this.image);
        return new JLabel(icon);
    }

    public void setOriginUpperLeft() {
        this.isOriginUpperLeft = true;
    }

    public void setOriginLowerLeft() {
        this.isOriginUpperLeft = false;
    }

    public void show() {
        if (this.frame == null) {
            this.frame = new JFrame();
            JMenuBar menuBar = new JMenuBar();
            JMenu menu = new JMenu("File");
            menuBar.add(menu);
            JMenuItem menuItem1 = new JMenuItem(" Save...   ");
            menuItem1.addActionListener(this);
            menuItem1.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            menu.add(menuItem1);
            this.frame.setJMenuBar(menuBar);
            this.frame.setContentPane(this.getJLabel());
            this.frame.setDefaultCloseOperation(2);
            this.frame.setTitle(this.filename);
            this.frame.setResizable(false);
            this.frame.pack();
            this.frame.setVisible(true);
        }
        this.frame.repaint();
    }

    public int height() {
        return this.height;
    }

    public int width() {
        return this.width;
    }

    private void validateRowIndex(int row) {
        if (row < 0 || row >= this.height()) {
            throw new IndexOutOfBoundsException("row index must be between 0 and " + (this.height() - 1) + ": " + row);
        }
    }

    private void validateColumnIndex(int col) {
        if (col < 0 || col >= this.width()) {
            throw new IndexOutOfBoundsException("column index must be between 0 and " + (this.width() - 1) + ": " + col);
        }
    }

    public Color get(int col, int row) {
        this.validateColumnIndex(col);
        this.validateRowIndex(row);
        if (this.isOriginUpperLeft) {
            return new Color(this.image.getRGB(col, row));
        }
        return new Color(this.image.getRGB(col, this.height - row - 1));
    }

    public void set(int col, int row, Color color) {
        this.validateColumnIndex(col);
        this.validateRowIndex(row);
        if (color == null) {
            throw new IllegalArgumentException("color argument is null");
        }
        if (this.isOriginUpperLeft) {
            this.image.setRGB(col, row, color.getRGB());
        } else {
            this.image.setRGB(col, this.height - row - 1, color.getRGB());
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Picture that = (Picture)other;
        if (this.width() != that.width()) {
            return false;
        }
        if (this.height() != that.height()) {
            return false;
        }
        for (int col = 0; col < this.width(); ++col) {
            for (int row = 0; row < this.height(); ++row) {
                if (this.get(col, row).equals(that.get(col, row))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() is not supported because pictures are mutable");
    }

    public void save(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("argument to save() is null");
        }
        this.save(new File(filename));
    }

    public void save(File file) {
        String suffix;
        if (file == null) {
            throw new IllegalArgumentException("argument to save() is null");
        }
        this.filename = file.getName();
        if (this.frame != null) {
            this.frame.setTitle(this.filename);
        }
        if ("jpg".equalsIgnoreCase(suffix = this.filename.substring(this.filename.lastIndexOf(46) + 1)) || "png".equalsIgnoreCase(suffix)) {
            try {
                ImageIO.write((RenderedImage)this.image, suffix, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Error: filename must end in .jpg or .png");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileDialog chooser = new FileDialog((Frame)this.frame, "Use a .png or .jpg extension", 1);
        chooser.setVisible(true);
        if (chooser.getFile() != null) {
            this.save(chooser.getDirectory() + File.separator + chooser.getFile());
        }
    }

    public static void main(String[] args) {
        Picture picture = new Picture(args[0]);
        System.out.printf("%d-by-%d\n", picture.width(), picture.height());
        picture.show();
    }
}

