/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;

public final class In {
    private static final String CHARSET_NAME = "UTF-8";
    private static final Locale LOCALE = Locale.US;
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\p{javaWhitespace}+");
    private static final Pattern EMPTY_PATTERN = Pattern.compile("");
    private static final Pattern EVERYTHING_PATTERN = Pattern.compile("\\A");
    private Scanner scanner;

    public In() {
        this.scanner = new Scanner((InputStream)new BufferedInputStream(System.in), CHARSET_NAME);
        this.scanner.useLocale(LOCALE);
    }

    public In(Socket socket) {
        if (socket == null) {
            throw new IllegalArgumentException("socket argument is null");
        }
        try {
            InputStream is = socket.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(is), CHARSET_NAME);
            this.scanner.useLocale(LOCALE);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not open " + socket, ioe);
        }
    }

    public In(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url argument is null");
        }
        try {
            URLConnection site = url.openConnection();
            InputStream is = site.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(is), CHARSET_NAME);
            this.scanner.useLocale(LOCALE);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not open " + url, ioe);
        }
    }

    public In(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file argument is null");
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            this.scanner = new Scanner((InputStream)new BufferedInputStream(fis), CHARSET_NAME);
            this.scanner.useLocale(LOCALE);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not open " + file, ioe);
        }
    }

    public In(String name) {
        if (name == null) {
            throw new IllegalArgumentException("argument is null");
        }
        try {
            File file = new File(name);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                this.scanner = new Scanner((InputStream)new BufferedInputStream(fis), CHARSET_NAME);
                this.scanner.useLocale(LOCALE);
                return;
            }
            URL url = this.getClass().getResource(name);
            if (url == null) {
                url = new URL(name);
            }
            URLConnection site = url.openConnection();
            InputStream is = site.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(is), CHARSET_NAME);
            this.scanner.useLocale(LOCALE);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not open " + name, ioe);
        }
    }

    public In(Scanner scanner) {
        if (scanner == null) {
            throw new IllegalArgumentException("scanner argument is null");
        }
        this.scanner = scanner;
    }

    public boolean exists() {
        return this.scanner != null;
    }

    public boolean isEmpty() {
        return !this.scanner.hasNext();
    }

    public boolean hasNextLine() {
        return this.scanner.hasNextLine();
    }

    public boolean hasNextChar() {
        this.scanner.useDelimiter(EMPTY_PATTERN);
        boolean result = this.scanner.hasNext();
        this.scanner.useDelimiter(WHITESPACE_PATTERN);
        return result;
    }

    public String readLine() {
        String line;
        try {
            line = this.scanner.nextLine();
        }
        catch (NoSuchElementException e) {
            line = null;
        }
        return line;
    }

    public char readChar() {
        this.scanner.useDelimiter(EMPTY_PATTERN);
        try {
            String ch = this.scanner.next();
            assert (ch.length() == 1) : "Internal (Std)In.readChar() error! Please contact the authors.";
            this.scanner.useDelimiter(WHITESPACE_PATTERN);
            return ch.charAt(0);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("attempts to read a 'char' value from input stream, but there are no more tokens available");
        }
    }

    public String readAll() {
        if (!this.scanner.hasNextLine()) {
            return "";
        }
        String result = this.scanner.useDelimiter(EVERYTHING_PATTERN).next();
        this.scanner.useDelimiter(WHITESPACE_PATTERN);
        return result;
    }

    public String readString() {
        try {
            return this.scanner.next();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("attempts to read a 'String' value from input stream, but there are no more tokens available");
        }
    }

    public int readInt() {
        try {
            return this.scanner.nextInt();
        }
        catch (InputMismatchException e) {
            String token = this.scanner.next();
            throw new InputMismatchException("attempts to read an 'int' value from input stream, but the next token is \"" + token + "\"");
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("attemps to read an 'int' value from input stream, but there are no more tokens available");
        }
    }

    public double readDouble() {
        try {
            return this.scanner.nextDouble();
        }
        catch (InputMismatchException e) {
            String token = this.scanner.next();
            throw new InputMismatchException("attempts to read a 'double' value from input stream, but the next token is \"" + token + "\"");
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("attemps to read a 'double' value from input stream, but there are no more tokens available");
        }
    }

    public float readFloat() {
        try {
            return this.scanner.nextFloat();
        }
        catch (InputMismatchException e) {
            String token = this.scanner.next();
            throw new InputMismatchException("attempts to read a 'float' value from input stream, but the next token is \"" + token + "\"");
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("attemps to read a 'float' value from input stream, but there are no more tokens available");
        }
    }

    public long readLong() {
        try {
            return this.scanner.nextLong();
        }
        catch (InputMismatchException e) {
            String token = this.scanner.next();
            throw new InputMismatchException("attempts to read a 'long' value from input stream, but the next token is \"" + token + "\"");
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("attemps to read a 'long' value from input stream, but there are no more tokens available");
        }
    }

    public short readShort() {
        try {
            return this.scanner.nextShort();
        }
        catch (InputMismatchException e) {
            String token = this.scanner.next();
            throw new InputMismatchException("attempts to read a 'short' value from input stream, but the next token is \"" + token + "\"");
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("attemps to read a 'short' value from input stream, but there are no more tokens available");
        }
    }

    public byte readByte() {
        try {
            return this.scanner.nextByte();
        }
        catch (InputMismatchException e) {
            String token = this.scanner.next();
            throw new InputMismatchException("attempts to read a 'byte' value from input stream, but the next token is \"" + token + "\"");
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("attemps to read a 'byte' value from input stream, but there are no more tokens available");
        }
    }

    public boolean readBoolean() {
        try {
            String token = this.readString();
            if ("true".equalsIgnoreCase(token)) {
                return true;
            }
            if ("false".equalsIgnoreCase(token)) {
                return false;
            }
            if ("1".equals(token)) {
                return true;
            }
            if ("0".equals(token)) {
                return false;
            }
            throw new InputMismatchException("attempts to read a 'boolean' value from input stream, but the next token is \"" + token + "\"");
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("attempts to read a 'boolean' value from input stream, but there are no more tokens available");
        }
    }

    public String[] readAllStrings() {
        String[] tokens = WHITESPACE_PATTERN.split(this.readAll());
        if (tokens.length == 0 || tokens[0].length() > 0) {
            return tokens;
        }
        String[] decapitokens = new String[tokens.length - 1];
        for (int i = 0; i < tokens.length - 1; ++i) {
            decapitokens[i] = tokens[i + 1];
        }
        return decapitokens;
    }

    public String[] readAllLines() {
        ArrayList<String> lines = new ArrayList<String>();
        while (this.hasNextLine()) {
            lines.add(this.readLine());
        }
        return lines.toArray(new String[lines.size()]);
    }

    public int[] readAllInts() {
        String[] fields = this.readAllStrings();
        int[] vals = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vals[i] = Integer.parseInt(fields[i]);
        }
        return vals;
    }

    public long[] readAllLongs() {
        String[] fields = this.readAllStrings();
        long[] vals = new long[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vals[i] = Long.parseLong(fields[i]);
        }
        return vals;
    }

    public double[] readAllDoubles() {
        String[] fields = this.readAllStrings();
        double[] vals = new double[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vals[i] = Double.parseDouble(fields[i]);
        }
        return vals;
    }

    public void close() {
        this.scanner.close();
    }

    @Deprecated
    public static int[] readInts(String filename) {
        return new In(filename).readAllInts();
    }

    @Deprecated
    public static double[] readDoubles(String filename) {
        return new In(filename).readAllDoubles();
    }

    @Deprecated
    public static String[] readStrings(String filename) {
        return new In(filename).readAllStrings();
    }

    @Deprecated
    public static int[] readInts() {
        return new In().readAllInts();
    }

    @Deprecated
    public static double[] readDoubles() {
        return new In().readAllDoubles();
    }

    @Deprecated
    public static String[] readStrings() {
        return new In().readAllStrings();
    }

    public static void main(String[] args) {
        String s;
        In in;
        String urlName = "http://introcs.cs.princeton.edu/stdlib/InTest.txt";
        System.out.println("readAll() from URL " + urlName);
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In(urlName);
            System.out.println(in.readAll());
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readLine() from URL " + urlName);
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In(urlName);
            while (!in.isEmpty()) {
                s = in.readLine();
                System.out.println(s);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readString() from URL " + urlName);
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In(urlName);
            while (!in.isEmpty()) {
                s = in.readString();
                System.out.println(s);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readLine() from current directory");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("./InTest.txt");
            while (!in.isEmpty()) {
                s = in.readLine();
                System.out.println(s);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readLine() from relative path");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("../stdlib/InTest.txt");
            while (!in.isEmpty()) {
                s = in.readLine();
                System.out.println(s);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readChar() from file");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("InTest.txt");
            while (!in.isEmpty()) {
                char c = in.readChar();
                System.out.print(c);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println();
        System.out.println("readLine() from absolute OS X / Linux path");
        System.out.println("---------------------------------------------------------------------------");
        in = new In("/n/fs/introcs/www/java/stdlib/InTest.txt");
        try {
            while (!in.isEmpty()) {
                String s2 = in.readLine();
                System.out.println(s2);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readLine() from absolute Windows path");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("G:\\www\\introcs\\stdlib\\InTest.txt");
            while (!in.isEmpty()) {
                String s3 = in.readLine();
                System.out.println(s3);
            }
            System.out.println();
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        System.out.println();
    }
}

