/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.DijkstraSP;
import edu.princeton.cs.algs4.DirectedEdge;
import edu.princeton.cs.algs4.EdgeWeightedDigraph;

public class DijkstraAllPairsSP {
    private DijkstraSP[] all;

    public DijkstraAllPairsSP(EdgeWeightedDigraph G) {
        this.all = new DijkstraSP[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            this.all[v] = new DijkstraSP(G, v);
        }
    }

    public Iterable<DirectedEdge> path(int s, int t) {
        this.validateVertex(s);
        this.validateVertex(t);
        return this.all[s].pathTo(t);
    }

    public boolean hasPath(int s, int t) {
        this.validateVertex(s);
        this.validateVertex(t);
        return this.dist(s, t) < Double.POSITIVE_INFINITY;
    }

    public double dist(int s, int t) {
        this.validateVertex(s);
        this.validateVertex(t);
        return this.all[s].distTo(t);
    }

    private void validateVertex(int v) {
        int V = this.all.length;
        if (v < 0 || v >= V) {
            throw new IllegalArgumentException("vertex " + v + " is not between 0 and " + (V - 1));
        }
    }
}

