/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Queue;
import edu.princeton.cs.algs4.StdIn;
import edu.princeton.cs.algs4.StdOut;

public class TST<Value> {
    private int n;
    private Node<Value> root;

    public int size() {
        return this.n;
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public Value get(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key must have length >= 1");
        }
        Node<Value> x = this.get(this.root, key, 0);
        if (x == null) {
            return null;
        }
        return (Value)((Node)x).val;
    }

    private Node<Value> get(Node<Value> x, String key, int d) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key must have length >= 1");
        }
        if (x == null) {
            return null;
        }
        char c = key.charAt(d);
        if (c < ((Node)x).c) {
            return this.get(((Node)x).left, key, d);
        }
        if (c > ((Node)x).c) {
            return this.get(((Node)x).right, key, d);
        }
        if (d < key.length() - 1) {
            return this.get(((Node)x).mid, key, d + 1);
        }
        return x;
    }

    public void put(String key, Value val) {
        if (!this.contains(key)) {
            ++this.n;
        }
        this.root = this.put(this.root, key, val, 0);
    }

    private Node<Value> put(Node<Value> x, String key, Value val, int d) {
        char c = key.charAt(d);
        if (x == null) {
            x = new Node();
            ((Node)x).c = c;
        }
        if (c < ((Node)x).c) {
            ((Node)x).left = (Node)this.put(((Node)x).left, key, val, d);
        } else if (c > ((Node)x).c) {
            ((Node)x).right = (Node)this.put(((Node)x).right, key, val, d);
        } else if (d < key.length() - 1) {
            ((Node)x).mid = (Node)this.put(((Node)x).mid, key, val, d + 1);
        } else {
            ((Node)x).val = val;
        }
        return x;
    }

    public String longestPrefixOf(String query) {
        if (query == null || query.length() == 0) {
            return null;
        }
        int length = 0;
        Node x = this.root;
        int i = 0;
        while (x != null && i < query.length()) {
            char c = query.charAt(i);
            if (c < x.c) {
                x = x.left;
                continue;
            }
            if (c > x.c) {
                x = x.right;
                continue;
            }
            ++i;
            if (x.val != null) {
                length = i;
            }
            x = x.mid;
        }
        return query.substring(0, length);
    }

    public Iterable<String> keys() {
        Queue<String> queue = new Queue<String>();
        this.collect(this.root, new StringBuilder(), queue);
        return queue;
    }

    public Iterable<String> keysWithPrefix(String prefix) {
        Queue<String> queue = new Queue<String>();
        Node<Value> x = this.get(this.root, prefix, 0);
        if (x == null) {
            return queue;
        }
        if (((Node)x).val != null) {
            queue.enqueue(prefix);
        }
        this.collect(((Node)x).mid, new StringBuilder(prefix), queue);
        return queue;
    }

    private void collect(Node<Value> x, StringBuilder prefix, Queue<String> queue) {
        if (x == null) {
            return;
        }
        this.collect(((Node)x).left, prefix, queue);
        if (((Node)x).val != null) {
            queue.enqueue(prefix.toString() + ((Node)x).c);
        }
        this.collect(((Node)x).mid, prefix.append(((Node)x).c), queue);
        prefix.deleteCharAt(prefix.length() - 1);
        this.collect(((Node)x).right, prefix, queue);
    }

    public Iterable<String> keysThatMatch(String pattern) {
        Queue<String> queue = new Queue<String>();
        this.collect(this.root, new StringBuilder(), 0, pattern, queue);
        return queue;
    }

    private void collect(Node<Value> x, StringBuilder prefix, int i, String pattern, Queue<String> queue) {
        if (x == null) {
            return;
        }
        char c = pattern.charAt(i);
        if (c == '.' || c < ((Node)x).c) {
            this.collect(((Node)x).left, prefix, i, pattern, queue);
        }
        if (c == '.' || c == ((Node)x).c) {
            if (i == pattern.length() - 1 && ((Node)x).val != null) {
                queue.enqueue(prefix.toString() + ((Node)x).c);
            }
            if (i < pattern.length() - 1) {
                this.collect(((Node)x).mid, prefix.append(((Node)x).c), i + 1, pattern, queue);
                prefix.deleteCharAt(prefix.length() - 1);
            }
        }
        if (c == '.' || c > ((Node)x).c) {
            this.collect(((Node)x).right, prefix, i, pattern, queue);
        }
    }

    public static void main(String[] args) {
        TST<Integer> st = new TST<Integer>();
        int i = 0;
        while (!StdIn.isEmpty()) {
            String key = StdIn.readString();
            st.put(key, i);
            ++i;
        }
        if (st.size() < 100) {
            StdOut.println("keys(\"\"):");
            for (String key : st.keys()) {
                StdOut.println(key + " " + st.get(key));
            }
            StdOut.println();
        }
        StdOut.println("longestPrefixOf(\"shellsort\"):");
        StdOut.println(st.longestPrefixOf("shellsort"));
        StdOut.println();
        StdOut.println("longestPrefixOf(\"shell\"):");
        StdOut.println(st.longestPrefixOf("shell"));
        StdOut.println();
        StdOut.println("keysWithPrefix(\"shor\"):");
        for (String s : st.keysWithPrefix("shor")) {
            StdOut.println(s);
        }
        StdOut.println();
        StdOut.println("keysThatMatch(\".he.l.\"):");
        for (String s : st.keysThatMatch(".he.l.")) {
            StdOut.println(s);
        }
    }

    private static class Node<Value> {
        private char c;
        private Node<Value> left;
        private Node<Value> mid;
        private Node<Value> right;
        private Value val;

        private Node() {
        }
    }
}

