/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class StdDraw
implements ActionListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final Color BLACK = Color.BLACK;
    public static final Color BLUE = Color.BLUE;
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color GRAY = Color.GRAY;
    public static final Color GREEN = Color.GREEN;
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color RED = Color.RED;
    public static final Color WHITE = Color.WHITE;
    public static final Color YELLOW = Color.YELLOW;
    public static final Color BOOK_BLUE = new Color(9, 90, 166);
    public static final Color BOOK_LIGHT_BLUE = new Color(103, 198, 243);
    public static final Color BOOK_RED = new Color(150, 35, 31);
    private static final Color DEFAULT_PEN_COLOR = BLACK;
    private static final Color DEFAULT_CLEAR_COLOR = WHITE;
    private static Color penColor;
    private static final int DEFAULT_SIZE = 512;
    private static int width;
    private static int height;
    private static final double DEFAULT_PEN_RADIUS = 0.002;
    private static double penRadius;
    private static boolean defer;
    private static final double BORDER = 0.0;
    private static final double DEFAULT_XMIN = 0.0;
    private static final double DEFAULT_XMAX = 1.0;
    private static final double DEFAULT_YMIN = 0.0;
    private static final double DEFAULT_YMAX = 1.0;
    private static double xmin;
    private static double ymin;
    private static double xmax;
    private static double ymax;
    private static Object mouseLock;
    private static Object keyLock;
    private static final Font DEFAULT_FONT;
    private static Font font;
    private static BufferedImage offscreenImage;
    private static BufferedImage onscreenImage;
    private static Graphics2D offscreen;
    private static Graphics2D onscreen;
    private static StdDraw std;
    private static JFrame frame;
    private static boolean mousePressed;
    private static double mouseX;
    private static double mouseY;
    private static LinkedList<Character> keysTyped;
    private static TreeSet<Integer> keysDown;
    private static long nextDraw;

    private StdDraw() {
    }

    public static void setCanvasSize() {
        StdDraw.setCanvasSize(512, 512);
    }

    public static void setCanvasSize(int canvasWidth, int canvasHeight) {
        if (canvasWidth <= 0 || canvasHeight <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        width = canvasWidth;
        height = canvasHeight;
        StdDraw.init();
    }

    private static void init() {
        if (frame != null) {
            frame.setVisible(false);
        }
        frame = new JFrame();
        offscreenImage = new BufferedImage(width, height, 2);
        onscreenImage = new BufferedImage(width, height, 2);
        offscreen = offscreenImage.createGraphics();
        onscreen = onscreenImage.createGraphics();
        StdDraw.setXscale();
        StdDraw.setYscale();
        offscreen.setColor(DEFAULT_CLEAR_COLOR);
        offscreen.fillRect(0, 0, width, height);
        StdDraw.setPenColor();
        StdDraw.setPenRadius();
        StdDraw.setFont();
        StdDraw.clear();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        offscreen.addRenderingHints(hints);
        ImageIcon icon = new ImageIcon(onscreenImage);
        JLabel draw = new JLabel(icon);
        draw.addMouseListener(std);
        draw.addMouseMotionListener(std);
        frame.setContentPane(draw);
        frame.addKeyListener(std);
        frame.setResizable(false);
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Standard Draw");
        frame.setJMenuBar(StdDraw.createMenuBar());
        frame.pack();
        frame.requestFocusInWindow();
        frame.setVisible(true);
    }

    private static JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem menuItem1 = new JMenuItem(" Save...   ");
        menuItem1.addActionListener(std);
        menuItem1.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(menuItem1);
        return menuBar;
    }

    public static void setXscale() {
        StdDraw.setXscale(0.0, 1.0);
    }

    public static void setYscale() {
        StdDraw.setYscale(0.0, 1.0);
    }

    public static void setScale() {
        StdDraw.setXscale();
        StdDraw.setYscale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setXscale(double min, double max) {
        double size = max - min;
        if (size == 0.0) {
            throw new IllegalArgumentException("the min and max are the same");
        }
        Object object = mouseLock;
        synchronized (object) {
            xmin = min - 0.0 * size;
            xmax = max + 0.0 * size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setYscale(double min, double max) {
        double size = max - min;
        if (size == 0.0) {
            throw new IllegalArgumentException("the min and max are the same");
        }
        Object object = mouseLock;
        synchronized (object) {
            ymin = min - 0.0 * size;
            ymax = max + 0.0 * size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setScale(double min, double max) {
        double size = max - min;
        if (size == 0.0) {
            throw new IllegalArgumentException("the min and max are the same");
        }
        Object object = mouseLock;
        synchronized (object) {
            xmin = min - 0.0 * size;
            xmax = max + 0.0 * size;
            ymin = min - 0.0 * size;
            ymax = max + 0.0 * size;
        }
    }

    private static double scaleX(double x) {
        return (double)width * (x - xmin) / (xmax - xmin);
    }

    private static double scaleY(double y) {
        return (double)height * (ymax - y) / (ymax - ymin);
    }

    private static double factorX(double w) {
        return w * (double)width / Math.abs(xmax - xmin);
    }

    private static double factorY(double h) {
        return h * (double)height / Math.abs(ymax - ymin);
    }

    private static double userX(double x) {
        return xmin + x * (xmax - xmin) / (double)width;
    }

    private static double userY(double y) {
        return ymax - y * (ymax - ymin) / (double)height;
    }

    public static void clear() {
        StdDraw.clear(DEFAULT_CLEAR_COLOR);
    }

    public static void clear(Color color) {
        offscreen.setColor(color);
        offscreen.fillRect(0, 0, width, height);
        offscreen.setColor(penColor);
        StdDraw.draw();
    }

    public static double getPenRadius() {
        return penRadius;
    }

    public static void setPenRadius() {
        StdDraw.setPenRadius(0.002);
    }

    public static void setPenRadius(double radius) {
        if (!(radius >= 0.0)) {
            throw new IllegalArgumentException("pen radius must be nonnegative");
        }
        penRadius = radius;
        float scaledPenRadius = (float)(radius * 512.0);
        BasicStroke stroke = new BasicStroke(scaledPenRadius, 1, 1);
        offscreen.setStroke(stroke);
    }

    public static Color getPenColor() {
        return penColor;
    }

    public static void setPenColor() {
        StdDraw.setPenColor(DEFAULT_PEN_COLOR);
    }

    public static void setPenColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        penColor = color;
        offscreen.setColor(penColor);
    }

    public static void setPenColor(int red, int green, int blue) {
        if (red < 0 || red >= 256) {
            throw new IllegalArgumentException("amount of red must be between 0 and 255");
        }
        if (green < 0 || green >= 256) {
            throw new IllegalArgumentException("amount of green must be between 0 and 255");
        }
        if (blue < 0 || blue >= 256) {
            throw new IllegalArgumentException("amount of blue must be between 0 and 255");
        }
        StdDraw.setPenColor(new Color(red, green, blue));
    }

    public static Font getFont() {
        return font;
    }

    public static void setFont() {
        StdDraw.setFont(DEFAULT_FONT);
    }

    public static void setFont(Font font) {
        if (font == null) {
            throw new NullPointerException();
        }
        StdDraw.font = font;
    }

    public static void line(double x0, double y0, double x1, double y1) {
        offscreen.draw(new Line2D.Double(StdDraw.scaleX(x0), StdDraw.scaleY(y0), StdDraw.scaleX(x1), StdDraw.scaleY(y1)));
        StdDraw.draw();
    }

    private static void pixel(double x, double y) {
        offscreen.fillRect((int)Math.round(StdDraw.scaleX(x)), (int)Math.round(StdDraw.scaleY(y)), 1, 1);
    }

    public static void point(double x, double y) {
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double r = penRadius;
        float scaledPenRadius = (float)(r * 512.0);
        if (scaledPenRadius <= 1.0f) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.fill(new Ellipse2D.Double(xs - (double)(scaledPenRadius / 2.0f), ys - (double)(scaledPenRadius / 2.0f), scaledPenRadius, scaledPenRadius));
        }
        StdDraw.draw();
    }

    public static void circle(double x, double y, double radius) {
        if (!(radius >= 0.0)) {
            throw new IllegalArgumentException("radius must be nonnegative");
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(2.0 * radius);
        double hs = StdDraw.factorY(2.0 * radius);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.draw(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        StdDraw.draw();
    }

    public static void filledCircle(double x, double y, double radius) {
        if (!(radius >= 0.0)) {
            throw new IllegalArgumentException("radius must be nonnegative");
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(2.0 * radius);
        double hs = StdDraw.factorY(2.0 * radius);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.fill(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        StdDraw.draw();
    }

    public static void ellipse(double x, double y, double semiMajorAxis, double semiMinorAxis) {
        if (!(semiMajorAxis >= 0.0)) {
            throw new IllegalArgumentException("ellipse semimajor axis must be nonnegative");
        }
        if (!(semiMinorAxis >= 0.0)) {
            throw new IllegalArgumentException("ellipse semiminor axis must be nonnegative");
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(2.0 * semiMajorAxis);
        double hs = StdDraw.factorY(2.0 * semiMinorAxis);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.draw(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        StdDraw.draw();
    }

    public static void filledEllipse(double x, double y, double semiMajorAxis, double semiMinorAxis) {
        if (!(semiMajorAxis >= 0.0)) {
            throw new IllegalArgumentException("ellipse semimajor axis must be nonnegative");
        }
        if (!(semiMinorAxis >= 0.0)) {
            throw new IllegalArgumentException("ellipse semiminor axis must be nonnegative");
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(2.0 * semiMajorAxis);
        double hs = StdDraw.factorY(2.0 * semiMinorAxis);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.fill(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        StdDraw.draw();
    }

    public static void arc(double x, double y, double radius, double angle1, double angle2) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("arc radius must be nonnegative");
        }
        while (angle2 < angle1) {
            angle2 += 360.0;
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(2.0 * radius);
        double hs = StdDraw.factorY(2.0 * radius);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.draw(new Arc2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs, angle1, angle2 - angle1, 0));
        }
        StdDraw.draw();
    }

    public static void square(double x, double y, double halfLength) {
        if (!(halfLength >= 0.0)) {
            throw new IllegalArgumentException("half length must be nonnegative");
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(2.0 * halfLength);
        double hs = StdDraw.factorY(2.0 * halfLength);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.draw(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        StdDraw.draw();
    }

    public static void filledSquare(double x, double y, double halfLength) {
        if (!(halfLength >= 0.0)) {
            throw new IllegalArgumentException("half length must be nonnegative");
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(2.0 * halfLength);
        double hs = StdDraw.factorY(2.0 * halfLength);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.fill(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        StdDraw.draw();
    }

    public static void rectangle(double x, double y, double halfWidth, double halfHeight) {
        if (!(halfWidth >= 0.0)) {
            throw new IllegalArgumentException("half width must be nonnegative");
        }
        if (!(halfHeight >= 0.0)) {
            throw new IllegalArgumentException("half height must be nonnegative");
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(2.0 * halfWidth);
        double hs = StdDraw.factorY(2.0 * halfHeight);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.draw(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        StdDraw.draw();
    }

    public static void filledRectangle(double x, double y, double halfWidth, double halfHeight) {
        if (!(halfWidth >= 0.0)) {
            throw new IllegalArgumentException("half width must be nonnegative");
        }
        if (!(halfHeight >= 0.0)) {
            throw new IllegalArgumentException("half height must be nonnegative");
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(2.0 * halfWidth);
        double hs = StdDraw.factorY(2.0 * halfHeight);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.fill(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
        StdDraw.draw();
    }

    public static void polygon(double[] x, double[] y) {
        if (x == null) {
            throw new NullPointerException();
        }
        if (y == null) {
            throw new NullPointerException();
        }
        int n1 = x.length;
        int n2 = y.length;
        if (n1 != n2) {
            throw new IllegalArgumentException("arrays must be of the same length");
        }
        int n = n1;
        GeneralPath path = new GeneralPath();
        path.moveTo((float)StdDraw.scaleX(x[0]), (float)StdDraw.scaleY(y[0]));
        for (int i = 0; i < n; ++i) {
            path.lineTo((float)StdDraw.scaleX(x[i]), (float)StdDraw.scaleY(y[i]));
        }
        path.closePath();
        offscreen.draw(path);
        StdDraw.draw();
    }

    public static void filledPolygon(double[] x, double[] y) {
        if (x == null) {
            throw new NullPointerException();
        }
        if (y == null) {
            throw new NullPointerException();
        }
        int n1 = x.length;
        int n2 = y.length;
        if (n1 != n2) {
            throw new IllegalArgumentException("arrays must be of the same length");
        }
        int n = n1;
        GeneralPath path = new GeneralPath();
        path.moveTo((float)StdDraw.scaleX(x[0]), (float)StdDraw.scaleY(y[0]));
        for (int i = 0; i < n; ++i) {
            path.lineTo((float)StdDraw.scaleX(x[i]), (float)StdDraw.scaleY(y[i]));
        }
        path.closePath();
        offscreen.fill(path);
        StdDraw.draw();
    }

    private static BufferedImage getImage(String filename) {
        if (filename == null) {
            throw new NullPointerException();
        }
        try {
            URL url = new URL(filename);
            BufferedImage image = ImageIO.read(url);
            return image;
        }
        catch (IOException url) {
            try {
                URL url2 = StdDraw.class.getResource(filename);
                BufferedImage image = ImageIO.read(url2);
                return image;
            }
            catch (IOException url2) {
                try {
                    URL url3 = StdDraw.class.getResource("/" + filename);
                    BufferedImage image = ImageIO.read(url3);
                    return image;
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("image " + filename + " not found");
                }
            }
        }
    }

    public static void picture(double x, double y, String filename) {
        BufferedImage image = StdDraw.getImage(filename);
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        int ws = image.getWidth();
        int hs = image.getHeight();
        if (ws < 0 || hs < 0) {
            throw new IllegalArgumentException("image " + filename + " is corrupt");
        }
        offscreen.drawImage((Image)image, (int)Math.round(xs - (double)ws / 2.0), (int)Math.round(ys - (double)hs / 2.0), null);
        StdDraw.draw();
    }

    public static void picture(double x, double y, String filename, double degrees) {
        BufferedImage image = StdDraw.getImage(filename);
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        int ws = image.getWidth();
        int hs = image.getHeight();
        if (ws < 0 || hs < 0) {
            throw new IllegalArgumentException("image " + filename + " is corrupt");
        }
        offscreen.rotate(Math.toRadians(-degrees), xs, ys);
        offscreen.drawImage((Image)image, (int)Math.round(xs - (double)ws / 2.0), (int)Math.round(ys - (double)hs / 2.0), null);
        offscreen.rotate(Math.toRadians(degrees), xs, ys);
        StdDraw.draw();
    }

    public static void picture(double x, double y, String filename, double scaledWidth, double scaledHeight) {
        BufferedImage image = StdDraw.getImage(filename);
        if (scaledWidth < 0.0) {
            throw new IllegalArgumentException("width is negative: " + scaledWidth);
        }
        if (scaledHeight < 0.0) {
            throw new IllegalArgumentException("height is negative: " + scaledHeight);
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(scaledWidth);
        double hs = StdDraw.factorY(scaledHeight);
        if (ws < 0.0 || hs < 0.0) {
            throw new IllegalArgumentException("image " + filename + " is corrupt");
        }
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        } else {
            offscreen.drawImage(image, (int)Math.round(xs - ws / 2.0), (int)Math.round(ys - hs / 2.0), (int)Math.round(ws), (int)Math.round(hs), null);
        }
        StdDraw.draw();
    }

    public static void picture(double x, double y, String filename, double scaledWidth, double scaledHeight, double degrees) {
        if (scaledWidth < 0.0) {
            throw new IllegalArgumentException("width is negative: " + scaledWidth);
        }
        if (scaledHeight < 0.0) {
            throw new IllegalArgumentException("height is negative: " + scaledHeight);
        }
        BufferedImage image = StdDraw.getImage(filename);
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        double ws = StdDraw.factorX(scaledWidth);
        double hs = StdDraw.factorY(scaledHeight);
        if (ws < 0.0 || hs < 0.0) {
            throw new IllegalArgumentException("image " + filename + " is corrupt");
        }
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw.pixel(x, y);
        }
        offscreen.rotate(Math.toRadians(-degrees), xs, ys);
        offscreen.drawImage(image, (int)Math.round(xs - ws / 2.0), (int)Math.round(ys - hs / 2.0), (int)Math.round(ws), (int)Math.round(hs), null);
        offscreen.rotate(Math.toRadians(degrees), xs, ys);
        StdDraw.draw();
    }

    public static void text(double x, double y, String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        offscreen.setFont(font);
        FontMetrics metrics = offscreen.getFontMetrics();
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        int ws = metrics.stringWidth(text);
        int hs = metrics.getDescent();
        offscreen.drawString(text, (float)(xs - (double)ws / 2.0), (float)(ys + (double)hs));
        StdDraw.draw();
    }

    public static void text(double x, double y, String text, double degrees) {
        if (text == null) {
            throw new NullPointerException();
        }
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        offscreen.rotate(Math.toRadians(-degrees), xs, ys);
        StdDraw.text(x, y, text);
        offscreen.rotate(Math.toRadians(degrees), xs, ys);
    }

    public static void textLeft(double x, double y, String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        offscreen.setFont(font);
        FontMetrics metrics = offscreen.getFontMetrics();
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        int hs = metrics.getDescent();
        offscreen.drawString(text, (float)xs, (float)(ys + (double)hs));
        StdDraw.draw();
    }

    public static void textRight(double x, double y, String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        offscreen.setFont(font);
        FontMetrics metrics = offscreen.getFontMetrics();
        double xs = StdDraw.scaleX(x);
        double ys = StdDraw.scaleY(y);
        int ws = metrics.stringWidth(text);
        int hs = metrics.getDescent();
        offscreen.drawString(text, (float)(xs - (double)ws), (float)(ys + (double)hs));
        StdDraw.draw();
    }

    @Deprecated
    public static void show(int t) {
        long millis = System.currentTimeMillis();
        if (millis < nextDraw) {
            try {
                Thread.sleep(nextDraw - millis);
            }
            catch (InterruptedException e) {
                System.out.println("Error sleeping");
            }
            millis = nextDraw;
        }
        StdDraw.show();
        StdDraw.enableDoubleBuffering();
        nextDraw = millis + (long)t;
    }

    public static void pause(int t) {
        long millis = System.currentTimeMillis();
        if (millis < nextDraw) {
            try {
                Thread.sleep(nextDraw - millis);
            }
            catch (InterruptedException e) {
                System.out.println("Error sleeping");
            }
            millis = nextDraw;
        }
        nextDraw = millis + (long)t;
    }

    public static void show() {
        onscreen.drawImage((Image)offscreenImage, 0, 0, null);
        frame.repaint();
    }

    private static void draw() {
        if (!defer) {
            StdDraw.show();
        }
    }

    public static void enableDoubleBuffering() {
        defer = true;
    }

    public static void disableDoubleBuffering() {
        defer = false;
    }

    public static void save(String filename) {
        if (filename == null) {
            throw new NullPointerException();
        }
        File file = new File(filename);
        String suffix = filename.substring(filename.lastIndexOf(46) + 1);
        if (suffix.toLowerCase().equals("png")) {
            try {
                ImageIO.write((RenderedImage)onscreenImage, suffix, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (suffix.toLowerCase().equals("jpg")) {
            WritableRaster raster = onscreenImage.getRaster();
            WritableRaster newRaster = raster.createWritableChild(0, 0, width, height, 0, 0, new int[]{0, 1, 2});
            DirectColorModel cm = (DirectColorModel)onscreenImage.getColorModel();
            DirectColorModel newCM = new DirectColorModel(cm.getPixelSize(), cm.getRedMask(), cm.getGreenMask(), cm.getBlueMask());
            BufferedImage rgbBuffer = new BufferedImage(newCM, newRaster, false, null);
            try {
                ImageIO.write((RenderedImage)rgbBuffer, suffix, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Invalid image file type: " + suffix);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileDialog chooser = new FileDialog((Frame)frame, "Use a .png or .jpg extension", 1);
        chooser.setVisible(true);
        String filename = chooser.getFile();
        if (filename != null) {
            StdDraw.save(chooser.getDirectory() + File.separator + chooser.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mousePressed() {
        Object object = mouseLock;
        synchronized (object) {
            return mousePressed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double mouseX() {
        Object object = mouseLock;
        synchronized (object) {
            return mouseX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double mouseY() {
        Object object = mouseLock;
        synchronized (object) {
            return mouseY;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        Object object = mouseLock;
        synchronized (object) {
            mouseX = StdDraw.userX(e.getX());
            mouseY = StdDraw.userY(e.getY());
            mousePressed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        Object object = mouseLock;
        synchronized (object) {
            mousePressed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        Object object = mouseLock;
        synchronized (object) {
            mouseX = StdDraw.userX(e.getX());
            mouseY = StdDraw.userY(e.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent e) {
        Object object = mouseLock;
        synchronized (object) {
            mouseX = StdDraw.userX(e.getX());
            mouseY = StdDraw.userY(e.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNextKeyTyped() {
        Object object = keyLock;
        synchronized (object) {
            return !keysTyped.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char nextKeyTyped() {
        Object object = keyLock;
        synchronized (object) {
            if (keysTyped.isEmpty()) {
                throw new NoSuchElementException("your program has already processed all keystrokes");
            }
            return keysTyped.removeLast().charValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKeyPressed(int keycode) {
        Object object = keyLock;
        synchronized (object) {
            return keysDown.contains(keycode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(KeyEvent e) {
        Object object = keyLock;
        synchronized (object) {
            keysTyped.addFirst(Character.valueOf(e.getKeyChar()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        Object object = keyLock;
        synchronized (object) {
            keysDown.add(e.getKeyCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent e) {
        Object object = keyLock;
        synchronized (object) {
            keysDown.remove(e.getKeyCode());
        }
    }

    public static void main(String[] args) {
        StdDraw.square(0.2, 0.8, 0.1);
        StdDraw.filledSquare(0.8, 0.8, 0.2);
        StdDraw.circle(0.8, 0.2, 0.2);
        StdDraw.setPenColor(BOOK_RED);
        StdDraw.setPenRadius(0.02);
        StdDraw.arc(0.8, 0.2, 0.1, 200.0, 45.0);
        StdDraw.setPenRadius();
        StdDraw.setPenColor(BOOK_BLUE);
        double[] x = new double[]{0.1, 0.2, 0.3, 0.2};
        double[] y = new double[]{0.2, 0.3, 0.2, 0.1};
        StdDraw.filledPolygon(x, y);
        StdDraw.setPenColor(BLACK);
        StdDraw.text(0.2, 0.5, "black text");
        StdDraw.setPenColor(WHITE);
        StdDraw.text(0.8, 0.8, "white text");
    }

    static {
        width = 512;
        height = 512;
        defer = false;
        mouseLock = new Object();
        keyLock = new Object();
        DEFAULT_FONT = new Font("SansSerif", 0, 16);
        std = new StdDraw();
        mousePressed = false;
        mouseX = 0.0;
        mouseY = 0.0;
        keysTyped = new LinkedList();
        keysDown = new TreeSet();
        nextDraw = -1L;
        StdDraw.init();
    }
}

