/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class StdAudio {
    public static final int SAMPLE_RATE = 44100;
    private static final int BYTES_PER_SAMPLE = 2;
    private static final int BITS_PER_SAMPLE = 16;
    private static final double MAX_16_BIT = 32767.0;
    private static final int SAMPLE_BUFFER_SIZE = 4096;
    private static SourceDataLine line;
    private static byte[] buffer;
    private static int bufferSize;

    private StdAudio() {
    }

    private static void init() {
        try {
            AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format, 8192);
            buffer = new byte[2730];
        }
        catch (LineUnavailableException e) {
            System.out.println(e.getMessage());
        }
        line.start();
    }

    public static void close() {
        line.drain();
        line.stop();
    }

    public static void play(double sample) {
        if (Double.isNaN(sample)) {
            throw new IllegalArgumentException("sample is NaN");
        }
        if (sample < -1.0) {
            sample = -1.0;
        }
        if (sample > 1.0) {
            sample = 1.0;
        }
        short s = (short)(32767.0 * sample);
        StdAudio.buffer[StdAudio.bufferSize++] = (byte)s;
        StdAudio.buffer[StdAudio.bufferSize++] = (byte)(s >> 8);
        if (bufferSize >= buffer.length) {
            line.write(buffer, 0, buffer.length);
            bufferSize = 0;
        }
    }

    public static void play(double[] samples) {
        if (samples == null) {
            throw new NullPointerException("argument to play() is null");
        }
        for (int i = 0; i < samples.length; ++i) {
            StdAudio.play(samples[i]);
        }
    }

    public static double[] read(String filename) {
        byte[] data = StdAudio.readByte(filename);
        int n = data.length;
        double[] d = new double[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            d[i] = (double)((short)(((data[2 * i + 1] & 0xFF) << 8) + (data[2 * i] & 0xFF))) / 32767.0;
        }
        return d;
    }

    public static synchronized void play(String filename) {
        if (filename == null) {
            throw new NullPointerException();
        }
        try {
            Clip clip = AudioSystem.getClip();
            InputStream is = StdAudio.class.getResourceAsStream(filename);
            AudioInputStream ais = AudioSystem.getAudioInputStream(is);
            clip.open(ais);
            clip.start();
        }
        catch (RuntimeException e) {
            System.out.println("could not play '" + filename + "'");
            throw e;
        }
        catch (Exception e) {
            System.out.println("could not play '" + filename + "'");
            e.printStackTrace();
        }
    }

    public static synchronized void loop(String filename) {
        if (filename == null) {
            throw new NullPointerException();
        }
        try {
            Clip clip = AudioSystem.getClip();
            InputStream is = StdAudio.class.getResourceAsStream(filename);
            AudioInputStream ais = AudioSystem.getAudioInputStream(is);
            clip.open(ais);
            clip.loop(-1);
        }
        catch (RuntimeException e) {
            System.out.println("could not play '" + filename + "'");
            throw e;
        }
        catch (Exception e) {
            System.out.println("could not play '" + filename + "'");
            e.printStackTrace();
        }
    }

    private static byte[] readByte(String filename) {
        byte[] data = null;
        AudioInputStream ais = null;
        try {
            File file = new File(filename);
            if (file.exists()) {
                int bytesRead;
                ais = AudioSystem.getAudioInputStream(file);
                int bytesToRead = ais.available();
                if (bytesToRead != (bytesRead = ais.read(data = new byte[bytesToRead]))) {
                    throw new RuntimeException("read only " + bytesRead + " of " + bytesToRead + " bytes");
                }
            } else {
                int bytesRead;
                URL url = StdAudio.class.getResource(filename);
                ais = AudioSystem.getAudioInputStream(url);
                int bytesToRead = ais.available();
                if (bytesToRead != (bytesRead = ais.read(data = new byte[bytesToRead]))) {
                    throw new RuntimeException("read only " + bytesRead + " of " + bytesToRead + " bytes");
                }
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException("Could not read " + filename);
        }
        catch (UnsupportedAudioFileException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException(filename + " in unsupported audio format");
        }
        return data;
    }

    public static void save(String filename, double[] samples) {
        block5: {
            AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, false);
            byte[] data = new byte[2 * samples.length];
            for (int i = 0; i < samples.length; ++i) {
                short temp = (short)(samples[i] * 32767.0);
                data[2 * i + 0] = (byte)temp;
                data[2 * i + 1] = (byte)(temp >> 8);
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                AudioInputStream ais = new AudioInputStream(bais, format, samples.length);
                if (filename.endsWith(".wav") || filename.endsWith(".WAV")) {
                    AudioSystem.write(ais, AudioFileFormat.Type.WAVE, new File(filename));
                    break block5;
                }
                if (filename.endsWith(".au") || filename.endsWith(".AU")) {
                    AudioSystem.write(ais, AudioFileFormat.Type.AU, new File(filename));
                    break block5;
                }
                throw new RuntimeException("File format not supported: " + filename);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    private static double[] note(double hz, double duration, double amplitude) {
        int n = (int)(44100.0 * duration);
        double[] a = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            a[i] = amplitude * Math.sin(Math.PI * 2 * (double)i * hz / 44100.0);
        }
        return a;
    }

    public static void main(String[] args) {
        double freq = 440.0;
        for (int i = 0; i <= 44100; ++i) {
            StdAudio.play(0.5 * Math.sin(Math.PI * 2 * freq * (double)i / 44100.0));
        }
        int[] steps = new int[]{0, 2, 4, 5, 7, 9, 11, 12};
        for (int i = 0; i < steps.length; ++i) {
            double hz = 440.0 * Math.pow(2.0, (double)steps[i] / 12.0);
            StdAudio.play(StdAudio.note(hz, 1.0, 0.5));
        }
        StdAudio.close();
    }

    static {
        bufferSize = 0;
        StdAudio.init();
    }
}

