/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.StdIn;
import edu.princeton.cs.algs4.StdOut;

public class QuickX {
    private static final int INSERTION_SORT_CUTOFF = 8;
    private static final int MEDIAN_OF_3_CUTOFF = 40;

    private QuickX() {
    }

    public static void sort(Comparable[] a) {
        QuickX.sort(a, 0, a.length - 1);
    }

    private static void sort(Comparable[] a, int lo, int hi) {
        int k;
        int n = hi - lo + 1;
        if (n <= 8) {
            QuickX.insertionSort(a, lo, hi);
            return;
        }
        if (n <= 40) {
            int m = QuickX.median3(a, lo, lo + n / 2, hi);
            QuickX.exch(a, m, lo);
        } else {
            int eps = n / 8;
            int mid = lo + n / 2;
            int m1 = QuickX.median3(a, lo, lo + eps, lo + eps + eps);
            int m2 = QuickX.median3(a, mid - eps, mid, mid + eps);
            int m3 = QuickX.median3(a, hi - eps - eps, hi - eps, hi);
            int ninther = QuickX.median3(a, m1, m2, m3);
            QuickX.exch(a, ninther, lo);
        }
        int i = lo;
        int j = hi + 1;
        int p = lo;
        int q = hi + 1;
        Comparable v = a[lo];
        while (true) {
            if (QuickX.less(a[++i], v) && i != hi) {
                continue;
            }
            while (QuickX.less(v, a[--j]) && j != lo) {
            }
            if (i == j && QuickX.eq(a[i], v)) {
                QuickX.exch(a, ++p, i);
            }
            if (i >= j) break;
            QuickX.exch(a, i, j);
            if (QuickX.eq(a[i], v)) {
                QuickX.exch(a, ++p, i);
            }
            if (!QuickX.eq(a[j], v)) continue;
            QuickX.exch(a, --q, j);
        }
        i = j + 1;
        for (k = lo; k <= p; ++k) {
            QuickX.exch(a, k, j--);
        }
        for (k = hi; k >= q; --k) {
            QuickX.exch(a, k, i++);
        }
        QuickX.sort(a, lo, j);
        QuickX.sort(a, i, hi);
    }

    private static void insertionSort(Comparable[] a, int lo, int hi) {
        for (int i = lo; i <= hi; ++i) {
            for (int j = i; j > lo && QuickX.less(a[j], a[j - 1]); --j) {
                QuickX.exch(a, j, j - 1);
            }
        }
    }

    private static int median3(Comparable[] a, int i, int j, int k) {
        return QuickX.less(a[i], a[j]) ? (QuickX.less(a[j], a[k]) ? j : (QuickX.less(a[i], a[k]) ? k : i)) : (QuickX.less(a[k], a[j]) ? j : (QuickX.less(a[k], a[i]) ? k : i));
    }

    private static boolean less(Comparable v, Comparable w) {
        return v.compareTo(w) < 0;
    }

    private static boolean eq(Comparable v, Comparable w) {
        return v.compareTo(w) == 0;
    }

    private static void exch(Object[] a, int i, int j) {
        Object swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }

    private static boolean isSorted(Comparable[] a) {
        for (int i = 1; i < a.length; ++i) {
            if (!QuickX.less(a[i], a[i - 1])) continue;
            return false;
        }
        return true;
    }

    private static void show(Comparable[] a) {
        for (int i = 0; i < a.length; ++i) {
            StdOut.println(a[i]);
        }
    }

    public static void main(String[] args) {
        String[] a = StdIn.readAllStrings();
        QuickX.sort((Comparable[])a);
        assert (QuickX.isSorted((Comparable[])a));
        QuickX.show((Comparable[])a);
    }
}

