/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import edu.vt.middleware.ldap.ssl.AbstractSSLContextInitializer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class KeyStoreSSLContextInitializer
extends AbstractSSLContextInitializer {
    private KeyStore trustKeystore;
    private KeyStore authenticationKeystore;
    private char[] authenticationPassword;

    public void setTrustKeystore(KeyStore ks) {
        this.trustKeystore = ks;
    }

    public void setAuthenticationKeystore(KeyStore ks) {
        this.authenticationKeystore = ks;
    }

    public void setAuthenticationPassword(char[] password) {
        this.authenticationPassword = password;
    }

    public TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManager[] tm = null;
        if (this.trustKeystore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.trustKeystore);
            tm = tmf.getTrustManagers();
        }
        return tm;
    }

    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        KeyManager[] km = null;
        if (this.authenticationKeystore != null && this.authenticationPassword != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(this.authenticationKeystore, this.authenticationPassword);
            km = kmf.getKeyManagers();
        }
        return km;
    }
}

