/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.props;

import edu.vt.middleware.ldap.props.AbstractPropertyInvoker;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePropertyInvoker
extends AbstractPropertyInvoker {
    public SimplePropertyInvoker(Class<?> c) {
        this.initialize(c, "");
    }

    @Override
    protected Object convertValue(Class<?> type, String value) {
        Object newValue = value;
        if (type != String.class) {
            if (Class.class.isAssignableFrom(type)) {
                newValue = "null".equals(value) ? null : SimplePropertyInvoker.createClass(value);
            } else if (Class[].class.isAssignableFrom(type)) {
                if ("null".equals(value)) {
                    newValue = null;
                } else {
                    String[] classes = value.split(",");
                    newValue = Array.newInstance(Class.class, classes.length);
                    for (int i = 0; i < classes.length; ++i) {
                        Array.set(newValue, i, SimplePropertyInvoker.createClass(classes[i]));
                    }
                }
            } else if (type.isEnum()) {
                for (Object o : type.getEnumConstants()) {
                    Enum e = (Enum)o;
                    if (!e.name().equals(value)) continue;
                    newValue = o;
                }
            } else if (String[].class == type) {
                newValue = value.split(",");
            } else if (Object[].class == type) {
                newValue = value.split(",");
            } else if (Float.TYPE == type) {
                newValue = Float.valueOf(Float.parseFloat(value));
            } else if (Integer.TYPE == type) {
                newValue = Integer.parseInt(value);
            } else if (Long.TYPE == type) {
                newValue = Long.parseLong(value);
            } else if (Short.TYPE == type) {
                newValue = Short.parseShort(value);
            } else if (Double.TYPE == type) {
                newValue = Double.parseDouble(value);
            } else if (Boolean.TYPE == type) {
                newValue = Boolean.valueOf(value);
            }
        }
        return newValue;
    }
}

