/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.auth.handler;

import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.auth.AuthenticatorConfig;
import edu.vt.middleware.ldap.auth.handler.AbstractAuthenticationHandler;
import edu.vt.middleware.ldap.auth.handler.AuthenticationCriteria;
import edu.vt.middleware.ldap.handler.ConnectionHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;

public class CompareAuthenticationHandler
extends AbstractAuthenticationHandler {
    private static final int DIGEST_SIZE = 256;
    private String passwordScheme = "SHA";

    public CompareAuthenticationHandler() {
    }

    public CompareAuthenticationHandler(AuthenticatorConfig ac) {
        this.setAuthenticatorConfig(ac);
    }

    public String getPasswordScheme() {
        return this.passwordScheme;
    }

    public void setPasswordScheme(String s) {
        this.passwordScheme = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(ConnectionHandler ch, AuthenticationCriteria ac) throws NamingException {
        byte[] hash = new byte[256];
        try {
            MessageDigest md = MessageDigest.getInstance(this.passwordScheme);
            md.update(((String)ac.getCredential()).getBytes());
            hash = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NamingException(e.getMessage());
        }
        ch.connect(this.config.getBindDn(), this.config.getBindCredential());
        NamingEnumeration<SearchResult> en = null;
        try {
            en = ch.getLdapContext().search(ac.getDn(), "userPassword={0}", new Object[]{String.format("{%s}%s", this.passwordScheme, LdapUtil.base64Encode(hash)).getBytes()}, LdapConfig.getCompareSearchControls());
            if (!en.hasMore()) {
                throw new AuthenticationException("Compare authentication failed.");
            }
        }
        finally {
            if (en != null) {
                en.close();
            }
        }
    }

    public CompareAuthenticationHandler newInstance() {
        return new CompareAuthenticationHandler(this.config);
    }
}

