/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.auth;

import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.auth.AbstractAuthenticator;
import edu.vt.middleware.ldap.auth.AuthenticatorConfig;
import edu.vt.middleware.ldap.auth.handler.AuthenticationResultHandler;
import edu.vt.middleware.ldap.auth.handler.AuthorizationHandler;
import edu.vt.middleware.ldap.auth.handler.CompareAuthorizationHandler;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Authenticator
extends AbstractAuthenticator<AuthenticatorConfig>
implements Serializable {
    private static final long serialVersionUID = -444519681288987247L;

    public Authenticator() {
    }

    public Authenticator(AuthenticatorConfig authConfig) {
        this.setAuthenticatorConfig(authConfig);
    }

    public AuthenticatorConfig getAuthenticatorConfig() {
        return this.config;
    }

    public void loadFromProperties() {
        this.setAuthenticatorConfig(AuthenticatorConfig.createFromProperties(null));
    }

    public void loadFromProperties(InputStream is) {
        this.setAuthenticatorConfig(AuthenticatorConfig.createFromProperties(is));
    }

    public String getDn(String user) throws NamingException {
        return this.config.getDnResolver().resolve(user);
    }

    public boolean authenticate() throws NamingException {
        return this.authenticate(this.config.getUser(), this.config.getCredential());
    }

    public boolean authenticate(String user, Object credential) throws NamingException {
        return this.authenticate(user, credential, new SearchFilter(this.config.getAuthorizationFilter(), this.config.getAuthorizationFilterArgs()));
    }

    public boolean authenticate(String user, Object credential, SearchFilter filter) throws NamingException {
        ArrayList<AuthorizationHandler> authzHandler = new ArrayList<AuthorizationHandler>();
        if (filter != null && filter.getFilter() != null) {
            authzHandler.add(new CompareAuthorizationHandler(filter));
        }
        if (this.config.getAuthorizationHandlers() != null) {
            authzHandler.addAll(Arrays.asList(this.config.getAuthorizationHandlers()));
        }
        return this.authenticate(user, credential, this.config.getAuthenticationResultHandlers(), authzHandler.toArray(new AuthorizationHandler[0]));
    }

    public boolean authenticate(String user, Object credential, AuthenticationResultHandler[] authHandler, AuthorizationHandler[] authzHandler) throws NamingException {
        return super.authenticateAndAuthorize(this.getDn(user), credential, authHandler, authzHandler);
    }

    public Attributes authenticate(String[] retAttrs) throws NamingException {
        return this.authenticate(this.config.getUser(), this.config.getCredential(), retAttrs);
    }

    public Attributes authenticate(String user, Object credential, String[] retAttrs) throws NamingException {
        return this.authenticate(user, credential, new SearchFilter(this.config.getAuthorizationFilter(), this.config.getAuthorizationFilterArgs()), retAttrs);
    }

    public Attributes authenticate(String user, Object credential, SearchFilter filter, String[] retAttrs) throws NamingException {
        ArrayList<AuthorizationHandler> authzHandler = new ArrayList<AuthorizationHandler>();
        if (filter != null && filter.getFilter() != null) {
            authzHandler.add(new CompareAuthorizationHandler(filter));
        }
        if (this.config.getAuthorizationHandlers() != null) {
            authzHandler.addAll(Arrays.asList(this.config.getAuthorizationHandlers()));
        }
        return this.authenticate(user, credential, retAttrs, this.config.getAuthenticationResultHandlers(), authzHandler.toArray(new AuthorizationHandler[0]));
    }

    public Attributes authenticate(String user, Object credential, String[] retAttrs, AuthenticationResultHandler[] authHandler, AuthorizationHandler[] authzHandler) throws NamingException {
        return this.authenticateAndAuthorize(this.getDn(user), credential, true, retAttrs, authHandler, authzHandler);
    }
}

