/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.config.profile.authn;

import edu.internet2.middleware.shibboleth.idp.config.profile.authn.AbstractLoginHandlerBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.idp.config.profile.authn.IPAddressLoginHandlerFactoryBean;
import edu.internet2.middleware.shibboleth.idp.util.IPRange;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyList;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class IPAddressLoginHandlerBeanDefinitionParser
extends AbstractLoginHandlerBeanDefinitionParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:idp:profile-handler", "IPAddress");
    private final Logger log = LoggerFactory.getLogger(IPAddressLoginHandlerBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return IPAddressLoginHandlerFactoryBean.class;
    }

    @Override
    protected void doParse(Element config, BeanDefinitionBuilder builder) {
        super.doParse(config, builder);
        String username = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "username"));
        if (username == null) {
            String msg = "No username specified.";
            this.log.error(msg);
            throw new BeanCreationException(msg);
        }
        this.log.debug("authenticated username: {}", (Object)username);
        builder.addPropertyValue("authenticatedUser", (Object)username);
        List<IPRange> ranges = this.getIPRanges(config);
        this.log.debug("registered IP ranges: {}", (Object)ranges.size());
        builder.addPropertyValue("ipRanges", ranges);
        boolean defaultDeny = XMLHelper.getAttributeValueAsBoolean((Attr)config.getAttributeNodeNS(null, "defaultDeny"));
        this.log.debug("default deny: {}", (Object)defaultDeny);
        builder.addPropertyValue("ipInRangeIsAuthenticated", (Object)defaultDeny);
    }

    protected List<IPRange> getIPRanges(Element config) {
        List ipEntries = XMLHelper.getChildElementsByTagNameNS((Element)config, (String)"urn:mace:shibboleth:2.0:idp:profile-handler", (String)"IPEntry");
        if (ipEntries == null || ipEntries.isEmpty()) {
            String msg = "At least one IPEntry must be specified.";
            this.log.error(msg);
            throw new BeanCreationException(msg);
        }
        LazyList ranges = new LazyList();
        for (Element ipEntry : ipEntries) {
            ranges.add(IPRange.parseCIDRBlock(ipEntry.getTextContent()));
        }
        return ranges;
    }
}

