/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import net.sf.ehcache.Element;
import net.sf.ehcache.ElementEvictionData;
import net.sf.ehcache.util.TimeUtil;

public class DefaultElementEvictionData
implements ElementEvictionData {
    private int creationTime;
    private int lastAccessTime;

    public DefaultElementEvictionData(int creationTime) {
        this.creationTime = creationTime;
    }

    public DefaultElementEvictionData(int creationTime, int lastAccessTime) {
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
    }

    public void setCreationTime(int creationTime) {
        this.creationTime = creationTime;
    }

    public int getCreationTime() {
        return this.creationTime;
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void updateLastAccessTime(int time, Element element) {
        this.lastAccessTime = time;
    }

    public void resetLastAccessTime(Element element) {
        this.lastAccessTime = TimeUtil.toSecs(System.currentTimeMillis());
    }

    public final ElementEvictionData clone() throws CloneNotSupportedException {
        DefaultElementEvictionData result = (DefaultElementEvictionData)super.clone();
        result.creationTime = this.creationTime;
        result.lastAccessTime = this.lastAccessTime;
        return result;
    }

    public boolean canParticipateInSerialization() {
        return true;
    }
}

