/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.TrustManager;
import net.jcip.annotations.ThreadSafe;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.io.SVNRepository;

@ThreadSafe
public class SVNBasicAuthenticationManager
implements ISVNAuthenticationManager {
    private final Logger log = LoggerFactory.getLogger(SVNBasicAuthenticationManager.class);
    private int connectionTimeout = 5000;
    private int readTimeout = 10000;
    private TrustManager trustManager;
    private Map<String, SVNAuthentication> authenticationMethods;
    private final BasicProxyManager proxyManager;

    public SVNBasicAuthenticationManager(List<SVNAuthentication> authnMethods) {
        this.setAuthenticationMethods(authnMethods);
        this.proxyManager = null;
    }

    public SVNBasicAuthenticationManager(List<SVNAuthentication> authnMethods, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this.setAuthenticationMethods(authnMethods);
        this.proxyManager = new BasicProxyManager(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public void acknowledgeAuthentication(boolean authnAccepted, String authnKind, String authnRealm, SVNErrorMessage error, SVNAuthentication authnMethods) throws SVNException {
        if (authnAccepted) {
            this.log.trace("Successful authentication to SVN repository with {} credentials", (Object)authnKind);
        } else {
            this.log.trace("Unable to authenticate to SVN repository with {} credentials", (Object)authnKind);
        }
    }

    public void acknowledgeTrustManager(TrustManager manager) {
        this.log.debug("HTTPS connectiont trusted by trust manager");
    }

    public int getConnectTimeout(SVNRepository repository) {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout <= 0 ? Integer.MAX_VALUE : timeout;
    }

    public SVNAuthentication getFirstAuthentication(String authnKind, String authnRealm, SVNURL repository) throws SVNException {
        return this.authenticationMethods.get(authnKind);
    }

    public SVNAuthentication getNextAuthentication(String authnKind, String authnRealm, SVNURL respository) throws SVNException {
        return null;
    }

    public ISVNProxyManager getProxyManager(SVNURL repository) throws SVNException {
        return this.proxyManager;
    }

    public int getReadTimeout(SVNRepository repository) {
        return this.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout <= 0 ? Integer.MAX_VALUE : timeout;
    }

    public TrustManager getTrustManager(SVNURL respository) throws SVNException {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager manager) {
        this.trustManager = manager;
    }

    public boolean isAuthenticationForced() {
        return false;
    }

    public void setAuthenticationProvider(ISVNAuthenticationProvider arg0) {
    }

    private void setAuthenticationMethods(List<SVNAuthentication> authnMethods) {
        if (authnMethods == null || authnMethods.size() == 0) {
            this.authenticationMethods = Collections.emptyMap();
        } else {
            HashMap<String, SVNAuthentication> methods = new HashMap<String, SVNAuthentication>();
            for (SVNAuthentication method : authnMethods) {
                if (methods.containsKey(method.getKind())) {
                    this.log.warn("An authentication method of type " + method.getKind() + " has already been set, only the first will be used");
                    continue;
                }
                methods.put(method.getKind(), method);
            }
            this.authenticationMethods = Collections.unmodifiableMap(methods);
        }
    }

    private class BasicProxyManager
    implements ISVNProxyManager {
        private final String host;
        private final int port;
        private final String user;
        private final String password;

        public BasicProxyManager(String host, int port, String user, String password) {
            this.host = DatatypeHelper.safeTrimOrNullString((String)host);
            if (this.host == null) {
                throw new IllegalArgumentException("Proxy host may not be null or empty");
            }
            this.port = port;
            this.user = DatatypeHelper.safeTrimOrNullString((String)user);
            this.password = DatatypeHelper.safeTrimOrNullString((String)password);
        }

        public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage error) {
            if (accepted) {
                SVNBasicAuthenticationManager.this.log.trace("Connected to HTTP proxy " + this.host + ":" + this.port);
            }
            SVNBasicAuthenticationManager.this.log.error("Unable to connect to HTTP proxy " + this.host + ":" + this.port + " recieved error:\n" + error.getFullMessage());
        }

        public String getProxyHost() {
            return this.host;
        }

        public String getProxyPassword() {
            return this.password;
        }

        public int getProxyPort() {
            return this.port;
        }

        public String getProxyUserName() {
            return this.user;
        }
    }
}

