/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.relyingparty;

import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.util.DatatypeHelper;

public class RelyingPartyConfiguration {
    private String relyingPartyId;
    private String providerId;
    private String defaultAuthenticationMethod;
    private Credential signingCredential;
    private String[] nameIdFormatPrecedence;
    private HashMap<String, ProfileConfiguration> profiles;

    public RelyingPartyConfiguration(String provider) {
        this.setProviderId(provider);
        this.profiles = new HashMap();
    }

    public RelyingPartyConfiguration(String relyingParty, String provider) {
        this.setRelyingPartyId(relyingParty);
        this.setProviderId(provider);
        this.profiles = new HashMap();
    }

    public String[] getNameIdFormatPrecedence() {
        return this.nameIdFormatPrecedence;
    }

    public void setNameIdFormatPrecedence(String[] precedence) {
        this.nameIdFormatPrecedence = precedence;
    }

    public String getRelyingPartyId() {
        return this.relyingPartyId;
    }

    protected void setRelyingPartyId(String id) {
        this.relyingPartyId = DatatypeHelper.safeTrimOrNullString((String)id);
    }

    public String getProviderId() {
        return this.providerId;
    }

    protected void setProviderId(String id) {
        this.providerId = DatatypeHelper.safeTrimOrNullString((String)id);
    }

    public String getDefaultAuthenticationMethod() {
        return this.defaultAuthenticationMethod;
    }

    public void setDefaultAuthenticationMethod(String method) {
        this.defaultAuthenticationMethod = method;
    }

    public Credential getDefaultSigningCredential() {
        return this.signingCredential;
    }

    public void setDefaultSigningCredential(Credential credential) {
        this.signingCredential = credential;
    }

    public Map<String, ProfileConfiguration> getProfileConfigurations() {
        return this.profiles;
    }

    public ProfileConfiguration getProfileConfiguration(String profileId) {
        if (this.profiles != null) {
            return this.profiles.get(profileId);
        }
        return null;
    }
}

