/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.profile.provider;

import edu.internet2.middleware.shibboleth.common.profile.AbstractErrorHandler;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.util.DatatypeHelper;
import org.owasp.esapi.ESAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityErrorHandler
extends AbstractErrorHandler {
    private final Logger log = LoggerFactory.getLogger(VelocityErrorHandler.class);
    private VelocityEngine velocityEngine;
    private String templatePath;

    public VelocityErrorHandler(VelocityEngine engine, String template) {
        if (engine == null) {
            this.log.error("Velocity engine may not be null");
            throw new IllegalArgumentException("Velocity engine may not be null");
        }
        this.velocityEngine = engine;
        this.templatePath = DatatypeHelper.safeTrimOrNullString((String)template);
        if (this.templatePath == null) {
            this.log.error("Velocity template path may not be null or empty");
            throw new IllegalArgumentException("Velocity template path may not be null or empty");
        }
    }

    @Override
    public void processRequest(InTransport in, OutTransport out) {
        VelocityContext context = new VelocityContext();
        context.put("request", (Object)((HttpServletRequestAdapter)in).getWrappedRequest());
        context.put("requestError", in.getAttribute("error"));
        context.put("encoder", (Object)ESAPI.encoder());
        HttpServletResponse response = ((HttpServletResponseAdapter)out).getWrappedResponse();
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "content=\"no-store,no-cache,must-revalidate\"");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "-1");
        try {
            OutputStreamWriter responseWriter = new OutputStreamWriter(out.getOutgoingStream());
            Template template = this.velocityEngine.getTemplate(this.templatePath);
            template.merge((Context)context, (Writer)responseWriter);
            responseWriter.flush();
        }
        catch (Throwable t) {
            this.log.error("Unable to evaluate velocity error template", t);
        }
    }
}

