/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import edu.internet2.middleware.shibboleth.common.log.LogbackConfigurationChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import org.opensaml.util.resource.FilesystemResource;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceChangeWatcher;
import org.opensaml.util.resource.ResourceException;
import org.slf4j.LoggerFactory;

public class LogbackLoggingService {
    public LogbackLoggingService(Timer taskTimer, String loggingConfigurationFile, long pollingFrequency) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager statusManager = loggerContext.getStatusManager();
        try {
            FilesystemResource configResource = new FilesystemResource(loggingConfigurationFile);
            LogbackConfigurationChangeListener configChangeListener = new LogbackConfigurationChangeListener();
            configChangeListener.onResourceCreate((Resource)configResource);
            ResourceChangeWatcher resourceWatcher = new ResourceChangeWatcher((Resource)configResource, pollingFrequency, 5);
            resourceWatcher.getResourceListeners().add(configChangeListener);
            taskTimer.schedule((TimerTask)resourceWatcher, 0L, pollingFrequency);
        }
        catch (ResourceException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + loggingConfigurationFile, (Object)this, (Throwable)e));
        }
    }
}

