/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensaml.xml.security.keyinfo.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.provider.DSAKeyValueProvider;
import org.opensaml.xml.security.keyinfo.provider.InlineX509DataProvider;
import org.opensaml.xml.security.keyinfo.provider.RSAKeyValueProvider;
import org.opensaml.xml.security.x509.CertPathPKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.PKIXValidationOptions;
import org.opensaml.xml.security.x509.StaticPKIXValidationInformationResolver;
import org.opensaml.xml.signature.impl.PKIXSignatureTrustEngine;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class StaticPKIXSignatureTrustEngineFactoryBean
extends AbstractFactoryBean {
    private List<PKIXValidationInformation> pkixInfo;
    private Set<String> trustedNames;
    private PKIXValidationOptions pkixOptions;

    public PKIXValidationOptions getPKIXValidationOptions() {
        return this.pkixOptions;
    }

    public void setPKIXValidationOptions(PKIXValidationOptions newOptions) {
        this.pkixOptions = newOptions;
    }

    public List<PKIXValidationInformation> getPKIXInfo() {
        return this.pkixInfo;
    }

    public void setPKIXInfo(List<PKIXValidationInformation> newPKIXInfo) {
        this.pkixInfo = newPKIXInfo;
    }

    public Set<String> getTrustedNames() {
        return this.trustedNames;
    }

    public void setTrustedNames(Set<String> newTrustedNames) {
        this.trustedNames = newTrustedNames;
    }

    public Class getObjectType() {
        return PKIXSignatureTrustEngine.class;
    }

    protected Object createInstance() throws Exception {
        Set<String> names = this.getTrustedNames();
        if (names == null) {
            names = Collections.emptySet();
        }
        StaticPKIXValidationInformationResolver pkixResolver = new StaticPKIXValidationInformationResolver(this.getPKIXInfo(), names);
        ArrayList<Object> keyInfoProviders = new ArrayList<Object>();
        keyInfoProviders.add(new DSAKeyValueProvider());
        keyInfoProviders.add(new RSAKeyValueProvider());
        keyInfoProviders.add(new InlineX509DataProvider());
        BasicProviderKeyInfoCredentialResolver keyInfoCredResolver = new BasicProviderKeyInfoCredentialResolver(keyInfoProviders);
        PKIXSignatureTrustEngine engine = new PKIXSignatureTrustEngine((PKIXValidationInformationResolver)pkixResolver, (KeyInfoCredentialResolver)keyInfoCredResolver);
        if (this.getPKIXValidationOptions() != null) {
            ((CertPathPKIXTrustEvaluator)engine.getPKIXTrustEvaluator()).setPKIXValidationOptions(this.getPKIXValidationOptions());
        }
        return engine;
    }
}

