/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.metadata;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import java.util.List;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class BaseMetadataProviderBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(BaseMetadataProviderBeanDefinitionParser.class);

    protected void doParse(Element config, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String id = this.getProviderId(config);
        this.log.debug("Parsing configuration for '{}' metadata provider with ID: {}", (Object)XMLHelper.getXSIType((Element)config).getLocalPart(), (Object)id);
        boolean requireValidMetadata = this.getRequireValidMetadata(config);
        this.log.debug("Metadata provider requires valid metadata: {}", (Object)requireValidMetadata);
        builder.addPropertyValue("requireValidMetadata", (Object)requireValidMetadata);
        List childElems = XMLHelper.getChildElementsByTagNameNS((Element)config, (String)"urn:mace:shibboleth:2.0:metadata", (String)"MetadataFilter");
        if (childElems.size() > 0) {
            builder.addPropertyValue("metadataFilter", (Object)SpringConfigurationUtils.parseInnerCustomElement((Element)childElems.get(0), parserContext));
        }
    }

    protected boolean getRequireValidMetadata(Element config) {
        boolean requireValidMetadata = true;
        if (config.hasAttributeNS(null, "maintainExpiredMetadata")) {
            boolean maintainedExpiredMetadata = XMLHelper.getAttributeValueAsBoolean((Attr)config.getAttributeNodeNS(null, "maintainExpiredMetadata"));
            requireValidMetadata = !maintainedExpiredMetadata;
            this.log.warn("Use of metadata provider configuration attribute 'maintainExpiredMetadata' is deprecated.  Use requireValidMetadata=\"{}\" instead.", (Object)requireValidMetadata);
        }
        if (config.hasAttributeNS(null, "requireValidMetadata")) {
            requireValidMetadata = XMLHelper.getAttributeValueAsBoolean((Attr)config.getAttributeNodeNS(null, "requireValidMetadata"));
        }
        return requireValidMetadata;
    }

    protected String getProviderId(Element config) {
        return DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "id"));
    }
}

