/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import edu.internet2.middleware.shibboleth.common.util.VelocityStringResourceRepositoryAdaptor;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateAttributeDefinition
extends BaseAttributeDefinition {
    private final Logger log = LoggerFactory.getLogger(TemplateAttributeDefinition.class);
    private final VelocityEngine velocity;
    private String templateName;
    private String attributeTemplate;
    private List<String> sourceAttributes;
    private boolean checkAttributeDependencies;

    public TemplateAttributeDefinition(VelocityEngine newVelocityEngine) {
        this.velocity = newVelocityEngine;
        this.sourceAttributes = new ArrayList<String>();
        this.checkAttributeDependencies = true;
    }

    @Override
    protected BaseAttribute doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        if (this.checkAttributeDependencies) {
            this.checkAttributeDependencies(resolutionContext);
        }
        HashMap<String, Iterator<Object>> sourceValues = new HashMap<String, Iterator<Object>>();
        BasicAttribute attribute = new BasicAttribute();
        attribute.setId(this.getId());
        int valueCount = -1;
        for (String attributeId : this.sourceAttributes) {
            Collection<Object> values = this.getValuesFromAllDependencies(resolutionContext, attributeId);
            if (valueCount == -1) {
                valueCount = values.size();
            } else if (valueCount != values.size()) {
                this.log.error("All attributes used in TemplateAttributeDefinition " + this.getId() + " must have the same number of values.");
                throw new AttributeResolutionException("All attributes used in TemplateAttributeDefinition " + this.getId() + " must have the same number of values.");
            }
            sourceValues.put(attributeId, values.iterator());
        }
        VelocityContext vCtx = new VelocityContext();
        vCtx.put("requestContext", (Object)resolutionContext.getAttributeRequestContext());
        for (int i = 0; i < valueCount; ++i) {
            for (String attributeId : sourceValues.keySet()) {
                vCtx.put(attributeId, ((Iterator)sourceValues.get(attributeId)).next());
            }
            try {
                this.log.debug("Populating the following {} template", (Object)this.templateName);
                StringWriter output = new StringWriter();
                Template template = this.velocity.getTemplate(this.templateName);
                template.merge((Context)vCtx, (Writer)output);
                attribute.getValues().add(output.toString());
                continue;
            }
            catch (Exception e) {
                this.log.error("Unable to populate " + this.templateName + " template", (Throwable)e);
                throw new AttributeResolutionException("Unable to evaluate template", e);
            }
        }
        return attribute;
    }

    private void checkAttributeDependencies(ShibbolethResolutionContext resolutionContext) {
        if (!this.checkAttributeDependencies) {
            return;
        }
        this.checkAttributeDependencies = false;
        int numAttributeDeps = 0;
        for (String id : this.getDependencyIds()) {
            if (!resolutionContext.getResolvedAttributeDefinitions().containsKey(id)) continue;
            ++numAttributeDeps;
        }
        if (numAttributeDeps > 1) {
            this.log.error("Template AttributeDefinition may have a maximum of 1 AttributeDefinition dependency, saw: {}. Output from the definition will not be what is expected.", (Object)numAttributeDeps);
        }
    }

    public void initialize() throws Exception {
        if (DatatypeHelper.isEmpty((String)this.attributeTemplate)) {
            StringBuffer defaultTemplate = new StringBuffer();
            for (String id : this.sourceAttributes) {
                defaultTemplate.append("${").append(id).append("} ");
            }
            this.attributeTemplate = defaultTemplate.toString();
        }
        this.registerTemplate();
    }

    protected void registerTemplate() {
        try {
            StringResourceRepository repository = VelocityStringResourceRepositoryAdaptor.getRepository(this.velocity);
            this.templateName = "shibboleth.resolver.ad." + this.getId();
            repository.putStringResource(this.templateName, this.attributeTemplate.trim());
        }
        catch (VelocityException e) {
            this.log.error("Unable to register template into Velocity string repository", (Throwable)e);
        }
    }

    @Override
    public void validate() throws AttributeResolutionException {
    }

    public String getAttributeTemplate() {
        return this.attributeTemplate;
    }

    public void setAttributeTemplate(String newAttributeTemplate) {
        this.attributeTemplate = newAttributeTemplate;
    }

    public List<String> getSourceAttributes() {
        return this.sourceAttributes;
    }

    public void setSourceAttributes(List<String> newSourceAttributes) {
        this.sourceAttributes = newSourceAttributes;
    }
}

