/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.provider;

import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestException;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncodingException;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML2AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethAttributeFilteringEngine;
import edu.internet2.middleware.shibboleth.common.attribute.provider.SAML2AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethAttributeResolver;
import edu.internet2.middleware.shibboleth.common.config.BaseService;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml2.AbstractSAML2ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ShibbolethSAML2AttributeAuthority
extends BaseService
implements SAML2AttributeAuthority {
    private final Logger log = LoggerFactory.getLogger(ShibbolethSAML2AttributeAuthority.class);
    private SAMLObjectBuilder<AttributeStatement> statementBuilder;
    private ShibbolethAttributeResolver attributeResolver;
    private ShibbolethAttributeFilteringEngine filteringEngine;

    public ShibbolethSAML2AttributeAuthority(ShibbolethAttributeResolver resolver) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        this.statementBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        this.attributeResolver = resolver;
    }

    public ShibbolethAttributeResolver getAttributeResolver() {
        return this.attributeResolver;
    }

    public ShibbolethAttributeFilteringEngine getFilteringEngine() {
        return this.filteringEngine;
    }

    public void setFilteringEngine(ShibbolethAttributeFilteringEngine engine) {
        this.filteringEngine = engine;
    }

    @Override
    public AttributeStatement buildAttributeStatement(AttributeQuery query, Collection<BaseAttribute> attributes) throws AttributeEncodingException {
        Collection<Attribute> encodedAttributes = this.encodeAttributes(query, attributes);
        this.filterAttributesByValue(query, encodedAttributes);
        if (!encodedAttributes.isEmpty()) {
            AttributeStatement statement = (AttributeStatement)this.statementBuilder.buildObject();
            List samlAttributes = statement.getAttributes();
            samlAttributes.addAll(encodedAttributes);
            return statement;
        }
        this.log.debug("No attributes remained after encoding and filtering by value, no attribute statement built");
        return null;
    }

    @Override
    public String getAttributeIDBySAMLAttribute(Attribute attribute) {
        return null;
    }

    @Override
    public Attribute getSAMLAttributeByAttributeID(String id) {
        return null;
    }

    @Override
    public String getPrincipal(SAMLProfileRequestContext<? extends RequestAbstractType, ? extends StatusResponseType, NameID, ? extends AbstractSAML2ProfileConfiguration> requestContext) throws AttributeRequestException {
        if (requestContext.getInboundMessageIssuer() == null || requestContext.getSubjectNameIdentifier() == null) {
            throw new AttributeRequestException("Unable to resolve principal, attribute request ID and subject name identifier may not be null");
        }
        return this.attributeResolver.resolvePrincipalName(requestContext);
    }

    @Override
    public Map<String, BaseAttribute> getAttributes(SAMLProfileRequestContext<? extends RequestAbstractType, ? extends StatusResponseType, NameID, ? extends AbstractSAML2ProfileConfiguration> requestContext) throws AttributeRequestException {
        HashSet<String> requestedAttributes = new HashSet<String>();
        Set<String> queryAttributeIds = this.getAttributeIds((RequestAbstractType)requestContext.getInboundSAMLMessage());
        requestedAttributes.addAll(queryAttributeIds);
        Set<String> metadataAttributeIds = this.getAttribtueIds(requestContext.getPeerEntityMetadata());
        requestedAttributes.addAll(metadataAttributeIds);
        requestContext.setRequestedAttributes(requestedAttributes);
        Map<String, BaseAttribute> attributes = this.attributeResolver.resolveAttributes(requestContext);
        if (this.filteringEngine != null) {
            attributes = this.filteringEngine.filterAttributes(attributes, requestContext);
        }
        return attributes;
    }

    protected Collection<Attribute> encodeAttributes(AttributeQuery query, Collection<BaseAttribute> attributes) throws AttributeEncodingException {
        ArrayList<Attribute> encodedAttributes = new ArrayList<Attribute>();
        List designators = null;
        if (query != null && (designators = query.getAttributes()) != null && designators.isEmpty()) {
            designators = null;
        }
        for (BaseAttribute shibbolethAttribute : attributes) {
            if (shibbolethAttribute.getValues() == null || shibbolethAttribute.getValues().size() == 0) continue;
            boolean attributeEncoded = false;
            for (AttributeEncoder encoder : shibbolethAttribute.getEncoders()) {
                if (!(encoder instanceof SAML2AttributeEncoder)) continue;
                boolean worthEncoding = true;
                if (designators != null) {
                    worthEncoding = false;
                    for (Attribute designator : designators) {
                        if (!DatatypeHelper.safeEquals((Object)designator.getName(), (Object)encoder.getAttributeName())) continue;
                        String nf1 = designator.getNameFormat();
                        String nf2 = ((SAML2AttributeEncoder)encoder).getNameFormat();
                        if (nf1 != null && nf1.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified")) {
                            nf1 = null;
                        }
                        if (nf2 != null && nf2.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified")) {
                            nf2 = null;
                        }
                        if (!DatatypeHelper.safeEquals((Object)nf1, (Object)nf2)) continue;
                        worthEncoding = true;
                        break;
                    }
                }
                if (worthEncoding) {
                    try {
                        Attribute attribute = (Attribute)encoder.encode(shibbolethAttribute);
                        if (attribute == null) continue;
                        encodedAttributes.add(attribute);
                        attributeEncoded = true;
                        this.log.debug("Encoded attribute {} with encoder of type {}", (Object)shibbolethAttribute.getId(), (Object)encoder.getClass().getName());
                    }
                    catch (AttributeEncodingException e) {
                        this.log.warn("unable to encode attribute: " + shibbolethAttribute.getId(), (Throwable)e);
                    }
                    continue;
                }
                this.log.debug("Skipped encoding of attribute {} because the resulting name was excluded by the query", (Object)shibbolethAttribute.getId());
            }
            if (attributeEncoded) continue;
            this.log.debug("Attribute {} was not encoded (filtered by query, or no SAML2AttributeEncoder attached).", (Object)shibbolethAttribute.getId());
        }
        return encodedAttributes;
    }

    protected void filterAttributesByValue(AttributeQuery query, Collection<Attribute> attributes) {
        if (query == null) {
            return;
        }
    }

    protected Set<String> getAttributeIds(RequestAbstractType samlRequest) {
        Set<String> queryAttributeIds = new HashSet<String>();
        if (!(samlRequest instanceof AttributeQuery)) {
            return queryAttributeIds;
        }
        AttributeQuery query = (AttributeQuery)samlRequest;
        if (query != null) {
            List queryAttributes = query.getAttributes();
            queryAttributeIds = this.getAttributeIds(queryAttributes);
            this.log.debug("query message contains the following attributes: {}", queryAttributeIds);
        }
        return queryAttributeIds;
    }

    protected Set<String> getAttribtueIds(EntityDescriptor metadata) {
        AttributeAuthorityDescriptor aaDescriptor;
        Set<String> metadataAttributeIds = new HashSet<String>();
        if (metadata != null && (aaDescriptor = metadata.getAttributeAuthorityDescriptor("urn:oasis:names:tc:SAML:2.0:protocol")) != null) {
            List metadataAttributes = aaDescriptor.getAttributes();
            metadataAttributeIds = this.getAttributeIds(metadataAttributes);
            this.log.debug("metadata contains the following attributes: {}", metadataAttributeIds);
        }
        return metadataAttributeIds;
    }

    protected Set<String> getAttributeIds(List<Attribute> attributes) {
        HashSet<String> attributeIds = new HashSet<String>();
        for (Attribute a : attributes) {
            String attrId = this.getAttributeIDBySAMLAttribute(a);
            if (attrId == null) continue;
            attributeIds.add(attrId);
        }
        return attributeIds;
    }

    @Override
    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
    }
}

