/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.saml;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML1AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML2AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractMatchFunctor;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSBase64Binary;
import org.opensaml.xml.schema.XSBoolean;
import org.opensaml.xml.schema.XSDateTime;
import org.opensaml.xml.schema.XSInteger;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.XSURI;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeInMetadataMatchFunctor
extends AbstractMatchFunctor {
    private final Logger log = LoggerFactory.getLogger(AttributeInMetadataMatchFunctor.class);
    private boolean onlyIfRequired;
    private boolean matchIfMetadataSilent;
    private String attributeName;
    private String attributeNameFormat;

    public boolean isOnlyIfRequired() {
        return this.onlyIfRequired;
    }

    public void setOnlyIfRequired(boolean flag) {
        this.onlyIfRequired = flag;
    }

    public boolean isMatchIfMetadataSilent() {
        return this.matchIfMetadataSilent;
    }

    public void setMatchIfMetadataSilent(boolean flag) {
        this.matchIfMetadataSilent = flag;
    }

    public void setAttributeName(String name) {
        this.attributeName = DatatypeHelper.safeTrimOrNullString((String)name);
    }

    public void setAttributeNameFormat(String format) {
        this.attributeNameFormat = DatatypeHelper.safeTrimOrNullString((String)format);
        if (this.attributeNameFormat != null && "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified".equals(this.attributeNameFormat)) {
            this.attributeNameFormat = null;
        }
    }

    @Override
    protected boolean doEvaluatePolicyRequirement(ShibbolethFilteringContext filterContext) throws FilterProcessingException {
        Integer i;
        if (this.attributeName == null) {
            throw new FilterProcessingException("This match functor is not supported in policy requirements without explicit attributeName");
        }
        RoleDescriptor role = filterContext.getAttributeRequestContext().getPeerEntityRoleMetadata();
        if (!(role instanceof SPSSODescriptor)) {
            this.log.debug("attribute requester's metadata role does not contain attribute requirements");
            return false;
        }
        AttributeConsumingService service = null;
        SAMLObject inbound = filterContext.getAttributeRequestContext().getInboundSAMLMessage();
        if (inbound != null && inbound instanceof AuthnRequest && (i = ((AuthnRequest)inbound).getAttributeConsumingServiceIndex()) != null) {
            List services = ((SPSSODescriptor)role).getAttributeConsumingServices();
            for (AttributeConsumingService s : services) {
                if (s.getIndex() != i.intValue()) continue;
                service = s;
                break;
            }
            if (service == null) {
                this.log.warn("Incoming AuthnRequest's AttributeConsumingServiceIndex did not match peer's metadata");
                return false;
            }
        }
        if (service == null) {
            service = ((SPSSODescriptor)role).getDefaultAttributeConsumingService();
        }
        if (service == null) {
            this.log.debug("The peer's metadata did not contain an AttributeConsumingService descriptor");
            return this.matchIfMetadataSilent;
        }
        this.log.debug("Using AttributeConsumingService descriptor with index {}", (Object)service.getIndex());
        this.log.debug("Looking for RequestedAttribute {} (NameFormat {}) in descriptor", (Object)this.attributeName, (Object)this.attributeNameFormat);
        RequestedAttribute requestedAttribute = this.findInMetadata(service, this.attributeName, this.attributeNameFormat);
        if (requestedAttribute != null) {
            if (this.onlyIfRequired && !requestedAttribute.isRequired().booleanValue()) {
                this.log.debug("Attribute {} in metadata, but was not required", (Object)this.attributeName);
                return false;
            }
            this.log.debug("Found attribute {} in metadata", (Object)this.attributeName);
            return true;
        }
        this.log.debug("Attribute {} not found in metadata", (Object)this.attributeName);
        return false;
    }

    @Override
    protected boolean doEvaluateValue(ShibbolethFilteringContext filterContext, String attributeId, Object attributeValue) throws FilterProcessingException {
        String attributeToLog;
        Integer i;
        RoleDescriptor role = filterContext.getAttributeRequestContext().getPeerEntityRoleMetadata();
        if (!(role instanceof SPSSODescriptor)) {
            this.log.debug("attribute requester's metadata role does not contain attribute requirements");
            return false;
        }
        AttributeConsumingService service = null;
        SAMLObject inbound = filterContext.getAttributeRequestContext().getInboundSAMLMessage();
        if (inbound != null && inbound instanceof AuthnRequest && (i = ((AuthnRequest)inbound).getAttributeConsumingServiceIndex()) != null) {
            List services = ((SPSSODescriptor)role).getAttributeConsumingServices();
            for (AttributeConsumingService s : services) {
                if (s.getIndex() != i.intValue()) continue;
                service = s;
                break;
            }
            if (service == null) {
                this.log.warn("Incoming AuthnRequest's AttributeConsumingServiceIndex did not match peer's metadata");
                return false;
            }
        }
        if (service == null) {
            service = ((SPSSODescriptor)role).getDefaultAttributeConsumingService();
        }
        if (service == null) {
            this.log.debug("The peer's metadata did not contain an AttributeConsumingService descriptor");
            return this.matchIfMetadataSilent;
        }
        this.log.debug("Using AttributeConsumingService descriptor with index {}", (Object)service.getIndex());
        RequestedAttribute requestedAttribute = null;
        if (this.attributeName != null) {
            this.log.debug("Looking for RequestedAttribute {} (NameFormat {}) in descriptor", (Object)this.attributeName, (Object)this.attributeNameFormat);
            requestedAttribute = this.findInMetadata(service, this.attributeName, this.attributeNameFormat);
        } else {
            BaseAttribute attr = filterContext.getUnfilteredAttributes().get(attributeId);
            if (attr != null) {
                AttributeEncoder encoder;
                List<AttributeEncoder> encoders = attr.getEncoders();
                Iterator<AttributeEncoder> i2 = encoders.iterator();
                while (i2.hasNext() && (requestedAttribute = this.findInMetadata(service, encoder = i2.next())) == null) {
                }
            }
        }
        String string = attributeToLog = this.attributeName != null ? this.attributeName : attributeId;
        if (requestedAttribute != null) {
            if (this.onlyIfRequired && !requestedAttribute.isRequired().booleanValue()) {
                this.log.debug("Attribute {} in metadata, but was not required", (Object)attributeToLog);
                return false;
            }
            this.log.debug("Found attribute {} in metadata", (Object)attributeToLog);
            List vals = requestedAttribute.getAttributeValues();
            if (vals == null || vals.isEmpty()) {
                return true;
            }
            String v = attributeValue.toString();
            for (XMLObject xmlObj : vals) {
                if (!this.match(xmlObj, v)) continue;
                return true;
            }
            this.log.debug("Attribute {} found, but value not among those requested", (Object)attributeToLog);
            return false;
        }
        this.log.debug("Attribute {} not found in metadata", (Object)attributeToLog);
        return false;
    }

    private RequestedAttribute findInMetadata(AttributeConsumingService service, AttributeEncoder encoder) {
        String qualifier = null;
        if (encoder instanceof SAML2AttributeEncoder) {
            qualifier = ((SAML2AttributeEncoder)encoder).getNameFormat();
        } else if (encoder instanceof SAML1AttributeEncoder) {
            qualifier = ((SAML1AttributeEncoder)encoder).getNamespace();
        }
        return this.findInMetadata(service, encoder.getAttributeName(), qualifier);
    }

    private RequestedAttribute findInMetadata(AttributeConsumingService service, String name, String nameFormat) {
        List requested = service.getRequestAttributes();
        for (RequestedAttribute attr : requested) {
            if (!attr.getName().equals(name)) continue;
            String format = attr.getNameFormat();
            if (nameFormat != null && format != null && !format.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified") && !nameFormat.equals(format)) continue;
            return attr;
        }
        return null;
    }

    private boolean match(XMLObject xmlObj, String attributeValue) {
        XSAny wc;
        String toMatch = null;
        if (xmlObj instanceof XSString) {
            toMatch = ((XSString)xmlObj).getValue();
        } else if (xmlObj instanceof XSURI) {
            toMatch = ((XSURI)xmlObj).getValue();
        } else if (xmlObj instanceof XSBoolean) {
            toMatch = ((XSBoolean)xmlObj).getValue().getValue() != false ? "1" : "0";
        } else if (xmlObj instanceof XSInteger) {
            toMatch = ((XSInteger)xmlObj).getValue().toString();
        } else if (xmlObj instanceof XSDateTime) {
            DateTime dt = ((XSDateTime)xmlObj).getValue();
            if (dt != null) {
                toMatch = ((XSDateTime)xmlObj).getDateTimeFormatter().print((ReadableInstant)dt);
            }
        } else if (xmlObj instanceof XSBase64Binary) {
            toMatch = ((XSBase64Binary)xmlObj).getValue();
        } else if (xmlObj instanceof XSAny && (wc = (XSAny)xmlObj).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            toMatch = wc.getTextContent();
        }
        if (toMatch != null) {
            return toMatch.equals(attributeValue);
        }
        this.log.warn("Unrecognized XMLObject type, unable to match as a string to candidate value");
        return false;
    }
}

