/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.saml;

import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractMatchFunctor;
import java.util.List;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.SSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNameIDFormatSupportedMatchFunctor
extends AbstractMatchFunctor {
    private final Logger log = LoggerFactory.getLogger(AbstractNameIDFormatSupportedMatchFunctor.class);
    private String nameIdFormat;

    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public void setNameIdFormat(String format) {
        this.nameIdFormat = format;
    }

    @Override
    protected boolean doEvaluatePolicyRequirement(ShibbolethFilteringContext filterContext) throws FilterProcessingException {
        return this.isNameIDFormatSupported(filterContext);
    }

    @Override
    protected boolean doEvaluateValue(ShibbolethFilteringContext filterContext, String attributeId, Object attributeValue) throws FilterProcessingException {
        return this.isNameIDFormatSupported(filterContext);
    }

    protected boolean isNameIDFormatSupported(ShibbolethFilteringContext filterContext) {
        SSODescriptor role = this.getEntitySSODescriptor(filterContext);
        if (role == null) {
            this.log.debug("entity does contain an appropriate SSO role descriptor");
            return false;
        }
        List supportedFormats = role.getNameIDFormats();
        if (supportedFormats == null || supportedFormats.isEmpty()) {
            this.log.debug("entity SSO role descriptor does not list any supported NameID formats");
            return false;
        }
        for (NameIDFormat supportedFormat : supportedFormats) {
            if (!this.nameIdFormat.equals(supportedFormat.getFormat())) continue;
            this.log.debug("entity does support the NameID format '{}'", (Object)this.nameIdFormat);
            return true;
        }
        this.log.debug("entity does not support the NameID format '{}'", (Object)this.nameIdFormat);
        return false;
    }

    protected abstract SSODescriptor getEntitySSODescriptor(ShibbolethFilteringContext var1);
}

