/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic;

import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.MatchFunctor;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractMatchFunctor;
import java.util.List;

public class OrMatchFunctor
extends AbstractMatchFunctor {
    private List<MatchFunctor> targetRules;

    public OrMatchFunctor(List<MatchFunctor> rules) {
        this.targetRules = rules;
    }

    public List<MatchFunctor> getTargetRules() {
        return this.targetRules;
    }

    @Override
    protected boolean doEvaluatePolicyRequirement(ShibbolethFilteringContext filterContext) throws FilterProcessingException {
        if (this.targetRules == null) {
            return false;
        }
        for (MatchFunctor child : this.targetRules) {
            if (!child.evaluatePolicyRequirement(filterContext)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doEvaluateValue(ShibbolethFilteringContext filterContext, String attributeId, Object attributeValue) throws FilterProcessingException {
        if (this.targetRules == null) {
            return false;
        }
        for (MatchFunctor child : this.targetRules) {
            if (!child.evaluatePermitValue(filterContext, attributeId, attributeValue)) continue;
            return true;
        }
        return false;
    }
}

