/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic;

import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractStringMatchFunctor;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttributeTargetedStringMatchFunctor
extends AbstractStringMatchFunctor {
    private final Logger log = LoggerFactory.getLogger(AbstractAttributeTargetedStringMatchFunctor.class);
    private String attributeId;

    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(String id) {
        this.attributeId = DatatypeHelper.safeTrimOrNullString((String)id);
    }

    @Override
    public boolean evaluatePermitValue(ShibbolethFilteringContext filterContext, String id, Object attributeValue) throws FilterProcessingException {
        this.warnOnTargeted(id);
        return super.evaluatePermitValue(filterContext, id, attributeValue);
    }

    protected void warnOnTargeted(String actualId) {
        if (this.attributeId != null) {
            this.log.warn("Ignoring targeted attribute '{}' in permit/deny rule, applying to actual attribute '{}'", (Object)this.attributeId, (Object)actualId);
        }
    }
}

