/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config;

import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.util.resource.Resource;
import org.opensaml.xml.XMLConfigurator;
import org.opensaml.xml.parse.ParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class OpensamlConfigBean
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(OpensamlConfigBean.class);
    private List<Resource> configResources;
    private ParserPool parserPool;

    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(ParserPool newParserPool) {
        this.parserPool = newParserPool;
    }

    public OpensamlConfigBean(List<Resource> configs) {
        this.configResources = configs;
    }

    public void afterPropertiesSet() throws Exception {
        DefaultBootstrap.bootstrap();
        if (this.configResources != null && !this.configResources.isEmpty()) {
            XMLConfigurator configurator = new XMLConfigurator();
            for (Resource config : this.configResources) {
                try {
                    this.log.debug("Loading OpenSAML configuration file: {}", (Object)config.getLocation());
                    configurator.load(config.getInputStream());
                }
                catch (Exception e) {
                    this.log.error("Unable to load OpenSAML configuration file: " + config.getLocation());
                }
            }
        }
        if (this.getParserPool() != null) {
            Configuration.setParserPool((ParserPool)this.getParserPool());
        }
    }
}

