/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ResolutionPlugIn;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.AttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.DataConnector;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedAttributeDefinition
extends BaseAttributeDefinition {
    private final Logger log = LoggerFactory.getLogger(ScriptedAttributeDefinition.class);
    private String scriptLanguage;
    private String script;
    private ScriptEngine scriptEngine;
    private CompiledScript compiledScript;

    public ScriptedAttributeDefinition(String language) {
        this.scriptLanguage = language;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String newScript) {
        this.script = newScript;
        this.compileScript();
    }

    public void initialize() {
        ScriptEngineManager sem = new ScriptEngineManager();
        this.scriptEngine = sem.getEngineByName(this.scriptLanguage);
        this.compileScript();
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.scriptEngine == null) {
            this.log.error("ScriptletAttributeDefinition " + this.getId() + " unable to create scripting engine for the language: " + this.scriptLanguage);
            throw new AttributeResolutionException("ScriptletAttributeDefinition " + this.getId() + " unable to create scripting engine for the language: " + this.scriptLanguage);
        }
    }

    @Override
    protected BaseAttribute<?> doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        ScriptContext context = this.getScriptContext(resolutionContext);
        try {
            if (this.compiledScript != null) {
                this.compiledScript.eval(context);
            } else {
                this.scriptEngine.eval(this.script, context);
            }
            BaseAttribute attribute = (BaseAttribute)context.getAttribute(this.getId());
            if (attribute == null) {
                this.log.error("{} produced a null attribute", (Object)this.getId());
                throw new AttributeResolutionException(this.getId() + " produced a null attributes");
            }
            return attribute;
        }
        catch (ScriptException e) {
            this.log.error("ScriptletAttributeDefinition " + this.getId() + " unable to execute script", (Throwable)e);
            throw new AttributeResolutionException("ScriptletAttributeDefinition " + this.getId() + " unable to execute script", e);
        }
    }

    protected void compileScript() {
        if (DatatypeHelper.isEmpty((String)this.script)) {
            return;
        }
        try {
            if (this.scriptEngine != null && this.scriptEngine instanceof Compilable) {
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(this.script);
            }
        }
        catch (ScriptException e) {
            this.compiledScript = null;
            this.log.warn("{} unable to compile even though the scripting engine supports this functionality.", (Object)this.getId());
        }
    }

    protected ScriptContext getScriptContext(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute(this.getId(), null, 100);
        scriptContext.setAttribute("requestContext", resolutionContext.getAttributeRequestContext(), 100);
        if (!this.getDependencyIds().isEmpty()) {
            for (String dependency : this.getDependencyIds()) {
                BaseAttribute attribute;
                ResolutionPlugIn plugin = resolutionContext.getResolvedPlugins().get(dependency);
                if (plugin instanceof DataConnector) {
                    Map attributes = (Map)((DataConnector)plugin).resolve(resolutionContext);
                    if (attributes == null) continue;
                    for (BaseAttribute attr : attributes.values()) {
                        BasicAttribute copy = new BasicAttribute(attr.getId());
                        copy.getDisplayDescriptions().putAll(attr.getDisplayDescriptions());
                        copy.getDisplayNames().putAll(attr.getDisplayNames());
                        copy.setValueComparator(attr.getValueComparator());
                        copy.setValues(attr.getValues());
                        scriptContext.setAttribute(attr.getId(), copy, 100);
                    }
                    continue;
                }
                if (!(plugin instanceof AttributeDefinition) || (attribute = (BaseAttribute)((AttributeDefinition)plugin).resolve(resolutionContext)) == null) continue;
                BasicAttribute copy = new BasicAttribute(attribute.getId());
                copy.getDisplayDescriptions().putAll(attribute.getDisplayDescriptions());
                copy.getDisplayNames().putAll(attribute.getDisplayNames());
                copy.setValueComparator(attribute.getValueComparator());
                copy.setValues(attribute.getValues());
                scriptContext.setAttribute(attribute.getId(), copy, 100);
            }
        }
        return scriptContext;
    }
}

